/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.classic;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.client5.testing.redirect.Redirect;
import org.apache.hc.client5.testing.redirect.RedirectResolver;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.HttpServerRequestHandler;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public class RedirectingDecorator
implements HttpServerRequestHandler {
    private final HttpServerRequestHandler requestHandler;
    private final RedirectResolver redirectResolver;

    public RedirectingDecorator(HttpServerRequestHandler requestHandler, RedirectResolver redirectResolver) {
        this.requestHandler = (HttpServerRequestHandler)Args.notNull((Object)requestHandler, (String)"Request handler");
        this.redirectResolver = redirectResolver;
    }

    public void handle(ClassicHttpRequest request, HttpServerRequestHandler.ResponseTrigger responseTrigger, HttpContext context) throws HttpException, IOException {
        try {
            Redirect redirect;
            URI requestURI = request.getUri();
            Redirect redirect2 = redirect = this.redirectResolver != null ? this.redirectResolver.resolve(requestURI) : null;
            if (redirect != null) {
                BasicClassicHttpResponse response = new BasicClassicHttpResponse(redirect.status);
                if (redirect.location != null) {
                    response.addHeader((Header)new BasicHeader("Location", (Object)redirect.location));
                }
                switch (redirect.connControl) {
                    case KEEP_ALIVE: {
                        response.addHeader((Header)new BasicHeader("Connection", (Object)"keep-alive"));
                        break;
                    }
                    case CLOSE: {
                        response.addHeader((Header)new BasicHeader("Connection", (Object)"close"));
                    }
                }
                responseTrigger.submitResponse((ClassicHttpResponse)response);
            } else {
                this.requestHandler.handle(request, responseTrigger, context);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException(ex.getMessage(), (Throwable)ex);
        }
    }
}

