/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_BatchSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_BatchSpannerRead_PartitionedReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.LoadingCache;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
abstract class BatchSpannerRead
extends PTransform<PCollection<ReadOperation>, PCollection<Struct>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BatchSpannerRead.class);

    BatchSpannerRead() {
    }

    public static @UnknownKeyFor @NonNull @Initialized BatchSpannerRead create(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> txView, @UnknownKeyFor @NonNull @Initialized TimestampBound timestampBound) {
        return new AutoValue_BatchSpannerRead(spannerConfig, txView, timestampBound);
    }

    abstract @UnknownKeyFor @NonNull @Initialized SpannerConfig getSpannerConfig();

    abstract @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> getTxView();

    abstract @UnknownKeyFor @NonNull @Initialized TimestampBound getTimestampBound();

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Struct> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ReadOperation> input) {
        PCollectionView txView = this.getTxView();
        if (txView == null) {
            Pipeline begin = input.getPipeline();
            SpannerIO.CreateTransaction createTx = SpannerIO.createTransaction().withSpannerConfig(this.getSpannerConfig()).withTimestampBound(this.getTimestampBound());
            txView = (PCollectionView)begin.apply((PTransform)createTx);
        }
        return (PCollection)((PCollection)((PCollection)input.apply("Generate Partitions", (PTransform)ParDo.of((DoFn)new GeneratePartitionsFn(this.getSpannerConfig(), txView)).withSideInputs(new PCollectionView[]{txView}))).apply("Shuffle partitions", (PTransform)Reshuffle.viaRandomKey())).apply("Read from Partitions", (PTransform)ParDo.of((DoFn)new ReadFromPartitionFn(this.getSpannerConfig(), (PCollectionView<? extends Transaction>)txView)).withSideInputs(new PCollectionView[]{txView}));
    }

    private static class ReadFromPartitionFn
    extends DoFn<PartitionedReadOperation, Struct> {
        private final @UnknownKeyFor @NonNull @Initialized SpannerConfig config;
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Transaction> txView;
        private transient @UnknownKeyFor @NonNull @Initialized SpannerAccessor spannerAccessor;
        private transient @UnknownKeyFor @NonNull @Initialized LoadingCache<@UnknownKeyFor @NonNull @Initialized ReadOperation, @UnknownKeyFor @NonNull @Initialized ServiceCallMetric> metricsForReadOperation;

        public ReadFromPartitionFn(@UnknownKeyFor @NonNull @Initialized SpannerConfig config, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Transaction> txView) {
            this.config = config;
            this.txView = txView;
        }

        @DoFn.Setup
        public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.spannerAccessor = SpannerAccessor.getOrCreate(this.config);
            this.metricsForReadOperation = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<ReadOperation, ServiceCallMetric>(){

                public @UnknownKeyFor @NonNull @Initialized ServiceCallMetric load(@UnknownKeyFor @NonNull @Initialized ReadOperation op) {
                    return SpannerIO.ReadAll.buildServiceCallMetricForReadOp(config, op);
                }
            });
        }

        @DoFn.Teardown
        public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.spannerAccessor.close();
            this.metricsForReadOperation.invalidateAll();
            this.metricsForReadOperation.cleanUp();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Transaction tx = (Transaction)c.sideInput(this.txView);
            BatchReadOnlyTransaction batchTx = this.spannerAccessor.getBatchClient().batchReadOnlyTransaction(tx.transactionId());
            PartitionedReadOperation op = (PartitionedReadOperation)c.element();
            ServiceCallMetric serviceCallMetric = (ServiceCallMetric)this.metricsForReadOperation.get((Object)op.getReadOperation());
            try (ResultSet resultSet = batchTx.execute(op.getPartition());){
                while (resultSet.next()) {
                    Struct s = resultSet.getCurrentRowAsStruct();
                    c.output((Object)s);
                }
            }
            catch (SpannerException e) {
                serviceCallMetric.call(e.getErrorCode().getGrpcStatusCode().toString());
                LOG.error("Error while processing element", (Throwable)e);
                throw e;
            }
            serviceCallMetric.call("ok");
        }
    }

    @VisibleForTesting
    static class GeneratePartitionsFn
    extends DoFn<ReadOperation, PartitionedReadOperation> {
        private final @UnknownKeyFor @NonNull @Initialized SpannerConfig config;
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Transaction> txView;
        private transient @UnknownKeyFor @NonNull @Initialized SpannerAccessor spannerAccessor;

        public GeneratePartitionsFn(@UnknownKeyFor @NonNull @Initialized SpannerConfig config, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Transaction> txView) {
            this.config = config;
            this.txView = txView;
            Preconditions.checkNotNull(config.getRpcPriority());
        }

        @DoFn.Setup
        public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.spannerAccessor = SpannerAccessor.getOrCreate(this.config);
        }

        @DoFn.Teardown
        public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.spannerAccessor.close();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            List partitions;
            Transaction tx = (Transaction)c.sideInput(this.txView);
            BatchReadOnlyTransaction batchTx = this.spannerAccessor.getBatchClient().batchReadOnlyTransaction(tx.transactionId());
            ReadOperation op = (ReadOperation)c.element();
            ServiceCallMetric metric = SpannerIO.ReadAll.buildServiceCallMetricForReadOp(this.config, op);
            try {
                partitions = op.getQuery() != null ? batchTx.partitionQuery(op.getPartitionOptions(), op.getQuery(), new Options.QueryOption[]{Options.priority((Options.RpcPriority)((Options.RpcPriority)this.config.getRpcPriority().get()))}) : (op.getIndex() != null ? batchTx.partitionReadUsingIndex(op.getPartitionOptions(), op.getTable(), op.getIndex(), op.getKeySet(), op.getColumns(), new Options.ReadOption[]{Options.priority((Options.RpcPriority)((Options.RpcPriority)this.config.getRpcPriority().get()))}) : batchTx.partitionRead(op.getPartitionOptions(), op.getTable(), op.getKeySet(), op.getColumns(), new Options.ReadOption[]{Options.priority((Options.RpcPriority)((Options.RpcPriority)this.config.getRpcPriority().get()))}));
                metric.call("ok");
            }
            catch (SpannerException e) {
                metric.call(e.getErrorCode().getGrpcStatusCode().toString());
                throw e;
            }
            for (Partition p : partitions) {
                c.output((Object)PartitionedReadOperation.create(op, p));
            }
        }
    }

    @AutoValue
    protected static abstract class PartitionedReadOperation
    implements Serializable {
        protected PartitionedReadOperation() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized ReadOperation getReadOperation();

        abstract @UnknownKeyFor @NonNull @Initialized Partition getPartition();

        static @UnknownKeyFor @NonNull @Initialized PartitionedReadOperation create(@UnknownKeyFor @NonNull @Initialized ReadOperation readOperation, @UnknownKeyFor @NonNull @Initialized Partition partition) {
            return new AutoValue_BatchSpannerRead_PartitionedReadOperation(readOperation, partition);
        }
    }
}

