/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.PartitionLookupUtils;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.CheckpointMarkImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.CloserReference;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryBufferedSubscriber;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriberAssembler;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartition;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.UnboundedReaderImpl;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class UnboundedSourceImpl
extends UnboundedSource<SequencedMessage, CheckpointMarkImpl> {
    private final @UnknownKeyFor @NonNull @Initialized SubscriberOptions subscriberOptions;
    private final @UnknownKeyFor @NonNull @Initialized SubscriberFactory subscriberFactory;
    private final @UnknownKeyFor @NonNull @Initialized BacklogReaderFactory readerFactory;
    private final @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Partition> partition;

    UnboundedSourceImpl(@UnknownKeyFor @NonNull @Initialized SubscriberOptions subscriberOptions, @UnknownKeyFor @NonNull @Initialized SubscriberFactory subscriberFactory, @UnknownKeyFor @NonNull @Initialized BacklogReaderFactory readerFactory) {
        this.subscriberOptions = subscriberOptions;
        this.subscriberFactory = subscriberFactory;
        this.readerFactory = readerFactory;
        this.partition = Optional.absent();
    }

    private UnboundedSourceImpl(@UnknownKeyFor @NonNull @Initialized SubscriberOptions subscriberOptions, @UnknownKeyFor @NonNull @Initialized SubscriberFactory subscriberFactory, @UnknownKeyFor @NonNull @Initialized BacklogReaderFactory readerFactory, @UnknownKeyFor @NonNull @Initialized Partition partition) {
        this.subscriberOptions = subscriberOptions;
        this.subscriberFactory = subscriberFactory;
        this.readerFactory = readerFactory;
        this.partition = Optional.of((Object)partition);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @NonNull @Initialized SequencedMessage, @UnknownKeyFor @NonNull @Initialized CheckpointMarkImpl>> split(@UnknownKeyFor @NonNull @Initialized int desiredNumSplits, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Preconditions.checkState((!this.partition.isPresent() ? 1 : 0) != 0);
        int numPartitions = PartitionLookupUtils.numPartitions((SubscriptionPath)this.subscriberOptions.subscriptionPath());
        return IntStream.range(0, numPartitions).mapToObj(val -> new UnboundedSourceImpl(this.subscriberOptions, this.subscriberFactory, this.readerFactory, Partition.of((long)val))).collect(Collectors.toList());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<@UnknownKeyFor @NonNull @Initialized SequencedMessage> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @Nullable @UnknownKeyFor @Initialized CheckpointMarkImpl checkpointMark) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkState((boolean)this.partition.isPresent());
        SubscriberAssembler assembler = new SubscriberAssembler(this.subscriberOptions, (Partition)this.partition.get());
        Offset initialOffset = checkpointMark == null ? assembler.getInitialOffsetReader().read() : checkpointMark.offset;
        SubscriptionPartition subscription = SubscriptionPartition.of(this.subscriberOptions.subscriptionPath(), (Partition)this.partition.get());
        MemoryBufferedSubscriber subscriber = this.subscriberFactory.create(subscription, initialOffset);
        return new UnboundedReaderImpl(this, subscriber, this.readerFactory.create(subscription), CloserReference.of(assembler.newCommitter()), initialOffset);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized CheckpointMarkImpl> getCheckpointMarkCoder() {
        return CheckpointMarkImpl.coder();
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized SequencedMessage> getOutputCoder() {
        return ProtoCoder.of(SequencedMessage.class);
    }

    static interface BacklogReaderFactory
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized TopicBacklogReader create(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition var1);
    }

    static interface SubscriberFactory
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized MemoryBufferedSubscriber create(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition var1, @UnknownKeyFor @NonNull @Initialized Offset var2);
    }
}

