/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.value.AutoValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubRowToMessage;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubRowToMessage_InputSchemaFactory;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Throwables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

@Internal
@Experimental
@AutoValue
abstract class PubsubRowToMessage
extends PTransform<PCollection<Row>, PCollectionTuple> {
    static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized PubsubMessage> OUTPUT = new TupleTag<PubsubMessage>(){};
    static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> ERROR = new TupleTag<Row>(){};
    static final @UnknownKeyFor @NonNull @Initialized String ERROR_DATA_FIELD_NAME = "data";
    static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field ERROR_MESSAGE_FIELD = Schema.Field.of((String)"error_message", (Schema.FieldType)Schema.FieldType.STRING);
    static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field ERROR_STACK_TRACE_FIELD = Schema.Field.of((String)"error_stack_trace", (Schema.FieldType)Schema.FieldType.STRING);
    static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_KEY_PREFIX = "$";
    static final @UnknownKeyFor @NonNull @Initialized String ATTRIBUTES_KEY_NAME = "pubsub_attributes";
    static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType ATTRIBUTES_FIELD_TYPE = Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.STRING);
    static final @UnknownKeyFor @NonNull @Initialized String EVENT_TIMESTAMP_KEY_NAME = "pubsub_event_timestamp";
    static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType EVENT_TIMESTAMP_FIELD_TYPE = Schema.FieldType.DATETIME;
    static final @UnknownKeyFor @NonNull @Initialized String PAYLOAD_KEY_NAME = "pubsub_payload";
    static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.TypeName PAYLOAD_BYTES_TYPE_NAME = Schema.TypeName.BYTES;
    static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.TypeName PAYLOAD_ROW_TYPE_NAME = Schema.TypeName.ROW;
    static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_ATTRIBUTES_KEY_NAME = "$pubsub_attributes";
    static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_EVENT_TIMESTAMP_KEY_NAME = "$pubsub_event_timestamp";
    static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_PAYLOAD_KEY_NAME = "$pubsub_payload";

    PubsubRowToMessage() {
    }

    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_PubsubRowToMessage.Builder();
    }

    abstract @UnknownKeyFor @NonNull @Initialized String getKeyPrefix();

    @javax.annotation.Nullable
    abstract @UnknownKeyFor @Nullable @Initialized PayloadSerializer getPayloadSerializer();

    @javax.annotation.Nullable
    abstract @UnknownKeyFor @Nullable @Initialized String getTargetTimestampAttributeName();

    @javax.annotation.Nullable
    abstract @UnknownKeyFor @Nullable @Initialized Instant getMockInstant();

    static @UnknownKeyFor @NonNull @Initialized Schema errorSchema(@UnknownKeyFor @NonNull @Initialized Schema inputSchema) {
        Schema.Field dataField = Schema.Field.of((String)ERROR_DATA_FIELD_NAME, (Schema.FieldType)Schema.FieldType.row((Schema)inputSchema));
        return Schema.of((Schema.Field[])new Schema.Field[]{dataField, ERROR_MESSAGE_FIELD, ERROR_STACK_TRACE_FIELD});
    }

    @UnknownKeyFor @NonNull @Initialized InputSchemaFactory inputSchemaFactory() {
        return this.inputSchemaFactory(null);
    }

    @UnknownKeyFor @NonNull @Initialized InputSchemaFactory inputSchemaFactory(@javax.annotation.Nullable // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @Nullable @Initialized Schema.FieldType payloadFieldType) {
        InputSchemaFactory.Builder builder = InputSchemaFactory.builder().setAttributesField(Schema.Field.of((String)this.getAttributesKeyName(), (Schema.FieldType)ATTRIBUTES_FIELD_TYPE)).setTimestampField(Schema.Field.of((String)this.getSourceEventTimestampKeyName(), (Schema.FieldType)EVENT_TIMESTAMP_FIELD_TYPE));
        if (payloadFieldType != null) {
            builder = builder.setPayloadField(Schema.Field.of((String)this.getPayloadKeyName(), (Schema.FieldType)payloadFieldType));
        }
        return builder.build();
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
        Schema schema = input.getSchema();
        this.validate(schema);
        Schema errorSchema = PubsubRowToMessage.errorSchema(schema);
        PCollectionTuple pct = (PCollectionTuple)input.apply(PubsubRowToMessage.class.getSimpleName(), (PTransform)ParDo.of((DoFn)new PubsubRowToMessageDoFn(this.getAttributesKeyName(), this.getSourceEventTimestampKeyName(), this.getPayloadKeyName(), errorSchema, this.getTargetTimestampAttributeName(), this.getMockInstant(), this.getPayloadSerializer())).withOutputTags(OUTPUT, TupleTagList.of(ERROR)));
        PCollection output = pct.get(OUTPUT);
        PCollection error = pct.get(ERROR).setRowSchema(errorSchema);
        return PCollectionTuple.of(OUTPUT, (PCollection)output).and(ERROR, error);
    }

    @UnknownKeyFor @NonNull @Initialized String getAttributesKeyName() {
        return this.getKeyPrefix() + ATTRIBUTES_KEY_NAME;
    }

    @UnknownKeyFor @NonNull @Initialized String getSourceEventTimestampKeyName() {
        return this.getKeyPrefix() + EVENT_TIMESTAMP_KEY_NAME;
    }

    @UnknownKeyFor @NonNull @Initialized String getPayloadKeyName() {
        return this.getKeyPrefix() + PAYLOAD_KEY_NAME;
    }

    void validate(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        if (schema.getFieldCount() == 0) {
            throw new IllegalArgumentException(String.format("Schema must contain at least one field. Schema: %s", schema));
        }
        this.validateAttributesField(schema);
        this.validateSourceEventTimeStampField(schema);
        this.validateSerializableFields(schema);
    }

    void validateAttributesField(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        String attributesKeyName = this.getAttributesKeyName();
        if (!schema.hasField(attributesKeyName)) {
            return;
        }
        Preconditions.checkArgument((boolean)SchemaReflection.of(schema).matchesAll(FieldMatcher.of(attributesKeyName, ATTRIBUTES_FIELD_TYPE)));
    }

    void validateSourceEventTimeStampField(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        String eventTimestampKeyName = this.getSourceEventTimestampKeyName();
        if (!schema.hasField(eventTimestampKeyName)) {
            return;
        }
        Preconditions.checkArgument((boolean)SchemaReflection.of(schema).matchesAll(FieldMatcher.of(eventTimestampKeyName, EVENT_TIMESTAMP_FIELD_TYPE)));
    }

    void validateSerializableFields(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        String attributesKeyName = this.getAttributesKeyName();
        String eventTimestampKeyName = this.getSourceEventTimestampKeyName();
        String payloadKeyName = this.getPayloadKeyName();
        Schema withUserFieldsOnly = PubsubRowToMessage.removeFields(schema, attributesKeyName, eventTimestampKeyName, payloadKeyName);
        boolean hasUserFields = withUserFieldsOnly.getFieldCount() > 0;
        String withUserFieldsList = String.join((CharSequence)", ", withUserFieldsOnly.getFieldNames());
        SchemaReflection schemaReflection = SchemaReflection.of(schema);
        boolean hasPayloadField = schemaReflection.matchesAll(FieldMatcher.of(payloadKeyName));
        boolean hasPayloadRowField = schemaReflection.matchesAll(FieldMatcher.of(payloadKeyName, PAYLOAD_ROW_TYPE_NAME));
        boolean hasPayloadBytesField = schemaReflection.matchesAll(FieldMatcher.of(payloadKeyName, PAYLOAD_BYTES_TYPE_NAME));
        boolean hasBothUserFieldsAndPayloadField = hasUserFields && hasPayloadField;
        Preconditions.checkArgument((hasUserFields || hasPayloadField ? 1 : 0) != 0, (Object)String.format("schema must have either a %s field or user fields i.e. not %s, %s or %s", payloadKeyName, attributesKeyName, eventTimestampKeyName, payloadKeyName));
        Preconditions.checkArgument((!hasBothUserFieldsAndPayloadField ? 1 : 0) != 0, (Object)String.format("schema field: %s incompatible with %s fields", payloadKeyName, withUserFieldsList));
        if (hasPayloadBytesField) {
            Preconditions.checkArgument((this.getPayloadSerializer() == null ? 1 : 0) != 0, (Object)String.format("schema field: %s of type: %s with a %s is incompatible", payloadKeyName, PAYLOAD_BYTES_TYPE_NAME, PayloadSerializer.class.getName()));
        }
        if (hasPayloadRowField) {
            Preconditions.checkArgument((this.getPayloadSerializer() != null ? 1 : 0) != 0, (Object)String.format("schema field: %s of type: %s requires a %s", payloadKeyName, PAYLOAD_ROW_TYPE_NAME, PayloadSerializer.class.getName()));
        }
        if (hasUserFields) {
            Preconditions.checkArgument((this.getPayloadSerializer() != null ? 1 : 0) != 0, (Object)String.format("specifying schema fields: %s requires a %s", withUserFieldsList, PayloadSerializer.class.getName()));
        }
    }

    static @UnknownKeyFor @NonNull @Initialized Schema removeFields(@UnknownKeyFor @NonNull @Initialized Schema schema, String ... fields) {
        List exclude = Arrays.stream(fields).collect(Collectors.toList());
        Schema.Builder builder = Schema.builder();
        for (Schema.Field field : schema.getFields()) {
            if (exclude.contains(field.getName())) continue;
            builder.addField(field);
        }
        return builder.build();
    }

    @AutoValue
    static abstract class InputSchemaFactory {
        InputSchemaFactory() {
        }

        static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_PubsubRowToMessage_InputSchemaFactory.Builder();
        }

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field getAttributesField();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field getTimestampField();

        @javax.annotation.Nullable
        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @Nullable @Initialized Schema.Field getPayloadField();

        @UnknownKeyFor @NonNull @Initialized Schema buildSchema(Schema.Field ... additionalFields) {
            Schema.Builder builder = Schema.builder().addField(this.getAttributesField()).addField(this.getTimestampField());
            if (this.getPayloadField() != null) {
                builder = builder.addField(this.getPayloadField());
            }
            for (Schema.Field field : additionalFields) {
                builder = builder.addField(field);
            }
            return builder.build();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setAttributesField(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.Field var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTimestampField(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.Field var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setPayloadField(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Schema.Field var1);

            abstract @UnknownKeyFor @NonNull @Initialized InputSchemaFactory build();
        }
    }

    static class PubsubRowToMessageDoFn
    extends DoFn<Row, PubsubMessage> {
        private final @UnknownKeyFor @NonNull @Initialized String attributesKeyName;
        private final @UnknownKeyFor @NonNull @Initialized String sourceTimestampKeyName;
        private final @UnknownKeyFor @NonNull @Initialized String payloadKeyName;
        private final @UnknownKeyFor @NonNull @Initialized Schema errorSchema;
        @javax.annotation.Nullable
        private final @UnknownKeyFor @Nullable @Initialized String targetTimestampKeyName;
        @javax.annotation.Nullable
        private final @UnknownKeyFor @Nullable @Initialized PayloadSerializer payloadSerializer;
        @javax.annotation.Nullable
        private final @UnknownKeyFor @Nullable @Initialized Instant mockInstant;

        PubsubRowToMessageDoFn(@UnknownKeyFor @NonNull @Initialized String attributesKeyName, @UnknownKeyFor @NonNull @Initialized String sourceTimestampKeyName, @UnknownKeyFor @NonNull @Initialized String payloadKeyName, @UnknownKeyFor @NonNull @Initialized Schema errorSchema, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String targetTimestampKeyName, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized Instant mockInstant, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized PayloadSerializer payloadSerializer) {
            this.attributesKeyName = attributesKeyName;
            this.sourceTimestampKeyName = sourceTimestampKeyName;
            this.payloadKeyName = payloadKeyName;
            this.errorSchema = errorSchema;
            this.targetTimestampKeyName = targetTimestampKeyName;
            this.payloadSerializer = payloadSerializer;
            this.mockInstant = mockInstant;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver receiver) {
            try {
                Map<String, String> attributesWithoutTimestamp = this.attributesWithoutTimestamp(row);
                String timestampAsString = this.timestampAsString(row);
                String timestampKeyName = this.sourceTimestampKeyName;
                if (this.targetTimestampKeyName != null) {
                    timestampKeyName = this.targetTimestampKeyName;
                }
                byte[] payload = this.payload(row);
                HashMap<String, String> attributes = new HashMap<String, String>(attributesWithoutTimestamp);
                attributes.put(timestampKeyName, timestampAsString);
                PubsubMessage message = new PubsubMessage(payload, attributes);
                receiver.get(OUTPUT).output((Object)message);
            }
            catch (Exception e) {
                String message = e.getMessage();
                String stackTrace = Throwables.getStackTraceAsString((Throwable)e);
                Row error = Row.withSchema((Schema)this.errorSchema).withFieldValue(PubsubRowToMessage.ERROR_DATA_FIELD_NAME, (Object)row).withFieldValue(ERROR_MESSAGE_FIELD.getName(), (Object)message).withFieldValue(ERROR_STACK_TRACE_FIELD.getName(), (Object)stackTrace).build();
                receiver.get(ERROR).output((Object)error);
            }
        }

        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> attributesWithoutTimestamp(@UnknownKeyFor @NonNull @Initialized Row row) {
            if (!row.getSchema().hasField(this.attributesKeyName)) {
                return new HashMap<String, String>();
            }
            return row.getMap(this.attributesKeyName);
        }

        @UnknownKeyFor @NonNull @Initialized String timestampAsString(@UnknownKeyFor @NonNull @Initialized Row row) {
            return ISODateTimeFormat.dateTime().print((ReadableInstant)this.timestamp(row));
        }

        @UnknownKeyFor @NonNull @Initialized ReadableDateTime timestamp(@UnknownKeyFor @NonNull @Initialized Row row) {
            if (row.getSchema().hasField(this.sourceTimestampKeyName)) {
                return row.getDateTime(this.sourceTimestampKeyName);
            }
            Instant instant = Instant.now();
            if (this.mockInstant != null) {
                instant = this.mockInstant;
            }
            return new DateTime((Object)instant).withZone(instant.getZone());
        }

        @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] payload(@UnknownKeyFor @NonNull @Initialized Row row) {
            if (SchemaReflection.of(row.getSchema()).matchesAll(FieldMatcher.of(this.payloadKeyName, PAYLOAD_BYTES_TYPE_NAME))) {
                return row.getBytes(this.payloadKeyName);
            }
            return Objects.requireNonNull(this.payloadSerializer).serialize(this.serializableRow(row));
        }

        @UnknownKeyFor @NonNull @Initialized Row serializableRow(@UnknownKeyFor @NonNull @Initialized Row row) {
            SchemaReflection schemaReflection = SchemaReflection.of(row.getSchema());
            if (schemaReflection.matchesAll(FieldMatcher.of(this.payloadKeyName, PAYLOAD_BYTES_TYPE_NAME))) {
                throw new IllegalArgumentException(String.format("serializable Row does not exist for payload of type: %s", PAYLOAD_BYTES_TYPE_NAME));
            }
            if (schemaReflection.matchesAll(FieldMatcher.of(this.payloadKeyName, PAYLOAD_ROW_TYPE_NAME))) {
                return row.getRow(this.payloadKeyName);
            }
            Schema withUserFieldsOnly = PubsubRowToMessage.removeFields(row.getSchema(), this.attributesKeyName, this.sourceTimestampKeyName);
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (String name : withUserFieldsOnly.getFieldNames()) {
                values.put(name, row.getValue(name));
            }
            return Row.withSchema((Schema)withUserFieldsOnly).withFieldValues(values).build();
        }
    }

    static class FieldMatcher {
        private final @UnknownKeyFor @NonNull @Initialized String name;
        @javax.annotation.Nullable
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @Nullable @Initialized Schema.TypeName typeName;
        @javax.annotation.Nullable
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @Nullable @Initialized Schema.FieldType fieldType;

        static @UnknownKeyFor @NonNull @Initialized FieldMatcher of(@UnknownKeyFor @NonNull @Initialized String name) {
            return new FieldMatcher(name);
        }

        static @UnknownKeyFor @NonNull @Initialized FieldMatcher of(@UnknownKeyFor @NonNull @Initialized String name, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.TypeName typeName) {
            return new FieldMatcher(name, typeName);
        }

        static @UnknownKeyFor @NonNull @Initialized FieldMatcher of(@UnknownKeyFor @NonNull @Initialized String name, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
            return new FieldMatcher(name, fieldType);
        }

        private FieldMatcher(@UnknownKeyFor @NonNull @Initialized String name, @javax.annotation.Nullable // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @Nullable @Initialized Schema.TypeName typeName, @javax.annotation.Nullable // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @Nullable @Initialized Schema.FieldType fieldType) {
            this.name = name;
            this.typeName = typeName;
            this.fieldType = fieldType;
        }

        private FieldMatcher(@UnknownKeyFor @NonNull @Initialized String name) {
            this(name, null, null);
        }

        private FieldMatcher(@UnknownKeyFor @NonNull @Initialized String name, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.TypeName typeName) {
            this(name, typeName, null);
        }

        private FieldMatcher(@UnknownKeyFor @NonNull @Initialized String name, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
            this(name, null, fieldType);
        }

        @UnknownKeyFor @NonNull @Initialized boolean match(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            if (!schema.hasField(this.name)) {
                return false;
            }
            if (this.typeName == null && this.fieldType == null) {
                return true;
            }
            Schema.Field field = schema.getField(this.name);
            if (this.typeName != null) {
                return field.getType().getTypeName().equals((Object)this.typeName);
            }
            return this.fieldType.equals((Object)field.getType());
        }
    }

    static class SchemaReflection {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;

        static @UnknownKeyFor @NonNull @Initialized SchemaReflection of(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            return new SchemaReflection(schema);
        }

        private SchemaReflection(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            this.schema = schema;
        }

        @UnknownKeyFor @NonNull @Initialized boolean matchesAll(FieldMatcher ... fieldMatchers) {
            for (FieldMatcher fieldMatcher : fieldMatchers) {
                if (fieldMatcher.match(this.schema)) continue;
                return false;
            }
            return true;
        }

        @UnknownKeyFor @NonNull @Initialized boolean matchesAny(FieldMatcher ... fieldMatchers) {
            for (FieldMatcher fieldMatcher : fieldMatchers) {
                if (!fieldMatcher.match(this.schema)) continue;
                return true;
            }
            return false;
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setKeyPrefix(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> getKeyPrefix();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setPayloadSerializer(@UnknownKeyFor @NonNull @Initialized PayloadSerializer var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTargetTimestampAttributeName(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMockInstant(@UnknownKeyFor @NonNull @Initialized Instant var1);

        abstract @UnknownKeyFor @NonNull @Initialized PubsubRowToMessage autoBuild();

        final @UnknownKeyFor @NonNull @Initialized PubsubRowToMessage build() {
            if (!this.getKeyPrefix().isPresent()) {
                this.setKeyPrefix(PubsubRowToMessage.DEFAULT_KEY_PREFIX);
            }
            return this.autoBuild();
        }
    }
}

