/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.value.AutoValue;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubMessage_Impl;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class PubsubMessage {
    private @UnknownKeyFor @NonNull @Initialized Impl impl;

    public PubsubMessage(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] payload, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> attributes) {
        this(payload, attributes, null, null);
    }

    public PubsubMessage(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] payload, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> attributes, @Nullable @UnknownKeyFor @Initialized String messageId) {
        this.impl = Impl.create(payload, attributes, messageId, null);
    }

    public PubsubMessage(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] payload, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> attributes, @Nullable @UnknownKeyFor @Initialized String messageId, @Nullable @UnknownKeyFor @Initialized String orderingKey) {
        this.impl = Impl.create(payload, attributes, messageId, orderingKey);
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getPayload() {
        return this.impl.getPayload();
    }

    public @Nullable @UnknownKeyFor @Initialized String getAttribute(@UnknownKeyFor @NonNull @Initialized String attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"attribute");
        return this.impl.getAttributeMap().get(attribute);
    }

    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getAttributeMap() {
        return this.impl.getAttributeMap();
    }

    public @Nullable @UnknownKeyFor @Initialized String getMessageId() {
        return this.impl.getMessageId();
    }

    public @Nullable @UnknownKeyFor @Initialized String getOrderingKey() {
        return this.impl.getOrderingKey();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.impl.toString();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object other) {
        if (!(other instanceof PubsubMessage)) {
            return false;
        }
        return this.impl.equals(((PubsubMessage)other).impl);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.impl.hashCode();
    }

    @AutoValue
    static abstract class Impl {
        Impl() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getPayload();

        abstract @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getAttributeMap();

        abstract @Nullable @UnknownKeyFor @Initialized String getMessageId();

        abstract @Nullable @UnknownKeyFor @Initialized String getOrderingKey();

        static @UnknownKeyFor @NonNull @Initialized Impl create(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] payload, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> attributes, @Nullable @UnknownKeyFor @Initialized String messageId, @Nullable @UnknownKeyFor @Initialized String orderingKey) {
            return new AutoValue_PubsubMessage_Impl(payload, attributes, messageId, orderingKey);
        }
    }
}

