/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.firestore.v1.Document;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.UnsignedBytes;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

class QueryUtils {
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized StructuredQuery.FieldFilter.Operator> INEQUALITY_FIELD_FILTER_OPS = ImmutableSet.of((Object)StructuredQuery.FieldFilter.Operator.LESS_THAN, (Object)StructuredQuery.FieldFilter.Operator.LESS_THAN_OR_EQUAL, (Object)StructuredQuery.FieldFilter.Operator.GREATER_THAN, (Object)StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL, (Object)StructuredQuery.FieldFilter.Operator.NOT_EQUAL, (Object)StructuredQuery.FieldFilter.Operator.NOT_IN, (Object[])new StructuredQuery.FieldFilter.Operator[0]);
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized StructuredQuery.UnaryFilter.Operator> INEQUALITY_UNARY_FILTER_OPS = ImmutableSet.of((Object)StructuredQuery.UnaryFilter.Operator.IS_NOT_NAN, (Object)StructuredQuery.UnaryFilter.Operator.IS_NOT_NULL);

    QueryUtils() {
    }

    static @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized StructuredQuery.Order> getImplicitOrderBy(@UnknownKeyFor @NonNull @Initialized StructuredQuery query) {
        ArrayList<OrderByFieldPath> expectedImplicitOrders = new ArrayList<OrderByFieldPath>();
        if (query.hasWhere()) {
            QueryUtils.fillInequalityFields(query.getWhere(), expectedImplicitOrders);
        }
        Collections.sort(expectedImplicitOrders);
        if (expectedImplicitOrders.stream().noneMatch(OrderByFieldPath::isDocumentName)) {
            expectedImplicitOrders.add(OrderByFieldPath.fromString("__name__"));
        }
        for (StructuredQuery.Order order : query.getOrderByList()) {
            OrderByFieldPath orderField = OrderByFieldPath.fromString(order.getField().getFieldPath());
            expectedImplicitOrders.remove(orderField);
        }
        ArrayList<StructuredQuery.Order> additionalOrders = new ArrayList<StructuredQuery.Order>();
        if (!expectedImplicitOrders.isEmpty()) {
            StructuredQuery.Direction lastDirection = query.getOrderByCount() == 0 ? StructuredQuery.Direction.ASCENDING : ((StructuredQuery.Order)query.getOrderByList().get(query.getOrderByCount() - 1)).getDirection();
            for (OrderByFieldPath field : expectedImplicitOrders) {
                additionalOrders.add(StructuredQuery.Order.newBuilder().setDirection(lastDirection).setField(StructuredQuery.FieldReference.newBuilder().setFieldPath(field.getOriginalString()).build()).build());
            }
        }
        return additionalOrders;
    }

    private static void fillInequalityFields(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized StructuredQuery.Filter filter, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OrderByFieldPath> result) {
        switch (filter.getFilterTypeCase()) {
            case FIELD_FILTER: {
                OrderByFieldPath fieldPath;
                if (!INEQUALITY_FIELD_FILTER_OPS.contains((Object)filter.getFieldFilter().getOp()) || result.contains(fieldPath = OrderByFieldPath.fromString(filter.getFieldFilter().getField().getFieldPath()))) break;
                result.add(fieldPath);
                break;
            }
            case COMPOSITE_FILTER: {
                filter.getCompositeFilter().getFiltersList().forEach(f -> QueryUtils.fillInequalityFields(f, result));
                break;
            }
            case UNARY_FILTER: {
                OrderByFieldPath fieldPath;
                if (!INEQUALITY_UNARY_FILTER_OPS.contains((Object)filter.getUnaryFilter().getOp()) || result.contains(fieldPath = OrderByFieldPath.fromString(filter.getUnaryFilter().getField().getFieldPath()))) break;
                result.add(fieldPath);
                break;
            }
        }
    }

    static @Nullable @UnknownKeyFor @Initialized Value lookupDocumentValue(@UnknownKeyFor @NonNull @Initialized Document document, @UnknownKeyFor @NonNull @Initialized String fieldPath) {
        OrderByFieldPath resolvedPath = OrderByFieldPath.fromString(fieldPath);
        if (resolvedPath.isDocumentName()) {
            return Value.newBuilder().setReferenceValue(document.getName()).build();
        }
        return QueryUtils.findMapValue(new ArrayList<String>((Collection<String>)resolvedPath.getSegments()), document.getFieldsMap());
    }

    private static @Nullable @UnknownKeyFor @Initialized Value findMapValue(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> segments, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Value> valueMap) {
        if (segments.isEmpty()) {
            return null;
        }
        String field = segments.remove(0);
        Value value = valueMap.get(field);
        if (segments.isEmpty()) {
            return value;
        }
        if (value == null || !value.getValueTypeCase().equals((Object)Value.ValueTypeCase.MAP_VALUE)) {
            return null;
        }
        return QueryUtils.findMapValue(segments, value.getMapValue().getFieldsMap());
    }

    private static class OrderByFieldPath
    implements Comparable<OrderByFieldPath> {
        private static final @UnknownKeyFor @NonNull @Initialized String UNQUOTED_NAME_REGEX_STRING = "([a-zA-Z_][a-zA-Z_0-9]*)";
        private static final @UnknownKeyFor @NonNull @Initialized String QUOTED_NAME_REGEX_STRING = "(`(?:[^`\\\\]|(?:\\\\.))+`)";
        private static final @UnknownKeyFor @NonNull @Initialized Pattern FIELD_PATH_SEGMENT_REGEX = Pattern.compile(String.format("(?:%s|%s)(\\..+|$)", "([a-zA-Z_][a-zA-Z_0-9]*)", "(`(?:[^`\\\\]|(?:\\\\.))+`)"), 32);
        private final @UnknownKeyFor @NonNull @Initialized String originalString;
        private final @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> segments;

        public static @UnknownKeyFor @NonNull @Initialized OrderByFieldPath fromString(@UnknownKeyFor @NonNull @Initialized String fieldPath) {
            if (fieldPath.isEmpty()) {
                throw new IllegalArgumentException("Could not resolve empty field path");
            }
            String originalString = fieldPath;
            ArrayList<String> segments = new ArrayList<String>();
            while (!fieldPath.isEmpty()) {
                Matcher segmentMatcher = FIELD_PATH_SEGMENT_REGEX.matcher(fieldPath);
                boolean foundMatch = segmentMatcher.lookingAt();
                if (!foundMatch) {
                    throw new IllegalArgumentException("OrderBy field path was malformed");
                }
                String fieldName = segmentMatcher.group(1);
                if (fieldName != null) {
                    segments.add(fieldName);
                } else {
                    fieldName = segmentMatcher.group(2);
                    if (fieldName != null) {
                        String unescaped = OrderByFieldPath.unescapeFieldName(fieldName.substring(1, fieldName.length() - 1));
                        segments.add(unescaped);
                    } else {
                        throw new IllegalArgumentException("OrderBy field path was malformed");
                    }
                }
                if (!(fieldPath = fieldPath.substring(fieldName.length())).startsWith(".")) continue;
                fieldPath = fieldPath.substring(1);
            }
            return new OrderByFieldPath(originalString, (ImmutableList<String>)ImmutableList.copyOf(segments));
        }

        private OrderByFieldPath(@UnknownKeyFor @NonNull @Initialized String originalString, @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> segments) {
            this.originalString = originalString;
            this.segments = segments;
        }

        public @UnknownKeyFor @NonNull @Initialized String getOriginalString() {
            return this.originalString;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isDocumentName() {
            return this.segments.size() == 1 && "__name__".equals(this.segments.get(0));
        }

        public @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> getSegments() {
            return this.segments;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (other instanceof OrderByFieldPath) {
                return this.segments.equals(((OrderByFieldPath)other).getSegments());
            }
            return super.equals(other);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.segments);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized OrderByFieldPath other) {
            int length = Math.min(this.getSegments().size(), other.getSegments().size());
            for (int i = 0; i < length; ++i) {
                byte[] thisField = ((String)this.getSegments().get(i)).getBytes(StandardCharsets.UTF_8);
                byte[] otherField = ((String)other.getSegments().get(i)).getBytes(StandardCharsets.UTF_8);
                int cmp = UnsignedBytes.lexicographicalComparator().compare(thisField, otherField);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(this.getSegments().size(), other.getSegments().size());
        }

        private static @UnknownKeyFor @NonNull @Initialized String unescapeFieldName(@UnknownKeyFor @NonNull @Initialized String fieldName) {
            if (fieldName.isEmpty()) {
                throw new IllegalArgumentException("quoted identifier cannot be empty");
            }
            StringBuilder buf = new StringBuilder();
            block18: for (int i = 0; i < fieldName.length(); ++i) {
                char c = fieldName.charAt(i);
                if (c == '`') {
                    throw new IllegalArgumentException("quoted identifier cannot contain unescaped quote");
                }
                if (c == '\r') {
                    buf.append('\n');
                    if (i + 1 >= fieldName.length() || fieldName.charAt(i + 1) != '\n') continue;
                    ++i;
                    continue;
                }
                if (c != '\\') {
                    buf.append(c);
                    continue;
                }
                if (i + 1 >= fieldName.length()) {
                    throw new IllegalArgumentException("illegal trailing backslash");
                }
                switch (fieldName.charAt(++i)) {
                    case 'a': {
                        buf.appendCodePoint(7);
                        continue block18;
                    }
                    case 'b': {
                        buf.append('\b');
                        continue block18;
                    }
                    case 'f': {
                        buf.append('\f');
                        continue block18;
                    }
                    case 'n': {
                        buf.append('\n');
                        continue block18;
                    }
                    case 'r': {
                        buf.append('\r');
                        continue block18;
                    }
                    case 't': {
                        buf.append('\t');
                        continue block18;
                    }
                    case 'v': {
                        buf.appendCodePoint(11);
                        continue block18;
                    }
                    case '?': {
                        buf.append('?');
                        continue block18;
                    }
                    case '\\': {
                        buf.append('\\');
                        continue block18;
                    }
                    case '\'': {
                        buf.append('\'');
                        continue block18;
                    }
                    case '\"': {
                        buf.append('\"');
                        continue block18;
                    }
                    case '`': {
                        buf.append('`');
                        continue block18;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        if (i + 3 > fieldName.length()) {
                            throw new IllegalArgumentException("illegal octal escape sequence");
                        }
                        buf.appendCodePoint(OrderByFieldPath.unescapeOctal(fieldName.substring(i, i + 3)));
                        i += 3;
                        continue block18;
                    }
                    case 'X': 
                    case 'x': {
                        if (++i + 2 > fieldName.length()) {
                            throw new IllegalArgumentException("illegal hex escape sequence");
                        }
                        buf.appendCodePoint(OrderByFieldPath.unescapeHex(fieldName.substring(i, i + 2)));
                        i += 2;
                        continue block18;
                    }
                    case 'u': {
                        if (++i + 4 > fieldName.length()) {
                            throw new IllegalArgumentException("illegal unicode escape sequence");
                        }
                        buf.appendCodePoint(OrderByFieldPath.unescapeHex(fieldName.substring(i, i + 4)));
                        i += 4;
                        continue block18;
                    }
                    case 'U': {
                        if (++i + 8 > fieldName.length()) {
                            throw new IllegalArgumentException("illegal unicode escape sequence");
                        }
                        buf.appendCodePoint(OrderByFieldPath.unescapeHex(fieldName.substring(i, i + 8)));
                        i += 8;
                        continue block18;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal escape");
                    }
                }
            }
            return buf.toString();
        }

        private static @UnknownKeyFor @NonNull @Initialized int unescapeOctal(@UnknownKeyFor @NonNull @Initialized String str) {
            int ch = 0;
            for (int i = 0; i < str.length(); ++i) {
                ch = 8 * ch + OrderByFieldPath.octalValue(str.charAt(i));
            }
            if (!Character.isValidCodePoint(ch)) {
                throw new IllegalArgumentException("illegal codepoint");
            }
            return ch;
        }

        private static @UnknownKeyFor @NonNull @Initialized int unescapeHex(@UnknownKeyFor @NonNull @Initialized String str) {
            int ch = 0;
            for (int i = 0; i < str.length(); ++i) {
                ch = 16 * ch + OrderByFieldPath.hexValue(str.charAt(i));
            }
            if (!Character.isValidCodePoint(ch)) {
                throw new IllegalArgumentException("illegal codepoint");
            }
            return ch;
        }

        private static @UnknownKeyFor @NonNull @Initialized int octalValue(@UnknownKeyFor @NonNull @Initialized char d) {
            if (d >= '0' && d <= '7') {
                return d - 48;
            }
            throw new IllegalArgumentException("illegal octal digit");
        }

        private static @UnknownKeyFor @NonNull @Initialized int hexValue(@UnknownKeyFor @NonNull @Initialized char d) {
            if (d >= '0' && d <= '9') {
                return d - 48;
            }
            if (d >= 'a' && d <= 'f') {
                return 10 + d - 97;
            }
            if (d >= 'A' && d <= 'F') {
                return 10 + d - 65;
            }
            throw new IllegalArgumentException("illegal hex digit");
        }
    }
}

