/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams;

import com.google.cloud.Timestamp;
import java.util.Date;
import org.apache.beam.sdk.annotations.Internal;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@Internal
public class TimestampConverter {
    public static @UnknownKeyFor @NonNull @Initialized Instant toInstant(@UnknownKeyFor @NonNull @Initialized Timestamp time) {
        return Instant.ofEpochMilli((long)time.toDate().toInstant().toEpochMilli());
    }

    public static @UnknownKeyFor @NonNull @Initialized Instant toInstant(@UnknownKeyFor @NonNull @Initialized com.google.protobuf.Timestamp time) {
        long epochMilli = java.time.Instant.ofEpochSecond(time.getSeconds(), time.getNanos()).toEpochMilli();
        return Instant.ofEpochMilli((long)epochMilli);
    }

    public static @UnknownKeyFor @NonNull @Initialized Timestamp toCloudTimestamp(@UnknownKeyFor @NonNull @Initialized Instant instant) {
        return Timestamp.of((Date)instant.toDate());
    }
}

