/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageApiInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWriteUnshardedRecords;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class StorageApiWriteRecordsInconsistent<@UnknownKeyFor DestinationT, @UnknownKeyFor ElementT>
extends PTransform<PCollection<KV<DestinationT, StorageApiWritePayload>>, PCollectionTuple> {
    private final @UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsTag;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> finalizeTag = new TupleTag("finalizeTag");
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsCoder;
    private final @UnknownKeyFor @NonNull @Initialized boolean autoUpdateSchema;
    private final @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues;

    public StorageApiWriteRecordsInconsistent(@UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsTag, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsCoder, @UnknownKeyFor @NonNull @Initialized boolean autoUpdateSchema, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues) {
        this.dynamicDestinations = dynamicDestinations;
        this.bqServices = bqServices;
        this.failedRowsTag = failedRowsTag;
        this.failedRowsCoder = failedRowsCoder;
        this.autoUpdateSchema = autoUpdateSchema;
        this.ignoreUnknownValues = ignoreUnknownValues;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload>> input) {
        String operationName = input.getName() + "/" + this.getName();
        BigQueryOptions bigQueryOptions = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
        PCollectionTuple result = (PCollectionTuple)input.apply("Write Records", (PTransform)ParDo.of(new StorageApiWriteUnshardedRecords.WriteRecordsDoFn<DestinationT, ElementT>(operationName, this.dynamicDestinations, this.bqServices, true, bigQueryOptions.getStorageApiAppendThresholdBytes(), bigQueryOptions.getStorageApiAppendThresholdRecordCount(), bigQueryOptions.getNumStorageWriteApiStreamAppendClients(), this.finalizeTag, this.failedRowsTag, this.autoUpdateSchema, this.ignoreUnknownValues)).withOutputTags(this.finalizeTag, TupleTagList.of(this.failedRowsTag)).withSideInputs(this.dynamicDestinations.getSideInputs()));
        result.get(this.failedRowsTag).setCoder(this.failedRowsCoder);
        return result;
    }
}

