/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

class SplittingIterable
implements Iterable<ProtoRows> {
    private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> underlying;
    private final @UnknownKeyFor @NonNull @Initialized long splitSize;
    private final @UnknownKeyFor @NonNull @Initialized ConvertUnknownFields unknownFieldsToMessage;
    private final @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized TableRow> protoToTableRow;
    private final @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized String> failedRowsConsumer;
    private final @UnknownKeyFor @NonNull @Initialized boolean autoUpdateSchema;
    private final @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues;

    public SplittingIterable(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> underlying, @UnknownKeyFor @NonNull @Initialized long splitSize, @UnknownKeyFor @NonNull @Initialized ConvertUnknownFields unknownFieldsToMessage, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized TableRow> protoToTableRow, @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized String> failedRowsConsumer, @UnknownKeyFor @NonNull @Initialized boolean autoUpdateSchema, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues) {
        this.underlying = underlying;
        this.splitSize = splitSize;
        this.unknownFieldsToMessage = unknownFieldsToMessage;
        this.protoToTableRow = protoToTableRow;
        this.failedRowsConsumer = failedRowsConsumer;
        this.autoUpdateSchema = autoUpdateSchema;
        this.ignoreUnknownValues = ignoreUnknownValues;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized ProtoRows> iterator() {
        return new Iterator<ProtoRows>(){
            final @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> underlyingIterator;
            {
                this.underlyingIterator = SplittingIterable.this.underlying.iterator();
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
                return this.underlyingIterator.hasNext();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized ProtoRows next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ProtoRows.Builder inserts = ProtoRows.newBuilder();
                long bytesSize = 0L;
                while (this.underlyingIterator.hasNext()) {
                    ByteString byteString;
                    block7: {
                        StorageApiWritePayload payload = this.underlyingIterator.next();
                        byteString = ByteString.copyFrom((byte[])payload.getPayload());
                        if (SplittingIterable.this.autoUpdateSchema) {
                            try {
                                TableRow unknownFields = payload.getUnknownFields();
                                if (unknownFields == null) break block7;
                                try {
                                    byteString = byteString.concat(SplittingIterable.this.unknownFieldsToMessage.convert(unknownFields, SplittingIterable.this.ignoreUnknownValues));
                                }
                                catch (TableRowToStorageApiProto.SchemaConversionException e) {
                                    TableRow tableRow = (TableRow)SplittingIterable.this.protoToTableRow.apply(byteString);
                                    SplittingIterable.this.failedRowsConsumer.accept(tableRow, e.toString());
                                    continue;
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    inserts.addSerializedRows(byteString);
                    if ((bytesSize += (long)byteString.size()) <= SplittingIterable.this.splitSize) continue;
                    break;
                }
                return inserts.build();
            }
        };
    }

    static interface ConvertUnknownFields {
        public @UnknownKeyFor @NonNull @Initialized ByteString convert(@UnknownKeyFor @NonNull @Initialized TableRow var1, @UnknownKeyFor @NonNull @Initialized boolean var2) throws  @UnknownKeyFor @NonNull @Initialized TableRowToStorageApiProto.SchemaConversionException;
    }
}

