/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryTableSourceDef;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@VisibleForTesting
class BigQueryTableSource<@UnknownKeyFor T>
extends BigQuerySourceBase<T> {
    private final @UnknownKeyFor @NonNull @Initialized BigQueryTableSourceDef tableDef;
    private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@Nullable @UnknownKeyFor @Initialized Long> tableSizeBytes;

    static <T> @UnknownKeyFor @NonNull @Initialized BigQueryTableSource<T> create(@UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized BigQueryTableSourceDef tableDef, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized AvroSource.DatumReaderFactory<T>> readerFactory, @UnknownKeyFor @NonNull @Initialized boolean useAvroLogicalTypes) {
        return new BigQueryTableSource<T>(stepUuid, tableDef, bqServices, coder, readerFactory, useAvroLogicalTypes);
    }

    private BigQueryTableSource(@UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized BigQueryTableSourceDef tableDef, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized AvroSource.DatumReaderFactory<T>> readerFactory, @UnknownKeyFor @NonNull @Initialized boolean useAvroLogicalTypes) {
        super(stepUuid, bqServices, coder, readerFactory, useAvroLogicalTypes);
        this.tableDef = tableDef;
        this.tableSizeBytes = new AtomicReference();
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized TableReference getTableToExtract(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.tableDef.getTableReference(bqOptions);
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Long maybeNumBytes = this.tableSizeBytes.get();
        if (maybeNumBytes != null) {
            return maybeNumBytes;
        }
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        TableReference tableRef = this.tableDef.getTableReference(bqOptions);
        try (BigQueryServices.DatasetService datasetService = this.bqServices.getDatasetService(bqOptions);){
            Table table = datasetService.getTable(tableRef);
            if (table == null) {
                throw new IllegalStateException("Table not found: " + table);
            }
            Long numBytes = table.getNumBytes();
            if (table.getStreamingBuffer() != null && table.getStreamingBuffer().getEstimatedBytes() != null) {
                numBytes = numBytes + table.getStreamingBuffer().getEstimatedBytes().longValue();
            }
            this.tableSizeBytes.compareAndSet(null, numBytes);
            long l = numBytes;
            return l;
        }
    }

    @Override
    protected void cleanupTempResource(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) throws @UnknownKeyFor @NonNull @Initialized Exception {
    }

    public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"table", this.tableDef.getJsonTable()));
        builder.add(DisplayData.item((String)"launchesBigQueryJobs", (Boolean)true).withLabel("This transform launches BigQuery jobs to read/write elements."));
    }
}

