/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.VirtualTableSinglePartitionReadQuery;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.pager.MultiPartitionPager;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.SinglePartitionPager;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.commons.lang3.tuple.Pair;

public interface SinglePartitionReadQuery
extends ReadQuery {
    public static Group<? extends SinglePartitionReadQuery> createGroup(TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, List<DecoratedKey> partitionKeys, ClusteringIndexFilter clusteringIndexFilter) {
        return metadata.isVirtual() ? VirtualTableSinglePartitionReadQuery.Group.create(metadata, nowInSec, columnFilter, rowFilter, limits, partitionKeys, clusteringIndexFilter) : SinglePartitionReadCommand.Group.create(metadata, nowInSec, columnFilter, rowFilter, limits, partitionKeys, clusteringIndexFilter);
    }

    public static SinglePartitionReadQuery create(TableMetadata metadata, int nowInSec, DecoratedKey key, ColumnFilter columnFilter, ClusteringIndexFilter filter) {
        return SinglePartitionReadQuery.create(metadata, nowInSec, columnFilter, RowFilter.NONE, DataLimits.NONE, key, filter);
    }

    public static SinglePartitionReadQuery create(TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter) {
        return metadata.isVirtual() ? VirtualTableSinglePartitionReadQuery.create(metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter) : SinglePartitionReadCommand.create(metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter);
    }

    public DecoratedKey partitionKey();

    public SinglePartitionReadQuery withUpdatedLimit(DataLimits var1);

    public SinglePartitionReadQuery forPaging(Clustering<?> var1, DataLimits var2);

    @Override
    default public SinglePartitionPager getPager(PagingState pagingState, ProtocolVersion protocolVersion) {
        return new SinglePartitionPager(this, pagingState, protocolVersion);
    }

    public ClusteringIndexFilter clusteringIndexFilter();

    @Override
    default public boolean selectsKey(DecoratedKey key) {
        if (!this.partitionKey().equals(key)) {
            return false;
        }
        return this.rowFilter().partitionKeyRestrictionsAreSatisfiedBy(key, this.metadata().partitionKeyType);
    }

    @Override
    default public boolean selectsClustering(DecoratedKey key, Clustering<?> clustering) {
        if (clustering == Clustering.STATIC_CLUSTERING) {
            return !this.columnFilter().fetchedColumns().statics.isEmpty();
        }
        if (!this.clusteringIndexFilter().selects(clustering)) {
            return false;
        }
        return this.rowFilter().clusteringKeyRestrictionsAreSatisfiedBy(clustering);
    }

    public static abstract class Group<T extends SinglePartitionReadQuery>
    implements ReadQuery {
        public final List<T> queries;
        private final DataLimits limits;
        private final int nowInSec;
        private final boolean selectsFullPartitions;

        public Group(List<T> queries, DataLimits limits) {
            assert (!queries.isEmpty());
            this.queries = queries;
            this.limits = limits;
            SinglePartitionReadQuery firstQuery = (SinglePartitionReadQuery)queries.get(0);
            this.nowInSec = firstQuery.nowInSec();
            this.selectsFullPartitions = firstQuery.selectsFullPartition();
            for (int i = 1; i < queries.size(); ++i) {
                assert (((SinglePartitionReadQuery)queries.get(i)).nowInSec() == this.nowInSec);
            }
        }

        @Override
        public int nowInSec() {
            return this.nowInSec;
        }

        @Override
        public DataLimits limits() {
            return this.limits;
        }

        @Override
        public TableMetadata metadata() {
            return ((SinglePartitionReadQuery)this.queries.get(0)).metadata();
        }

        @Override
        public boolean selectsFullPartition() {
            return this.selectsFullPartitions;
        }

        @Override
        public ReadExecutionController executionController() {
            return ((SinglePartitionReadQuery)this.queries.get(0)).executionController();
        }

        @Override
        public PartitionIterator executeInternal(ReadExecutionController controller) {
            boolean enforceStrictLiveness = ((SinglePartitionReadQuery)this.queries.get(0)).metadata().enforceStrictLiveness();
            return this.limits.filter(UnfilteredPartitionIterators.filter(this.executeLocally(controller, false), this.nowInSec), this.nowInSec, this.selectsFullPartitions, enforceStrictLiveness);
        }

        @Override
        public UnfilteredPartitionIterator executeLocally(ReadExecutionController executionController) {
            return this.executeLocally(executionController, true);
        }

        private UnfilteredPartitionIterator executeLocally(ReadExecutionController executionController, boolean sort) {
            ArrayList<Pair> partitions = new ArrayList<Pair>(this.queries.size());
            for (SinglePartitionReadQuery query : this.queries) {
                partitions.add(Pair.of((Object)query.partitionKey(), (Object)query.executeLocally(executionController)));
            }
            if (sort) {
                Collections.sort(partitions, (p1, p2) -> ((DecoratedKey)p1.getLeft()).compareTo((PartitionPosition)p2.getLeft()));
            }
            return UnfilteredPartitionIterators.concat(partitions.stream().map(p -> (UnfilteredPartitionIterator)p.getRight()).collect(Collectors.toList()));
        }

        @Override
        public QueryPager getPager(PagingState pagingState, ProtocolVersion protocolVersion) {
            if (this.queries.size() == 1) {
                return new SinglePartitionPager((SinglePartitionReadQuery)this.queries.get(0), pagingState, protocolVersion);
            }
            return new MultiPartitionPager(this, pagingState, protocolVersion);
        }

        @Override
        public boolean selectsKey(DecoratedKey key) {
            return Iterables.any(this.queries, c -> c.selectsKey(key));
        }

        @Override
        public boolean selectsClustering(DecoratedKey key, Clustering<?> clustering) {
            return Iterables.any(this.queries, c -> c.selectsClustering(key, clustering));
        }

        @Override
        public RowFilter rowFilter() {
            return ((SinglePartitionReadQuery)this.queries.get(0)).rowFilter();
        }

        @Override
        public ColumnFilter columnFilter() {
            return ((SinglePartitionReadQuery)this.queries.get(0)).columnFilter();
        }

        public String toString() {
            return this.queries.toString();
        }
    }
}

