/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableBiMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class FieldTypeDescriptors {
    private static final @UnknownKeyFor @NonNull @Initialized BiMap<@UnknownKeyFor @NonNull @Initialized Schema.TypeName, @UnknownKeyFor @NonNull @Initialized TypeDescriptor> PRIMITIVE_MAPPING = ImmutableBiMap.builder().put((Object)Schema.TypeName.BYTE, TypeDescriptors.bytes()).put((Object)Schema.TypeName.INT16, TypeDescriptors.shorts()).put((Object)Schema.TypeName.INT32, TypeDescriptors.integers()).put((Object)Schema.TypeName.INT64, TypeDescriptors.longs()).put((Object)Schema.TypeName.DECIMAL, TypeDescriptors.bigdecimals()).put((Object)Schema.TypeName.FLOAT, TypeDescriptors.floats()).put((Object)Schema.TypeName.DOUBLE, TypeDescriptors.doubles()).put((Object)Schema.TypeName.STRING, TypeDescriptors.strings()).put((Object)Schema.TypeName.DATETIME, TypeDescriptor.of(Instant.class)).put((Object)Schema.TypeName.BOOLEAN, TypeDescriptors.booleans()).put((Object)Schema.TypeName.BYTES, TypeDescriptor.of(byte[].class)).build();

    public static @UnknownKeyFor @NonNull @Initialized TypeDescriptor javaTypeForFieldType(@UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case LOGICAL_TYPE: {
                return FieldTypeDescriptors.javaTypeForFieldType(fieldType.getLogicalType().getBaseType());
            }
            case ARRAY: {
                return TypeDescriptors.lists(FieldTypeDescriptors.javaTypeForFieldType(fieldType.getCollectionElementType()));
            }
            case ITERABLE: {
                return TypeDescriptors.iterables(FieldTypeDescriptors.javaTypeForFieldType(fieldType.getCollectionElementType()));
            }
            case MAP: {
                return TypeDescriptors.maps(FieldTypeDescriptors.javaTypeForFieldType(fieldType.getMapKeyType()), FieldTypeDescriptors.javaTypeForFieldType(fieldType.getMapValueType()));
            }
            case ROW: {
                return TypeDescriptors.rows();
            }
        }
        return (TypeDescriptor)PRIMITIVE_MAPPING.get((Object)fieldType.getTypeName());
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldTypeForJavaType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor typeDescriptor) {
        if (typeDescriptor.isArray() || typeDescriptor.isSubtypeOf(TypeDescriptor.of(Collection.class))) {
            return FieldTypeDescriptors.getArrayFieldType(typeDescriptor);
        }
        if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(Map.class))) {
            return FieldTypeDescriptors.getMapFieldType(typeDescriptor);
        }
        if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(Iterable.class))) {
            return FieldTypeDescriptors.getIterableFieldType(typeDescriptor);
        }
        if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(Row.class))) {
            throw new IllegalArgumentException("Cannot automatically determine a field type from a Row class as we cannot determine the schema. You should set a field type explicitly.");
        }
        Schema.TypeName typeName = (Schema.TypeName)((Object)PRIMITIVE_MAPPING.inverse().get((Object)typeDescriptor));
        if (typeName == null) {
            throw new RuntimeException("Couldn't find field type for " + typeDescriptor);
        }
        return Schema.FieldType.of(typeName);
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema.FieldType getArrayFieldType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor typeDescriptor) {
        TypeDescriptor<Collection> collection;
        if (typeDescriptor.isArray()) {
            if (typeDescriptor.getComponentType().getType().equals(Byte.TYPE)) {
                return Schema.FieldType.BYTES;
            }
            return Schema.FieldType.array(FieldTypeDescriptors.fieldTypeForJavaType(typeDescriptor.getComponentType()));
        }
        if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(Collection.class)) && (collection = typeDescriptor.getSupertype(Collection.class)).getType() instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)collection.getType();
            Type[] params = ptype.getActualTypeArguments();
            Preconditions.checkArgument((params.length == 1 ? 1 : 0) != 0);
            return Schema.FieldType.array(FieldTypeDescriptors.fieldTypeForJavaType(TypeDescriptor.of(params[0])));
        }
        throw new RuntimeException("Could not determine array parameter type for field.");
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema.FieldType getIterableFieldType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor typeDescriptor) {
        TypeDescriptor<Iterable> iterable = typeDescriptor.getSupertype(Iterable.class);
        if (iterable.getType() instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)iterable.getType();
            Type[] params = ptype.getActualTypeArguments();
            Preconditions.checkArgument((params.length == 1 ? 1 : 0) != 0);
            return Schema.FieldType.iterable(FieldTypeDescriptors.fieldTypeForJavaType(TypeDescriptor.of(params[0])));
        }
        throw new RuntimeException("Could not determine array parameter type for field.");
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema.FieldType getMapFieldType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor typeDescriptor) {
        TypeDescriptor<Map> map = typeDescriptor.getSupertype(Map.class);
        if (map.getType() instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)map.getType();
            Type[] params = ptype.getActualTypeArguments();
            return Schema.FieldType.map(FieldTypeDescriptors.fieldTypeForJavaType(TypeDescriptor.of(params[0])), FieldTypeDescriptors.fieldTypeForJavaType(TypeDescriptor.of(params[1])));
        }
        throw new RuntimeException("Cound not determine array parameter type for field.");
    }
}

