/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.google.auto.value.AutoValue;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.AutoValue_MetricResult;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@JsonFilter(value="committedMetrics")
@Experimental(value=Experimental.Kind.METRICS)
@AutoValue
public abstract class MetricResult<@UnknownKeyFor T> {
    public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
        return this.getKey().metricName();
    }

    public abstract @UnknownKeyFor @NonNull @Initialized MetricKey getKey();

    public T getCommitted() {
        T committed = this.getCommittedOrNull();
        if (committed == null) {
            throw new UnsupportedOperationException("This runner does not currently support committed metrics results. Please use 'attempted' instead.");
        }
        return committed;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasCommitted() {
        return this.getCommittedOrNull() != null;
    }

    public abstract @Nullable T getCommittedOrNull();

    public abstract T getAttempted();

    public <V> @UnknownKeyFor @NonNull @Initialized MetricResult<V> transform(@UnknownKeyFor @NonNull @Initialized Function<T, V> fn) {
        T committed = this.getCommittedOrNull();
        return MetricResult.create(this.getKey(), committed == null ? null : (T)fn.apply(committed), fn.apply(this.getAttempted()));
    }

    public @UnknownKeyFor @NonNull @Initialized MetricResult<T> addAttempted(T update, @UnknownKeyFor @NonNull @Initialized BiFunction<T, T, T> combine) {
        return MetricResult.create(this.getKey(), this.getCommitted(), combine.apply(this.getAttempted(), update));
    }

    public @UnknownKeyFor @NonNull @Initialized MetricResult<T> addCommitted(T update, @UnknownKeyFor @NonNull @Initialized BiFunction<T, T, T> combine) {
        T committed = this.getCommittedOrNull();
        return MetricResult.create(this.getKey(), committed == null ? update : combine.apply(committed, update), this.getAttempted());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized MetricResult<T> attempted(@UnknownKeyFor @NonNull @Initialized MetricKey key, T attempted) {
        return new AutoValue_MetricResult<Object>(key, null, attempted);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized MetricResult<T> create(@UnknownKeyFor @NonNull @Initialized MetricKey key, @UnknownKeyFor @NonNull @Initialized Boolean isCommittedSupported, T value) {
        if (isCommittedSupported.booleanValue()) {
            return MetricResult.create(key, value, value);
        }
        return MetricResult.attempted(key, value);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized MetricResult<T> create(@UnknownKeyFor @NonNull @Initialized MetricKey key, @Nullable T committed, T attempted) {
        return new AutoValue_MetricResult<T>(key, committed, attempted);
    }
}

