/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.Histogram;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.util.HistogramData;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class DelegatingHistogram
implements Metric,
Histogram,
Serializable {
    private final @UnknownKeyFor @NonNull @Initialized MetricName name;
    private final @UnknownKeyFor @NonNull @Initialized HistogramData.BucketType bucketType;
    private final @UnknownKeyFor @NonNull @Initialized boolean processWideContainer;

    public DelegatingHistogram(@UnknownKeyFor @NonNull @Initialized MetricName name, @UnknownKeyFor @NonNull @Initialized HistogramData.BucketType bucketType, @UnknownKeyFor @NonNull @Initialized boolean processWideContainer) {
        this.name = name;
        this.bucketType = bucketType;
        this.processWideContainer = processWideContainer;
    }

    @Override
    public void update(@UnknownKeyFor @NonNull @Initialized double value) {
        MetricsContainer container;
        MetricsContainer metricsContainer = container = this.processWideContainer ? MetricsEnvironment.getProcessWideContainer() : MetricsEnvironment.getCurrentContainer();
        if (container != null) {
            container.getHistogram(this.name, this.bucketType).update(value);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
        return this.name;
    }
}

