/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.net.URL;
import org.apache.spark.ErrorInfo;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.SortedMap;

public final class SparkThrowableHelper$ {
    public static SparkThrowableHelper$ MODULE$;
    private final URL errorClassesUrl;
    private final SortedMap<String, ErrorInfo> errorClassToInfoMap;

    static {
        new SparkThrowableHelper$();
    }

    public URL errorClassesUrl() {
        return this.errorClassesUrl;
    }

    public SortedMap<String, ErrorInfo> errorClassToInfoMap() {
        return this.errorClassToInfoMap;
    }

    public String getMessage(String errorClass, String[] messageParameters, String queryContext) {
        ErrorInfo errorInfo = (ErrorInfo)this.errorClassToInfoMap().getOrElse((Object)errorClass, (Function0 & java.io.Serializable & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(26).append("Cannot find error class '").append(errorClass).append("'").toString());
        });
        String displayQueryContext = queryContext.isEmpty() ? "" : new StringBuilder(1).append("\n").append(queryContext).toString();
        return new StringBuilder(0).append(String.format(errorInfo.messageFormat().replaceAll("<[a-zA-Z0-9_-]+>", "%s"), messageParameters)).append(displayQueryContext).toString();
    }

    public String getMessage$default$3() {
        return "";
    }

    public String getSqlState(String errorClass) {
        return (String)Option$.MODULE$.apply((Object)errorClass).flatMap((Function1 & java.io.Serializable & Serializable)key -> MODULE$.errorClassToInfoMap().get(key)).flatMap((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.sqlState()).orNull(Predef$.MODULE$.$conforms());
    }

    public boolean isInternalError(String errorClass) {
        String string = errorClass;
        String string2 = "INTERNAL_ERROR";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private SparkThrowableHelper$() {
        MODULE$ = this;
        this.errorClassesUrl = Utils$.MODULE$.getSparkClassLoader().getResource("error/error-classes.json");
        JsonMapper mapper = (JsonMapper)JsonMapper.builder().addModule((Module)DefaultScalaModule$.MODULE$).build();
        this.errorClassToInfoMap = (SortedMap)mapper.readValue(this.errorClassesUrl(), (TypeReference)new TypeReference<SortedMap<String, ErrorInfo>>(){});
    }
}

