/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.memgroupby;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringJoiner;
import java.util.TreeSet;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.ValueDataUtil;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.memgroupby.Aggregate;
import org.apache.hop.pipeline.transforms.memgroupby.GAggregate;
import org.apache.hop.pipeline.transforms.memgroupby.MemoryGroupByData;
import org.apache.hop.pipeline.transforms.memgroupby.MemoryGroupByMeta;

public class MemoryGroupBy
extends BaseTransform<MemoryGroupByMeta, MemoryGroupByData> {
    private static final Class<?> PKG = MemoryGroupByMeta.class;
    private boolean allNullsAreZero = false;
    private boolean minNullIsValued = false;

    public MemoryGroupBy(TransformMeta transformMeta, MemoryGroupByMeta meta, MemoryGroupByData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (this.first) {
            if (r == null && !((MemoryGroupByMeta)this.meta).isAlwaysGivingBackOneRow()) {
                this.setOutputDone();
                return false;
            }
            String val = this.getVariable("HOP_AGGREGATION_ALL_NULLS_ARE_ZERO", "N");
            this.allNullsAreZero = ValueMetaBase.convertStringToBoolean((String)val);
            val = this.getVariable("HOP_AGGREGATION_MIN_NULL_IS_VALUED", "N");
            this.minNullIsValued = ValueMetaBase.convertStringToBoolean((String)val);
            ((MemoryGroupByData)this.data).inputRowMeta = this.getInputRowMeta();
            if (((MemoryGroupByData)this.data).inputRowMeta == null) {
                ((MemoryGroupByData)this.data).inputRowMeta = this.getPipelineMeta().getPrevTransformFields((IVariables)this, this.getTransformMeta());
            }
            ((MemoryGroupByData)this.data).outputRowMeta = ((MemoryGroupByData)this.data).inputRowMeta.clone();
            ((MemoryGroupByMeta)this.meta).getFields(((MemoryGroupByData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((MemoryGroupByData)this.data).subjectnrs = new int[((MemoryGroupByMeta)this.meta).getAggregates().size()];
            ((MemoryGroupByData)this.data).groupnrs = new int[((MemoryGroupByMeta)this.meta).getGroups().size()];
            if (r != null) {
                int i;
                for (i = 0; i < ((MemoryGroupByMeta)this.meta).getAggregates().size(); ++i) {
                    GAggregate aggregate = ((MemoryGroupByMeta)this.meta).getAggregates().get(i);
                    ((MemoryGroupByData)this.data).subjectnrs[i] = aggregate.getType() == MemoryGroupByMeta.GroupType.CountAny ? 0 : ((MemoryGroupByData)this.data).inputRowMeta.indexOfValue(aggregate.getSubject());
                    if (((MemoryGroupByData)this.data).subjectnrs[i] >= 0) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"MemoryGroupBy.Log.AggregateSubjectFieldCouldNotFound", (String[])new String[]{aggregate.getSubject()}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                for (i = 0; i < ((MemoryGroupByMeta)this.meta).getGroups().size(); ++i) {
                    String groupField = ((MemoryGroupByMeta)this.meta).getGroups().get(i).getField();
                    ((MemoryGroupByData)this.data).groupnrs[i] = ((MemoryGroupByData)this.data).inputRowMeta.indexOfValue(groupField);
                    if (((MemoryGroupByData)this.data).groupnrs[i] >= 0) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"MemoryGroupBy.Log.GroupFieldCouldNotFound", (String[])new String[]{groupField}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
            ((MemoryGroupByData)this.data).valueMetaInteger = new ValueMetaInteger("count");
            ((MemoryGroupByData)this.data).valueMetaNumber = new ValueMetaNumber("sum");
            this.initGroupMeta(((MemoryGroupByData)this.data).inputRowMeta);
        }
        if (this.first) {
            this.newAggregate(r, null);
            ((MemoryGroupByData)this.data).groupAggMeta = new RowMeta();
            ((MemoryGroupByData)this.data).groupAggMeta.addRowMeta(((MemoryGroupByData)this.data).groupMeta);
            ((MemoryGroupByData)this.data).groupAggMeta.addRowMeta(((MemoryGroupByData)this.data).aggMeta);
        }
        if (r == null) {
            this.handleLastOfGroup();
            this.setOutputDone();
            return false;
        }
        if (this.first || ((MemoryGroupByData)this.data).newBatch) {
            this.first = false;
            ((MemoryGroupByData)this.data).newBatch = false;
        }
        this.addToAggregate(r);
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"MemoryGroupBy.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    private void handleLastOfGroup() throws HopException {
        for (MemoryGroupByData.HashEntry entry : ((MemoryGroupByData)this.data).map.keySet()) {
            int i;
            Aggregate aggregate = ((MemoryGroupByData)this.data).map.get(entry);
            Object[] aggregateResult = this.getAggregateResult(aggregate);
            Object[] outputRowData = RowDataUtil.allocateRowData((int)((MemoryGroupByData)this.data).outputRowMeta.size());
            int index = 0;
            for (i = 0; i < ((MemoryGroupByData)this.data).groupMeta.size(); ++i) {
                outputRowData[index++] = ((MemoryGroupByData)this.data).groupMeta.getValueMeta(i).convertToNormalStorageType(entry.getGroupData()[i]);
            }
            for (i = 0; i < ((MemoryGroupByData)this.data).aggMeta.size(); ++i) {
                outputRowData[index++] = ((MemoryGroupByData)this.data).aggMeta.getValueMeta(i).convertToNormalStorageType(aggregateResult[i]);
            }
            this.putRow(((MemoryGroupByData)this.data).outputRowMeta, outputRowData);
        }
        if (((MemoryGroupByData)this.data).map.isEmpty() && ((MemoryGroupByMeta)this.meta).isAlwaysGivingBackOneRow()) {
            int i;
            Object[] outputRowData = RowDataUtil.allocateRowData((int)((MemoryGroupByData)this.data).outputRowMeta.size());
            int index = 0;
            for (i = 0; i < ((MemoryGroupByData)this.data).groupMeta.size(); ++i) {
                outputRowData[index++] = null;
            }
            for (i = 0; i < ((MemoryGroupByData)this.data).aggMeta.size(); ++i) {
                GAggregate aggregate = ((MemoryGroupByMeta)this.meta).getAggregates().get(i);
                outputRowData[index++] = aggregate.getType() == MemoryGroupByMeta.GroupType.CountAll || aggregate.getType() == MemoryGroupByMeta.GroupType.CountAny || aggregate.getType() == MemoryGroupByMeta.GroupType.CountDistinct ? Long.valueOf(0L) : null;
            }
            this.putRow(((MemoryGroupByData)this.data).outputRowMeta, outputRowData);
        }
    }

    void addToAggregate(Object[] r) throws HopException {
        Object[] groupData = new Object[((MemoryGroupByData)this.data).groupMeta.size()];
        for (int i = 0; i < ((MemoryGroupByData)this.data).groupnrs.length; ++i) {
            groupData[i] = r[((MemoryGroupByData)this.data).groupnrs[i]];
        }
        MemoryGroupByData.HashEntry entry = ((MemoryGroupByData)this.data).getHashEntry(groupData);
        Aggregate aggregate = ((MemoryGroupByData)this.data).map.get(entry);
        if (aggregate == null) {
            aggregate = new Aggregate();
            this.newAggregate(r, aggregate);
            ((MemoryGroupByData)this.data).map.put(entry, aggregate);
        }
        block19: for (int i = 0; i < ((MemoryGroupByData)this.data).subjectnrs.length; ++i) {
            Object subj = r[((MemoryGroupByData)this.data).subjectnrs[i]];
            IValueMeta subjMeta = ((MemoryGroupByData)this.data).inputRowMeta.getValueMeta(((MemoryGroupByData)this.data).subjectnrs[i]);
            Object value = aggregate.agg[i];
            IValueMeta valueMeta = ((MemoryGroupByData)this.data).aggMeta.getValueMeta(i);
            GAggregate agg = ((MemoryGroupByMeta)this.meta).getAggregates().get(i);
            switch (agg.getType()) {
                case Sum: {
                    aggregate.agg[i] = ValueDataUtil.sum((IValueMeta)valueMeta, (Object)value, (IValueMeta)subjMeta, (Object)subj);
                    continue block19;
                }
                case Average: {
                    if (subjMeta.isNull(subj)) continue block19;
                    aggregate.agg[i] = ValueDataUtil.sum((IValueMeta)valueMeta, (Object)value, (IValueMeta)subjMeta, (Object)subj);
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block19;
                }
                case Median: 
                case Percentile: {
                    if (subjMeta.isNull(subj)) continue block19;
                    ((List)aggregate.agg[i]).add(subjMeta.getNumber(subj));
                    continue block19;
                }
                case StandardDeviation: {
                    if (aggregate.mean == null) {
                        aggregate.mean = new double[((MemoryGroupByMeta)this.meta).getAggregates().size()];
                    }
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    double n2 = aggregate.counts[i];
                    double x = subjMeta.getNumber(subj);
                    double sum = value == null ? Double.valueOf(0.0) : (Double)value;
                    double mean = aggregate.mean[i];
                    double delta = x - mean;
                    aggregate.mean[i] = mean;
                    aggregate.agg[i] = sum += delta * (x - (mean += delta / n2));
                    continue block19;
                }
                case CountDistinct: {
                    if (aggregate.distinctObjs == null) {
                        aggregate.distinctObjs = new Set[((MemoryGroupByMeta)this.meta).getAggregates().size()];
                    }
                    if (aggregate.distinctObjs[i] == null) {
                        aggregate.distinctObjs[i] = new TreeSet<Object>();
                    }
                    if (!subjMeta.isNull(subj)) {
                        Object obj = subjMeta.convertToNormalStorageType(subj);
                        if (obj instanceof byte[]) {
                            obj = new String((byte[])obj);
                        }
                        if (!aggregate.distinctObjs[i].contains(obj)) {
                            aggregate.distinctObjs[i].add(obj);
                        }
                    }
                    aggregate.counts[i] = aggregate.distinctObjs[i].size();
                    continue block19;
                }
                case CountAll: {
                    if (subjMeta.isNull(subj)) continue block19;
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block19;
                }
                case CountAny: {
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block19;
                }
                case Minimum: {
                    boolean subjIsNull = subjMeta.isNull(subj);
                    boolean valueIsNull = valueMeta.isNull(value);
                    if (this.minNullIsValued || !subjIsNull && !valueIsNull) {
                        aggregate.agg[i] = subjMeta.compare(subj, valueMeta, value) < 0 ? subj : value;
                        continue block19;
                    }
                    if (!valueIsNull || subjIsNull) continue block19;
                    aggregate.agg[i] = subj;
                    continue block19;
                }
                case Maximum: {
                    if (subjMeta.compare(subj, valueMeta, value) <= 0) continue block19;
                    aggregate.agg[i] = subj;
                    continue block19;
                }
                case First: {
                    if (subjMeta.isNull(subj) || value != null) continue block19;
                    aggregate.agg[i] = subj;
                    continue block19;
                }
                case Last: {
                    if (subjMeta.isNull(subj)) continue block19;
                    aggregate.agg[i] = subj;
                    continue block19;
                }
                case FirstIncludingNull: {
                    if (aggregate.counts[i] != 0L) continue block19;
                    aggregate.agg[i] = subj;
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block19;
                }
                case LastIncludingNull: {
                    aggregate.agg[i] = subj;
                    continue block19;
                }
                case ConcatComma: {
                    if (subj == null) continue block19;
                    StringBuilder sb = (StringBuilder)value;
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(subjMeta.getString(subj));
                    continue block19;
                }
                case ConcatString: {
                    StringBuilder sb;
                    if (subj == null) continue block19;
                    String separator = "";
                    if (!Utils.isEmpty((CharSequence)agg.getValueField())) {
                        separator = this.resolve(agg.getValueField());
                    }
                    if ((sb = (StringBuilder)value).length() > 0) {
                        sb.append(separator);
                    }
                    sb.append(subjMeta.getString(subj));
                    continue block19;
                }
                case ConcatDistinct: {
                    if (subj == null) continue block19;
                    SortedSet set = (SortedSet)value;
                    set.add(subj);
                    continue block19;
                }
            }
        }
    }

    void newAggregate(Object[] r, Aggregate aggregate) throws HopException {
        int i;
        if (aggregate == null) {
            ((MemoryGroupByData)this.data).aggMeta = new RowMeta();
        } else {
            aggregate.counts = new long[((MemoryGroupByData)this.data).subjectnrs.length];
            for (i = 0; i < aggregate.counts.length; ++i) {
                aggregate.counts[i] = 0L;
            }
            aggregate.distinctObjs = null;
            aggregate.agg = new Object[((MemoryGroupByData)this.data).subjectnrs.length];
            aggregate.mean = new double[((MemoryGroupByData)this.data).subjectnrs.length];
        }
        for (i = 0; i < ((MemoryGroupByData)this.data).subjectnrs.length; ++i) {
            IValueMeta subjMeta = ((MemoryGroupByData)this.data).inputRowMeta.getValueMeta(((MemoryGroupByData)this.data).subjectnrs[i]);
            Serializable v = null;
            IValueMeta vMeta = null;
            GAggregate agg = ((MemoryGroupByMeta)this.meta).getAggregates().get(i);
            switch (agg.getType()) {
                case Median: 
                case Percentile: {
                    vMeta = new ValueMetaNumber(agg.getField());
                    v = new ArrayList();
                    break;
                }
                case StandardDeviation: {
                    vMeta = new ValueMetaNumber(agg.getField());
                    break;
                }
                case CountDistinct: 
                case CountAll: 
                case CountAny: {
                    vMeta = new ValueMetaInteger(agg.getField());
                    break;
                }
                case Sum: 
                case Average: {
                    vMeta = subjMeta.isNumeric() ? subjMeta.clone() : new ValueMetaNumber();
                    vMeta.setName(agg.getField());
                    break;
                }
                case Minimum: 
                case Maximum: 
                case First: 
                case Last: 
                case FirstIncludingNull: 
                case LastIncludingNull: {
                    vMeta = subjMeta.clone();
                    vMeta.setName(agg.getField());
                    v = r == null ? null : r[((MemoryGroupByData)this.data).subjectnrs[i]];
                    break;
                }
                case ConcatComma: 
                case ConcatString: {
                    vMeta = new ValueMetaString(agg.getField());
                    v = new StringBuilder();
                    break;
                }
                case ConcatDistinct: {
                    vMeta = new ValueMetaString(agg.getField());
                    v = new TreeSet();
                    break;
                }
                default: {
                    throw new HopException("Unknown data type for aggregation : " + agg.getField());
                }
            }
            if (agg.getType() != MemoryGroupByMeta.GroupType.CountAll && agg.getType() != MemoryGroupByMeta.GroupType.CountDistinct && agg.getType() != MemoryGroupByMeta.GroupType.CountAny) {
                vMeta.setLength(subjMeta.getLength(), subjMeta.getPrecision());
            }
            if (aggregate == null) {
                ((MemoryGroupByData)this.data).aggMeta.addValueMeta(vMeta);
                continue;
            }
            aggregate.agg[i] = v;
        }
    }

    private void initGroupMeta(IRowMeta previousRowMeta) throws HopValueException {
        ((MemoryGroupByData)this.data).groupMeta = new RowMeta();
        ((MemoryGroupByData)this.data).entryMeta = new RowMeta();
        for (int i = 0; i < ((MemoryGroupByData)this.data).groupnrs.length; ++i) {
            IValueMeta valueMeta = previousRowMeta.getValueMeta(((MemoryGroupByData)this.data).groupnrs[i]);
            ((MemoryGroupByData)this.data).groupMeta.addValueMeta(valueMeta);
            IValueMeta normalMeta = valueMeta.clone();
            normalMeta.setStorageType(0);
        }
    }

    Object[] getAggregateResult(Aggregate aggregate) throws HopValueException {
        Object[] result = new Object[((MemoryGroupByData)this.data).subjectnrs.length];
        for (int i = 0; i < ((MemoryGroupByData)this.data).subjectnrs.length; ++i) {
            GAggregate agg = ((MemoryGroupByMeta)this.meta).getAggregates().get(i);
            Object ag = aggregate.agg[i];
            switch (agg.getType()) {
                case Sum: {
                    break;
                }
                case Average: {
                    ag = ValueDataUtil.divide((IValueMeta)((MemoryGroupByData)this.data).aggMeta.getValueMeta(i), (Object)ag, (IValueMeta)new ValueMetaInteger("c"), (Object)aggregate.counts[i]);
                    break;
                }
                case Median: 
                case Percentile: {
                    double percentile = 50.0;
                    if (agg.getType() == MemoryGroupByMeta.GroupType.Percentile) {
                        percentile = Double.parseDouble(agg.getValueField());
                    }
                    List valuesList = (List)aggregate.agg[i];
                    double[] values = new double[valuesList.size()];
                    for (int v = 0; v < values.length; ++v) {
                        values[v] = (Double)valuesList.get(v);
                    }
                    ag = new Percentile().evaluate(values, percentile);
                    break;
                }
                case CountDistinct: 
                case CountAll: 
                case CountAny: {
                    ag = aggregate.counts[i];
                    break;
                }
                case Minimum: {
                    break;
                }
                case Maximum: {
                    break;
                }
                case StandardDeviation: {
                    double sum = (Double)ag / (double)aggregate.counts[i];
                    ag = Math.sqrt(sum);
                    break;
                }
                case ConcatComma: 
                case ConcatString: {
                    ag = ((StringBuilder)ag).toString();
                    break;
                }
                case ConcatDistinct: {
                    IValueMeta subjMeta = ((MemoryGroupByData)this.data).inputRowMeta.getValueMeta(((MemoryGroupByData)this.data).subjectnrs[i]);
                    String separator = "";
                    if (!Utils.isEmpty((CharSequence)agg.getValueField())) {
                        separator = this.resolve(agg.getValueField());
                    }
                    StringJoiner joiner = new StringJoiner(separator);
                    for (Object value : (SortedSet)ag) {
                        joiner.add(subjMeta.getString(value));
                    }
                    ag = joiner.toString();
                    break;
                }
            }
            if (ag == null && this.allNullsAreZero) {
                IValueMeta vm = ((MemoryGroupByData)this.data).aggMeta.getValueMeta(i);
                ag = ValueDataUtil.getZeroForValueMetaType((IValueMeta)vm);
            }
            result[i] = ag;
        }
        return result;
    }

    public boolean init() {
        if (super.init()) {
            ((MemoryGroupByData)this.data).map = new HashMap(5000);
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        ((MemoryGroupByData)this.data).clear();
    }

    public void batchComplete() throws HopException {
        this.handleLastOfGroup();
        ((MemoryGroupByData)this.data).map.clear();
        ((MemoryGroupByData)this.data).newBatch = true;
    }

    void setAllNullsAreZero(boolean allNullsAreZero) {
        this.allNullsAreZero = allNullsAreZero;
    }

    void setMinNullIsValued(boolean minNullIsValued) {
        this.minNullIsValued = minNullIsValued;
    }
}

