/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.constant;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.constant.ConstantData;
import org.apache.hop.pipeline.transforms.constant.ConstantField;
import org.apache.hop.pipeline.transforms.constant.ConstantMeta;

public class Constant
extends BaseTransform<ConstantMeta, ConstantData> {
    private static final Class<?> PKG = ConstantMeta.class;

    public Constant(TransformMeta transformMeta, ConstantMeta meta, ConstantData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public static final RowMetaAndData buildRow(ConstantMeta meta, ConstantData data, List<ICheckResult> remarks) {
        RowMeta rowMeta = new RowMeta();
        Object[] rowData = new Object[meta.getFields().size()];
        for (int i = 0; i < meta.getFields().size(); ++i) {
            ConstantField field = meta.getFields().get(i);
            int valtype = ValueMetaFactory.getIdForValueMeta((String)field.getFieldType());
            if (field.getFieldName() == null) continue;
            IValueMeta value = null;
            try {
                value = ValueMetaFactory.createValueMeta((String)field.getFieldName(), (int)valtype);
            }
            catch (Exception exception) {
                remarks.add((ICheckResult)new CheckResult(4, exception.getMessage(), null));
                continue;
            }
            value.setLength(field.getFieldLength());
            value.setPrecision(field.getFieldPrecision());
            if (field.isEmptyString()) {
                rowData[i] = "";
            } else {
                String message;
                String stringValue = field.getValue();
                if (stringValue == null || stringValue.length() == 0) {
                    rowData[i] = null;
                    if (value.getType() == 0) {
                        message = BaseMessages.getString(PKG, (String)"Constant.CheckResult.SpecifyTypeError", (String[])new String[]{value.getName(), stringValue});
                        remarks.add((ICheckResult)new CheckResult(4, message, null));
                    }
                } else {
                    switch (value.getType()) {
                        case 1: {
                            String message2;
                            try {
                                if (field.getFieldFormat() != null || field.getDecimal() != null || field.getGroup() != null || field.getCurrency() != null) {
                                    if (!StringUtils.isEmpty((String)field.getFieldFormat())) {
                                        data.df.applyPattern(field.getFieldFormat());
                                    }
                                    if (!StringUtils.isEmpty((String)field.getDecimal())) {
                                        data.dfs.setDecimalSeparator(field.getDecimal().charAt(0));
                                    }
                                    if (!StringUtils.isEmpty((String)field.getGroup())) {
                                        data.dfs.setGroupingSeparator(field.getGroup().charAt(0));
                                    }
                                    if (!StringUtils.isEmpty((String)field.getCurrency())) {
                                        data.dfs.setCurrencySymbol(field.getCurrency());
                                    }
                                    data.df.setDecimalFormatSymbols(data.dfs);
                                }
                                rowData[i] = data.nf.parse(stringValue).doubleValue();
                            }
                            catch (Exception e) {
                                message2 = BaseMessages.getString(PKG, (String)"Constant.BuildRow.Error.Parsing.Number", (String[])new String[]{value.getName(), stringValue, e.toString()});
                                remarks.add((ICheckResult)new CheckResult(4, message2, null));
                            }
                            break;
                        }
                        case 2: {
                            rowData[i] = stringValue;
                            break;
                        }
                        case 3: {
                            String message2;
                            try {
                                if (field.getFieldFormat() != null) {
                                    data.daf.applyPattern(field.getFieldFormat());
                                    data.daf.setDateFormatSymbols(data.dafs);
                                }
                                rowData[i] = data.daf.parse(stringValue);
                            }
                            catch (Exception e) {
                                message2 = BaseMessages.getString(PKG, (String)"Constant.BuildRow.Error.Parsing.Date", (String[])new String[]{value.getName(), stringValue, e.toString()});
                                remarks.add((ICheckResult)new CheckResult(4, message2, null));
                            }
                            break;
                        }
                        case 5: {
                            String message2;
                            try {
                                rowData[i] = Long.valueOf(stringValue);
                            }
                            catch (Exception e) {
                                message2 = BaseMessages.getString(PKG, (String)"Constant.BuildRow.Error.Parsing.Integer", (String[])new String[]{value.getName(), stringValue, e.toString()});
                                remarks.add((ICheckResult)new CheckResult(4, message2, null));
                            }
                            break;
                        }
                        case 6: {
                            String message2;
                            try {
                                rowData[i] = new BigDecimal(stringValue);
                            }
                            catch (Exception e) {
                                message2 = BaseMessages.getString(PKG, (String)"Constant.BuildRow.Error.Parsing.BigNumber", (String[])new String[]{value.getName(), stringValue, e.toString()});
                                remarks.add((ICheckResult)new CheckResult(4, message2, null));
                            }
                            break;
                        }
                        case 4: {
                            rowData[i] = "Y".equalsIgnoreCase(stringValue) || "TRUE".equalsIgnoreCase(stringValue);
                            break;
                        }
                        case 8: {
                            rowData[i] = stringValue.getBytes();
                            break;
                        }
                        case 9: {
                            String message2;
                            try {
                                rowData[i] = Timestamp.valueOf(stringValue);
                            }
                            catch (Exception e) {
                                message2 = BaseMessages.getString(PKG, (String)"Constant.BuildRow.Error.Parsing.Timestamp", (String[])new String[]{value.getName(), stringValue, e.toString()});
                                remarks.add((ICheckResult)new CheckResult(4, message2, null));
                            }
                            break;
                        }
                        default: {
                            message = BaseMessages.getString(PKG, (String)"Constant.CheckResult.SpecifyTypeError", (String[])new String[]{value.getName(), stringValue});
                            remarks.add((ICheckResult)new CheckResult(4, message, null));
                        }
                    }
                }
            }
            rowMeta.addValueMeta(value);
        }
        return new RowMetaAndData((IRowMeta)rowMeta, rowData);
    }

    public boolean processRow() throws HopException {
        Object[] r = null;
        r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (((ConstantData)this.data).firstRow) {
            ((ConstantData)this.data).firstRow = false;
            ((ConstantData)this.data).outputMeta = this.getInputRowMeta().clone();
            ((ConstantMeta)this.meta).getFields(((ConstantData)this.data).outputMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        }
        r = RowDataUtil.addRowData((Object[])r, (int)this.getInputRowMeta().size(), (Object[])((ConstantData)this.data).getConstants().getData());
        this.putRow(((ConstantData)this.data).outputMeta, r);
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"Constant.Log.Wrote.Row", (String[])new String[]{Long.toString(this.getLinesWritten()), this.getInputRowMeta().getString(r)}));
        }
        if (this.checkFeedback(this.getLinesWritten()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"Constant.Log.LineNr", (String[])new String[]{Long.toString(this.getLinesWritten())}));
        }
        return true;
    }

    public boolean init() {
        ((ConstantData)this.data).firstRow = true;
        if (super.init()) {
            ArrayList<ICheckResult> remarks = new ArrayList<ICheckResult>();
            ((ConstantData)this.data).constants = Constant.buildRow((ConstantMeta)this.meta, (ConstantData)this.data, remarks);
            if (remarks.isEmpty()) {
                return true;
            }
            for (int i = 0; i < remarks.size(); ++i) {
                ICheckResult cr = (ICheckResult)remarks.get(i);
                this.logError(cr.getText());
            }
        }
        return false;
    }
}

