/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.GZipContentEncoding;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpEvents;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpPacketParsing;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.LZMAContentEncoding;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.MemoryManager;

public class HttpClientFilter
extends HttpCodecFilter {
    private final Attribute<Queue<HttpRequestPacket>> httpRequestQueueAttr;
    private final Attribute<HttpResponsePacket> httpResponseInProcessAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("HttpClientFilter.httpResponse");

    public HttpClientFilter() {
        this(8192);
    }

    public HttpClientFilter(int maxHeadersSize) {
        super(true, maxHeadersSize);
        this.httpRequestQueueAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("HttpClientFilter.httpRequest");
        this.contentEncodings.add(new GZipContentEncoding());
        this.contentEncodings.add(new LZMAContentEncoding());
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection c = ctx.getConnection();
        Object message = ctx.getMessage();
        if (HttpPacket.isHttp(message)) {
            assert (message instanceof HttpPacket);
            HttpHeader header = ((HttpPacket)message).getHttpHeader();
            if (!header.isCommitted() && header.isRequest()) {
                assert (header instanceof HttpRequestPacket);
                this.getRequestQueue(c).offer((HttpRequestPacket)header);
            }
        }
        return super.handleWrite(ctx);
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        HttpContext httpCtx;
        HttpRequestPacket request;
        Connection connection = ctx.getConnection();
        HttpResponsePacket httpResponse = this.httpResponseInProcessAttr.get(connection);
        if (httpResponse == null) {
            httpResponse = this.createHttpResponse(ctx);
            this.httpResponseInProcessAttr.set(connection, httpResponse);
        }
        if ((request = httpResponse.getRequest()) != null) {
            httpCtx = request.getProcessingState().getHttpContext();
            if (httpCtx == null) {
                httpCtx = HttpContext.newInstance(connection, connection, connection, request);
                request.getProcessingState().setHttpContext(httpCtx);
            }
        } else {
            httpCtx = HttpContext.newInstance(connection, connection, connection, null);
        }
        httpCtx.attach(ctx);
        return this.handleRead(ctx, httpResponse);
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (event.type() == HttpEvents.ChangePacketInProgressEvent.TYPE) {
            HttpResponsePacket responsePacket = (HttpResponsePacket)((HttpEvents.ChangePacketInProgressEvent)event).getPacket();
            this.httpResponseInProcessAttr.set(responsePacket.getProcessingState().getHttpContext(), responsePacket);
            return ctx.getStopAction();
        }
        return super.handleEvent(ctx, event);
    }

    private ClientHttpResponseImpl createHttpResponse(FilterChainContext ctx) {
        Buffer input = (Buffer)ctx.getMessage();
        Connection connection = ctx.getConnection();
        ClientHttpResponseImpl httpResponse = ClientHttpResponseImpl.create();
        HttpRequestPacket httpRequest = this.getRequestQueue(connection).poll();
        httpResponse.setRequest(httpRequest);
        httpResponse.initialize(this, input.position(), this.maxHeadersSize, -1);
        httpResponse.setSecure(HttpClientFilter.isSecure(connection));
        if (httpRequest != null) {
            try {
                Protocol protocol = httpRequest.getProtocol();
                if (Protocol.HTTP_2_0.equals((Object)protocol)) {
                    httpResponse.setProtocol(httpRequest.getProtocol());
                    httpResponse.setStatus(HttpStatus.OK_200);
                    httpResponse.setExpectContent(true);
                    httpResponse.setHeaderParsed(true);
                }
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
        }
        return httpResponse;
    }

    @Override
    protected boolean onHttpPacketParsed(HttpHeader httpHeader, FilterChainContext ctx) {
        Connection connection = ctx.getConnection();
        this.clearResponse(connection);
        return false;
    }

    @Override
    protected boolean onHttpHeaderParsed(HttpHeader httpHeader, Buffer buffer, FilterChainContext ctx) {
        ClientHttpResponseImpl response = (ClientHttpResponseImpl)httpHeader;
        HttpRequestPacket request = response.getRequest();
        int statusCode = response.getStatus();
        boolean noContent = statusCode == 204 || statusCode == 205 || statusCode == 304 || request != null && request.isHeadRequest();
        response.setExpectContent(!noContent);
        if (request != null) {
            response.getProcessingState().setKeepAlive(HttpClientFilter.checkKeepAlive(response));
        }
        return false;
    }

    @Override
    protected void onHttpHeaderError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
        throw new IllegalStateException(t);
    }

    @Override
    protected void onHttpContentError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
        httpHeader.setContentBroken(true);
        throw new IllegalStateException(t);
    }

    @Override
    protected void onInitialLineParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    @Override
    protected void onInitialLineEncoded(HttpHeader header, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpHeadersParsed(HttpHeader httpHeader, MimeHeaders headers, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpHeadersEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpContentParsed(HttpContent content, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpContentEncoded(HttpContent content, FilterChainContext ctx) {
    }

    protected final void clearResponse(Connection connection) {
        this.httpResponseInProcessAttr.remove(connection);
    }

    @Override
    protected Buffer encodeHttpPacket(FilterChainContext ctx, HttpPacket input) {
        HttpContent content;
        HttpHeader header;
        boolean isHeaderPacket = input.isHeader();
        if (isHeaderPacket) {
            header = (HttpHeader)input;
            content = null;
        } else {
            content = (HttpContent)input;
            header = content.getHttpHeader();
        }
        HttpRequestPacket request = (HttpRequestPacket)header;
        if (!request.isCommitted()) {
            HttpClientFilter.prepareRequest(request);
        }
        return super.encodeHttpPacket(ctx, header, content, false);
    }

    @Override
    final boolean decodeInitialLineFromBytes(FilterChainContext ctx, HttpPacketParsing httpPacket, HttpCodecFilter.HeaderParsingState parsingState, byte[] input, int end) {
        HttpResponsePacket httpResponse = (HttpResponsePacket)((Object)httpPacket);
        int arrayOffs = parsingState.arrayOffset;
        int packetLimit = arrayOffs + parsingState.packetLimit;
        int subState = parsingState.subState++;
        switch (subState) {
            case 0: {
                int spaceIdx = HttpCodecUtils.findSpace(input, arrayOffs + parsingState.offset, end, packetLimit);
                if (spaceIdx == -1) {
                    parsingState.offset = end - arrayOffs;
                    return false;
                }
                httpResponse.getProtocolDC().setBytes(input, arrayOffs + parsingState.start, spaceIdx);
                parsingState.start = -1;
                parsingState.offset = spaceIdx - arrayOffs;
            }
            case 1: {
                int nonSpaceIdx = HttpCodecUtils.skipSpaces(input, arrayOffs + parsingState.offset, end, packetLimit) - arrayOffs;
                if (nonSpaceIdx < 0) {
                    parsingState.offset = end - arrayOffs;
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx + 1;
                ++parsingState.subState;
            }
            case 2: {
                if (parsingState.offset + 3 > end - arrayOffs) {
                    return false;
                }
                httpResponse.setStatus(Ascii.parseInt(input, arrayOffs + parsingState.start, 3));
                parsingState.start = -1;
                parsingState.offset += 3;
                ++parsingState.subState;
            }
            case 3: {
                int nonSpaceIdx = HttpCodecUtils.skipSpaces(input, arrayOffs + parsingState.offset, end, packetLimit) - arrayOffs;
                if (nonSpaceIdx < 0) {
                    parsingState.offset = end - arrayOffs;
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx;
                ++parsingState.subState;
            }
            case 4: {
                if (!HttpCodecUtils.findEOL(parsingState, input, end)) {
                    parsingState.offset = end - arrayOffs;
                    return false;
                }
                httpResponse.getReasonPhraseRawDC().setBytes(input, arrayOffs + parsingState.start, arrayOffs + parsingState.checkpoint);
                parsingState.subState = 0;
                parsingState.start = -1;
                parsingState.checkpoint = -1;
                this.onInitialLineParsed(httpResponse, ctx);
                if (httpResponse.getStatus() == 100) {
                    parsingState.offset += 2;
                    parsingState.start = parsingState.offset;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    final boolean decodeInitialLineFromBuffer(FilterChainContext ctx, HttpPacketParsing httpPacket, HttpCodecFilter.HeaderParsingState parsingState, Buffer input) {
        HttpResponsePacket httpResponse = (HttpResponsePacket)((Object)httpPacket);
        int packetLimit = parsingState.packetLimit;
        int subState = parsingState.subState++;
        switch (subState) {
            case 0: {
                int spaceIdx = HttpCodecUtils.findSpace(input, parsingState.offset, packetLimit);
                if (spaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                httpResponse.getProtocolDC().setBuffer(input, parsingState.start, spaceIdx);
                parsingState.start = -1;
                parsingState.offset = spaceIdx;
            }
            case 1: {
                int nonSpaceIdx = HttpCodecUtils.skipSpaces(input, parsingState.offset, packetLimit);
                if (nonSpaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx + 1;
                ++parsingState.subState;
            }
            case 2: {
                if (parsingState.offset + 3 > input.limit()) {
                    return false;
                }
                httpResponse.setStatus(Ascii.parseInt(input, parsingState.start, 3));
                parsingState.start = -1;
                parsingState.offset += 3;
                ++parsingState.subState;
            }
            case 3: {
                int nonSpaceIdx = HttpCodecUtils.skipSpaces(input, parsingState.offset, packetLimit);
                if (nonSpaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx;
                ++parsingState.subState;
            }
            case 4: {
                if (!HttpCodecUtils.findEOL(parsingState, input)) {
                    parsingState.offset = input.limit();
                    return false;
                }
                httpResponse.getReasonPhraseRawDC().setBuffer(input, parsingState.start, parsingState.checkpoint);
                parsingState.subState = 0;
                parsingState.start = -1;
                parsingState.checkpoint = -1;
                this.onInitialLineParsed(httpResponse, ctx);
                if (httpResponse.getStatus() == 100) {
                    parsingState.offset += 2;
                    parsingState.start = 0;
                    input.position(parsingState.offset);
                    input.shrink();
                    parsingState.offset = 0;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    Buffer encodeInitialLine(HttpPacket httpPacket, Buffer output, MemoryManager memoryManager) {
        HttpRequestPacket httpRequest = (HttpRequestPacket)httpPacket;
        byte[] tempEncodingBuffer = httpRequest.getTempHeaderEncodingBuffer();
        output = HttpCodecUtils.put(memoryManager, output, tempEncodingBuffer, httpRequest.getMethodDC());
        output = HttpCodecUtils.put(memoryManager, output, (byte)32);
        output = HttpCodecUtils.put(memoryManager, output, tempEncodingBuffer, httpRequest.getRequestURIRef().getRequestURIBC());
        if (!httpRequest.getQueryStringDC().isNull()) {
            output = HttpCodecUtils.put(memoryManager, output, (byte)63);
            output = HttpCodecUtils.put(memoryManager, output, tempEncodingBuffer, httpRequest.getQueryStringDC());
        }
        output = HttpCodecUtils.put(memoryManager, output, (byte)32);
        output = HttpCodecUtils.put(memoryManager, output, tempEncodingBuffer, httpRequest.getProtocolString());
        return output;
    }

    private Queue<HttpRequestPacket> getRequestQueue(Connection c) {
        Queue<HttpRequestPacket> q = this.httpRequestQueueAttr.get(c);
        if (q == null) {
            q = new ConcurrentLinkedQueue<HttpRequestPacket>();
            this.httpRequestQueueAttr.set(c, q);
        }
        return q;
    }

    private static void prepareRequest(HttpRequestPacket request) {
        String contentType = request.getContentType();
        if (contentType != null) {
            request.getHeaders().setValue(Header.ContentType).setString(contentType);
        }
    }

    private static boolean checkKeepAlive(HttpResponsePacket response) {
        boolean keepAlive;
        int statusCode = response.getStatus();
        boolean isExpectContent = response.isExpectContent();
        boolean bl = keepAlive = !HttpClientFilter.statusDropsConnection(statusCode) || !isExpectContent || !response.isChunked() || response.getContentLength() == -1L;
        if (keepAlive) {
            DataChunk cVal = response.getHeaders().getValue(Header.Connection);
            keepAlive = response.getProtocol().compareTo(Protocol.HTTP_1_1) < 0 ? cVal != null && cVal.equalsIgnoreCase(KEEPALIVE_BYTES) : cVal == null || !cVal.equalsIgnoreCase(CLOSE_BYTES);
        }
        return keepAlive;
    }

    private static final class ClientHttpResponseImpl
    extends HttpResponsePacket
    implements HttpPacketParsing {
        private static final ThreadCache.CachedTypeIndex<ClientHttpResponseImpl> CACHE_IDX = ThreadCache.obtainIndex(ClientHttpResponseImpl.class, 16);
        private boolean contentTypeParsed;
        private boolean isHeaderParsed;
        private final HttpCodecFilter.HeaderParsingState headerParsingState = new HttpCodecFilter.HeaderParsingState();
        private final HttpCodecFilter.ContentParsingState contentParsingState = new HttpCodecFilter.ContentParsingState();

        public static ClientHttpResponseImpl create() {
            ClientHttpResponseImpl httpResponseImpl = ThreadCache.takeFromCache(CACHE_IDX);
            if (httpResponseImpl != null) {
                return httpResponseImpl;
            }
            return new ClientHttpResponseImpl();
        }

        private ClientHttpResponseImpl() {
        }

        public void initialize(HttpCodecFilter filter, int initialOffset, int maxHeaderSize, int maxNumberOfHeaders) {
            this.headerParsingState.initialize(filter, initialOffset, maxHeaderSize);
            this.headers.setMaxNumHeaders(maxNumberOfHeaders);
            this.contentParsingState.trailerHeaders.setMaxNumHeaders(maxNumberOfHeaders);
        }

        @Override
        public String getCharacterEncoding() {
            if (!this.contentTypeParsed) {
                this.parseContentTypeHeader();
            }
            return super.getCharacterEncoding();
        }

        @Override
        public void setCharacterEncoding(String charset) {
            if (!this.contentTypeParsed) {
                this.parseContentTypeHeader();
            }
            super.setCharacterEncoding(charset);
        }

        @Override
        public String getContentType() {
            if (!this.contentTypeParsed) {
                this.parseContentTypeHeader();
            }
            return super.getContentType();
        }

        private void parseContentTypeHeader() {
            DataChunk dc;
            this.contentTypeParsed = true;
            if (!this.contentType.isSet() && (dc = this.headers.getValue(Header.ContentType)) != null && !dc.isNull()) {
                this.setContentType(dc.toString());
            }
        }

        @Override
        protected HttpPacketParsing getParsingState() {
            return this;
        }

        @Override
        public HttpCodecFilter.HeaderParsingState getHeaderParsingState() {
            return this.headerParsingState;
        }

        @Override
        public HttpCodecFilter.ContentParsingState getContentParsingState() {
            return this.contentParsingState;
        }

        @Override
        public ProcessingState getProcessingState() {
            return this.getRequest().getProcessingState();
        }

        @Override
        public boolean isHeaderParsed() {
            return this.isHeaderParsed;
        }

        @Override
        public void setHeaderParsed(boolean isHeaderParsed) {
            this.isHeaderParsed = isHeaderParsed;
        }

        @Override
        protected void reset() {
            this.contentTypeParsed = false;
            this.isHeaderParsed = false;
            this.headerParsingState.recycle();
            this.contentParsingState.recycle();
            super.reset();
        }

        @Override
        public void recycle() {
            if (this.getRequest().isExpectContent()) {
                return;
            }
            this.reset();
            ThreadCache.putToCache(CACHE_IDX, this);
        }
    }
}

