/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import org.apache.beam.sdk.io.aws.options.S3ClientBuilderFactory;
import org.apache.beam.sdk.io.aws.options.S3Options;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DefaultS3ClientBuilderFactory
implements S3ClientBuilderFactory {
    @Override
    public @UnknownKeyFor @NonNull @Initialized AmazonS3ClientBuilder createBuilder(@UnknownKeyFor @NonNull @Initialized S3Options s3Options) {
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(s3Options.getAwsCredentialsProvider());
        if (s3Options.getClientConfiguration() != null) {
            builder = (AmazonS3ClientBuilder)builder.withClientConfiguration(s3Options.getClientConfiguration());
        }
        if (!Strings.isNullOrEmpty((String)s3Options.getAwsServiceEndpoint())) {
            builder = (AmazonS3ClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(s3Options.getAwsServiceEndpoint(), s3Options.getAwsRegion()));
        } else if (!Strings.isNullOrEmpty((String)s3Options.getAwsRegion())) {
            builder = (AmazonS3ClientBuilder)builder.withRegion(s3Options.getAwsRegion());
        }
        return builder;
    }
}

