/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.codahale.metrics.Timer;
import com.google.api.client.util.NanoClock;
import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.grpc.BigtableSessionSharedThreadPools;
import com.google.cloud.bigtable.grpc.async.ResourceLimiterStats;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@InternalApi(value="For internal usage only")
public class ResourceLimiter {
    private static final Logger LOG = new Logger(ResourceLimiter.class);
    private static final long REGISTER_WAIT_MILLIS = 5L;
    private final long maxHeapSize;
    private final int absoluteMaxInFlightRpcs;
    private final ResourceLimiterStats stats;
    private final AtomicLong operationSequenceGenerator = new AtomicLong();
    private final Map<Long, Long> pendingOperationsWithSize = new HashMap<Long, Long>();
    private final ConcurrentHashMap<Long, Long> starTimes = new ConcurrentHashMap();
    private final LinkedBlockingDeque<Long> completedOperationIds = new LinkedBlockingDeque();
    private long currentWriteBufferSize;
    private boolean isThrottling = false;
    private int currentInFlightMaxRpcs;
    @VisibleForTesting
    NanoClock clock = NanoClock.SYSTEM;

    public ResourceLimiter(ResourceLimiterStats stats, long maxHeapSize, int maxInFlightRpcs) {
        this.stats = stats;
        this.maxHeapSize = maxHeapSize;
        this.absoluteMaxInFlightRpcs = maxInFlightRpcs;
        this.currentInFlightMaxRpcs = maxInFlightRpcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerOperationWithHeapSize(long heapSize) throws InterruptedException {
        long start = this.clock.nanoTime();
        ResourceLimiter resourceLimiter = this;
        synchronized (resourceLimiter) {
            while (this.unsynchronizedIsFull()) {
                this.waitForCompletions(5L);
            }
            long waitComplete = this.clock.nanoTime();
            this.stats.markThrottling(waitComplete - start);
            long operationId = this.operationSequenceGenerator.incrementAndGet();
            this.pendingOperationsWithSize.put(operationId, heapSize);
            this.currentWriteBufferSize += heapSize;
            this.starTimes.put(operationId, waitComplete);
            return operationId;
        }
    }

    public void markCanBeCompleted(long id) {
        Long opId = id;
        this.completedOperationIds.offerLast(opId);
        Long start = this.starTimes.remove(opId);
        if (start != null) {
            this.stats.markRpcComplete(this.clock.nanoTime() - start);
        }
    }

    public long getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public int getAbsoluteMaxInFlightRpcs() {
        return this.absoluteMaxInFlightRpcs;
    }

    public int getCurrentInFlightMaxRpcs() {
        return this.currentInFlightMaxRpcs;
    }

    public void setCurrentInFlightMaxRpcs(int currentInFlightMaxRpcs) {
        this.currentInFlightMaxRpcs = currentInFlightMaxRpcs;
    }

    public long getHeapSize() {
        return this.currentWriteBufferSize;
    }

    public synchronized boolean isFull() {
        return this.unsynchronizedIsFull();
    }

    private boolean isFullInternal() {
        return this.currentWriteBufferSize >= this.maxHeapSize || this.pendingOperationsWithSize.size() >= this.currentInFlightMaxRpcs;
    }

    private boolean unsynchronizedIsFull() {
        if (!this.isFullInternal()) {
            return false;
        }
        this.cleanupFinishedOperations();
        return this.isFullInternal();
    }

    public synchronized boolean hasInflightRequests() {
        this.cleanupFinishedOperations();
        return !this.pendingOperationsWithSize.isEmpty();
    }

    private void cleanupFinishedOperations() {
        ArrayList<Long> toClean = new ArrayList<Long>();
        this.completedOperationIds.drainTo(toClean);
        if (!toClean.isEmpty()) {
            this.markOperationsCompleted(toClean);
        }
    }

    private synchronized void markOperationsCompleted(List<Long> operationSequenceIds) {
        for (Long operationSequenceId : operationSequenceIds) {
            this.markOperationComplete(operationSequenceId);
        }
    }

    private void waitForCompletions(long timeoutMs) throws InterruptedException {
        Long completedOperation = this.completedOperationIds.pollFirst(timeoutMs, TimeUnit.MILLISECONDS);
        if (completedOperation != null) {
            this.markOperationComplete(completedOperation);
        }
    }

    private void markOperationComplete(Long operationSequenceId) {
        Long heapSize = this.pendingOperationsWithSize.remove(operationSequenceId);
        if (heapSize != null) {
            this.currentWriteBufferSize -= heapSize.longValue();
        } else {
            LOG.warn("An operation completed successfully but provided multiple completion notifications. Please notify Google that this occurred.", new Object[0]);
        }
    }

    public synchronized void throttle(final int bulkMutationRpcTargetMs) {
        if (this.isThrottling) {
            return;
        }
        LOG.info("Initializing BulkMutation throttling.  Once latency is higher than %d ms, parallelism will be reduced.", bulkMutationRpcTargetMs);
        final long highTargetMs = (long)((double)bulkMutationRpcTargetMs * 1.2);
        final long lowTargetMs = (long)((double)bulkMutationRpcTargetMs * 0.8);
        this.setCurrentInFlightMaxRpcs(this.getCurrentInFlightMaxRpcs() / 4);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                long meanLatencyMs = this.getMeanMs(ResourceLimiter.this.stats.getMutationTimer());
                if (meanLatencyMs >= (long)(bulkMutationRpcTargetMs * 3)) {
                    this.reduceParallelism(meanLatencyMs, ResourceLimiter.this.absoluteMaxInFlightRpcs * 3 / 10);
                } else if (meanLatencyMs >= highTargetMs) {
                    this.reduceParallelism(meanLatencyMs, ResourceLimiter.this.absoluteMaxInFlightRpcs / 10);
                } else if (this.getMeanMs(ResourceLimiter.this.stats.getThrottlingTimer()) > 1L) {
                    if (meanLatencyMs <= lowTargetMs) {
                        this.increaseParallelism(meanLatencyMs, ResourceLimiter.this.absoluteMaxInFlightRpcs / 20);
                    } else if (ResourceLimiter.this.currentInFlightMaxRpcs < ResourceLimiter.this.absoluteMaxInFlightRpcs / 20 && meanLatencyMs <= (long)(bulkMutationRpcTargetMs * 2)) {
                        this.increaseParallelism(meanLatencyMs, ResourceLimiter.this.absoluteMaxInFlightRpcs / 50);
                    }
                }
            }

            private long getMeanMs(Timer timer) {
                return TimeUnit.NANOSECONDS.toMillis((long)timer.getSnapshot().getMean());
            }

            private void reduceParallelism(long meanLatencyNanos, int step) {
                int minimumRpcCount = Math.max(ResourceLimiter.this.absoluteMaxInFlightRpcs / 100, 1);
                int newValue = Math.max(ResourceLimiter.this.currentInFlightMaxRpcs - step, minimumRpcCount);
                this.setParallelism(meanLatencyNanos, "Reducing", newValue);
            }

            private void increaseParallelism(long meanLatencyNanos, int incrementStep) {
                int newValue = Math.min(ResourceLimiter.this.currentInFlightMaxRpcs + incrementStep, ResourceLimiter.this.absoluteMaxInFlightRpcs);
                this.setParallelism(meanLatencyNanos, "Increasing", newValue);
            }

            private void setParallelism(long meanLatencyNanos, String type, int newValue) {
                int currentValue = ResourceLimiter.this.getCurrentInFlightMaxRpcs();
                if (newValue != currentValue) {
                    ResourceLimiter.this.setCurrentInFlightMaxRpcs(newValue);
                    LOG.debug("Latency is at %d ms. %s paralellelism from %d to %d.", TimeUnit.NANOSECONDS.toMillis(meanLatencyNanos), type, currentValue, newValue);
                }
            }
        };
        BigtableSessionSharedThreadPools.getInstance().getRetryExecutor().scheduleAtFixedRate(r, 20L, 20L, TimeUnit.SECONDS);
        this.isThrottling = true;
    }
}

