/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.UpdateAppProfileRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.AppProfile;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.FieldMask;
import com.google.protobuf.util.FieldMaskUtil;
import javax.annotation.Nonnull;

public final class UpdateAppProfileRequest {
    private final String instanceId;
    private final String appProfileId;
    private final UpdateAppProfileRequest.Builder proto;

    public static UpdateAppProfileRequest of(@Nonnull AppProfile appProfile) {
        return new UpdateAppProfileRequest(appProfile.getInstanceId(), appProfile.getId(), com.google.bigtable.admin.v2.UpdateAppProfileRequest.newBuilder().setAppProfile(appProfile.toProto()));
    }

    public static UpdateAppProfileRequest of(@Nonnull String instanceId, @Nonnull String appProfileId) {
        return new UpdateAppProfileRequest(instanceId, appProfileId, com.google.bigtable.admin.v2.UpdateAppProfileRequest.newBuilder());
    }

    private UpdateAppProfileRequest(@Nonnull String instanceId, @Nonnull String appProfileId, @Nonnull UpdateAppProfileRequest.Builder proto) {
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId must be set");
        Preconditions.checkNotNull((Object)appProfileId, (Object)"appProfileId must be set");
        Preconditions.checkNotNull((Object)proto, (Object)"proto must be set");
        this.instanceId = instanceId;
        this.appProfileId = appProfileId;
        this.proto = proto;
    }

    public UpdateAppProfileRequest setIgnoreWarnings(boolean value) {
        this.proto.setIgnoreWarnings(value);
        return this;
    }

    public UpdateAppProfileRequest setDescription(@Nonnull String description) {
        Preconditions.checkNotNull((Object)description);
        this.proto.getAppProfileBuilder().setDescription(description);
        this.updateFieldMask(3);
        return this;
    }

    public UpdateAppProfileRequest setRoutingPolicy(@Nonnull AppProfile.RoutingPolicy routingPolicy) {
        Preconditions.checkNotNull((Object)routingPolicy);
        if (routingPolicy instanceof AppProfile.MultiClusterRoutingPolicy) {
            this.proto.getAppProfileBuilder().setMultiClusterRoutingUseAny(((AppProfile.MultiClusterRoutingPolicy)routingPolicy).toProto());
            this.updateFieldMask(5);
        } else if (routingPolicy instanceof AppProfile.SingleClusterRoutingPolicy) {
            this.proto.getAppProfileBuilder().setSingleClusterRouting(((AppProfile.SingleClusterRoutingPolicy)routingPolicy).toProto());
            this.updateFieldMask(6);
        } else {
            throw new IllegalArgumentException("Unknown policy type: " + routingPolicy);
        }
        return this;
    }

    private void updateFieldMask(int fieldNumber) {
        FieldMask newMask = FieldMaskUtil.fromFieldNumbers(com.google.bigtable.admin.v2.AppProfile.class, (int[])new int[]{fieldNumber});
        this.proto.setUpdateMask(FieldMaskUtil.union((FieldMask)this.proto.getUpdateMask(), (FieldMask)newMask, (FieldMask[])new FieldMask[0]));
    }

    @InternalApi
    public com.google.bigtable.admin.v2.UpdateAppProfileRequest toProto(String projectId) {
        String name = NameUtil.formatAppProfileName(projectId, this.instanceId, this.appProfileId);
        this.proto.getAppProfileBuilder().setName(name);
        return this.proto.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateAppProfileRequest that = (UpdateAppProfileRequest)o;
        return Objects.equal((Object)this.instanceId, (Object)that.instanceId) && Objects.equal((Object)this.appProfileId, (Object)that.appProfileId) && Objects.equal((Object)this.proto.build(), (Object)that.proto.build());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.instanceId, this.appProfileId, this.proto.build()});
    }
}

