/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.Backup;
import com.google.bigtable.admin.v2.BackupName;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.EncryptionInfo;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

public class Backup {
    @Nonnull
    private final com.google.bigtable.admin.v2.Backup proto;
    @Nonnull
    private final String id;
    @Nonnull
    private final String instanceId;

    @InternalApi
    public static Backup fromProto(@Nonnull com.google.bigtable.admin.v2.Backup proto) {
        return new Backup(proto);
    }

    private Backup(@Nonnull com.google.bigtable.admin.v2.Backup proto) {
        Preconditions.checkNotNull((Object)proto);
        Preconditions.checkArgument((!proto.getName().isEmpty() ? 1 : 0) != 0, (Object)"Name must be set");
        Preconditions.checkArgument((!proto.getSourceTable().isEmpty() ? 1 : 0) != 0, (Object)"Source table must be set");
        BackupName name = BackupName.parse((String)proto.getName());
        this.id = name.getBackup();
        this.instanceId = name.getInstance();
        this.proto = proto;
    }

    public String getId() {
        return this.id;
    }

    public String getSourceTableId() {
        return NameUtil.extractTableIdFromTableName(this.proto.getSourceTable());
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Instant getExpireTime() {
        return Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)this.proto.getExpireTime()));
    }

    @Nullable
    public Instant getStartTime() {
        if (this.proto.hasStartTime()) {
            return Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)this.proto.getStartTime()));
        }
        return null;
    }

    @Nullable
    public Instant getEndTime() {
        if (this.proto.hasEndTime()) {
            return Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)this.proto.getEndTime()));
        }
        return null;
    }

    public long getSizeBytes() {
        return this.proto.getSizeBytes();
    }

    public State getState() {
        return State.fromProto(this.proto.getState());
    }

    public EncryptionInfo getEncryptionInfo() {
        return EncryptionInfo.fromProto(this.proto.getEncryptionInfo());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Backup backup = (Backup)o;
        return Objects.equal((Object)this.proto, (Object)backup.proto);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proto});
    }

    public static enum State {
        STATE_UNSPECIFIED(Backup.State.STATE_UNSPECIFIED),
        CREATING(Backup.State.CREATING),
        READY(Backup.State.READY),
        UNRECOGNIZED(Backup.State.UNRECOGNIZED);

        private final Backup.State proto;

        private State(Backup.State proto) {
            this.proto = proto;
        }

        @InternalApi
        public static State fromProto(Backup.State proto) {
            for (State state : State.values()) {
                if (!state.proto.equals((Object)proto)) continue;
                return state;
            }
            return STATE_UNSPECIFIED;
        }

        @InternalApi
        public Backup.State toProto() {
            return this.proto;
        }
    }
}

