/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.DirtyState;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MetricCell;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.MetricName;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class CounterCell
implements Counter,
MetricCell<Long> {
    private final @UnknownKeyFor @NonNull @Initialized DirtyState dirty = new DirtyState();
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong value = new AtomicLong();
    private final @UnknownKeyFor @NonNull @Initialized MetricName name;

    public CounterCell(@UnknownKeyFor @NonNull @Initialized MetricName name) {
        this.name = name;
    }

    @Override
    public void reset() {
        this.value.set(0L);
        this.dirty.reset();
    }

    public void inc(@UnknownKeyFor @NonNull @Initialized long n) {
        this.value.addAndGet(n);
        this.dirty.afterModification();
    }

    public void inc() {
        this.inc(1L);
    }

    public void dec() {
        this.inc(-1L);
    }

    public void dec(@UnknownKeyFor @NonNull @Initialized long n) {
        this.inc(-1L * n);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DirtyState getDirty() {
        return this.dirty;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Long getCumulative() {
        return this.value.get();
    }

    public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
        return this.name;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (object instanceof CounterCell) {
            CounterCell counterCell = (CounterCell)object;
            return Objects.equals(this.dirty, counterCell.dirty) && this.value.get() == counterCell.value.get() && Objects.equals(this.name, counterCell.name);
        }
        return false;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.dirty, this.value.get(), this.name);
    }
}

