/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxException;
import java.io.IOException;
import java.security.cert.CertPathValidatorException;
import javax.net.ssl.SSLHandshakeException;

public class NetworkIOException
extends DbxException {
    private static final long serialVersionUID = 0L;

    public NetworkIOException(IOException cause) {
        super(NetworkIOException.computeMessage(cause), cause);
    }

    private static String computeMessage(IOException ex) {
        Throwable innerCause;
        String message = ex.getMessage();
        if (ex instanceof SSLHandshakeException && (innerCause = ex.getCause()) instanceof CertPathValidatorException) {
            CertPathValidatorException cpve = (CertPathValidatorException)innerCause;
            message = message + "[CERT PATH: " + cpve.getCertPath() + "]";
        }
        return message;
    }

    @Override
    public IOException getCause() {
        return (IOException)super.getCause();
    }
}

