/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDataValues;
import com.ibm.as400.data.PcmlDimensions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

class PcmlDataVector
extends Vector {
    static final long serialVersionUID = -8169008879805188674L;
    private PcmlData m_owner;
    private PcmlDimensions m_indices;
    private long m_dimTs;

    PcmlDataVector(PcmlData pcmlData, PcmlDimensions pcmlDimensions) {
        this.m_owner = pcmlData;
        this.m_indices = new PcmlDimensions(pcmlDimensions);
        this.m_dimTs = this.m_owner.getDoc().getCorrelationID();
    }

    PcmlDataVector(int n, PcmlData pcmlData, PcmlDimensions pcmlDimensions) {
        super(n);
        this.m_owner = pcmlData;
        this.m_indices = new PcmlDimensions(pcmlDimensions);
        this.m_dimTs = this.m_owner.getDoc().getCorrelationID();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    void readObjectPostprocessing() {
        this.m_dimTs = this.m_owner.getDoc().getDeserializationTimestamp();
        for (int i = 0; i < this.size(); ++i) {
            Object e = this.elementAt(i);
            if (e instanceof PcmlDataValues) {
                ((PcmlDataValues)e).readObjectPostprocessing();
                continue;
            }
            if (!(e instanceof PcmlDataVector)) continue;
            ((PcmlDataVector)e).readObjectPostprocessing();
        }
    }

    long getTimestamp() {
        return this.m_dimTs;
    }

    void flushValues() {
        for (int i = 0; i < this.size(); ++i) {
            Object e = this.elementAt(i);
            if (e instanceof PcmlDataValues) {
                ((PcmlDataValues)e).flushValues();
            } else if (e instanceof PcmlDataVector) {
                ((PcmlDataVector)e).flushValues();
            }
            this.setElementAt(null, i);
        }
    }

    void redimension(int n) {
        this.flushValues();
        this.m_dimTs = this.m_owner.getDoc().getCorrelationID();
        if (n > this.capacity()) {
            this.ensureCapacity(n);
            this.setSize(n);
        } else {
            this.setSize(n);
            this.trimToSize();
        }
    }

    PcmlDataValues valuesAt(int n) {
        return (PcmlDataValues)this.elementAt(n);
    }

    PcmlDataVector vectorAt(int n) {
        return (PcmlDataVector)this.elementAt(n);
    }

    void populateWithValues() {
        PcmlDimensions pcmlDimensions = new PcmlDimensions(this.m_indices);
        for (int i = 0; i < this.size(); ++i) {
            pcmlDimensions.add(i);
            PcmlDataValues pcmlDataValues = this.valuesAt(i);
            if (pcmlDataValues == null) {
                pcmlDataValues = new PcmlDataValues(this.m_owner, pcmlDimensions);
                this.setElementAt(pcmlDataValues, i);
            } else {
                pcmlDataValues.flushValues();
            }
            pcmlDimensions.remove();
        }
    }
}

