/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDSplF;
import com.ibm.as400.access.OutputQueue;
import com.ibm.as400.access.OutputQueueImpl;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintObjectInputStream;
import com.ibm.as400.access.PrintObjectPageInputStream;
import com.ibm.as400.access.PrintObjectTransformedInputStream;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SpooledFileImpl;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class SpooledFile
extends PrintObject
implements Serializable {
    static final long serialVersionUID = 4L;
    transient boolean fMsgRetrieved_ = false;

    SpooledFile(AS400 aS400, NPCPIDSplF nPCPIDSplF, NPCPAttribute nPCPAttribute) {
        super(aS400, nPCPIDSplF, nPCPAttribute, 1);
    }

    public SpooledFile(AS400 aS400, String string, int n, String string2, String string3, String string4) {
        super(aS400, new NPCPIDSplF(string, n, string2, string3, string4), null, 1);
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (n < -1) {
            Trace.log(2, "Parameter 'number' is less than -1.");
            throw new ExtendedIllegalArgumentException("number(" + n + ")", 2);
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'jobName' is null.");
            throw new NullPointerException("jobName");
        }
        if (string3 == null) {
            Trace.log(2, "Parameter 'jobUser' is null.");
            throw new NullPointerException("jobUser");
        }
        if (string4 == null) {
            Trace.log(2, "Parameter 'jobNumber' is null.");
            throw new NullPointerException("jobNumber");
        }
    }

    public SpooledFile(AS400 aS400, String string, int n, String string2, String string3, String string4, String string5, String string6, String string7) {
        super(aS400, new NPCPIDSplF(string, n, string2, string3, string4, string5, string6, string7), null, 1);
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (n < -1) {
            Trace.log(2, "Parameter 'number' is less than -1.");
            throw new ExtendedIllegalArgumentException("number(" + n + ")", 2);
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'jobName' is null.");
            throw new NullPointerException("jobName");
        }
        if (string3 == null) {
            Trace.log(2, "Parameter 'jobUser' is null.");
            throw new NullPointerException("jobUser");
        }
        if (string4 == null) {
            Trace.log(2, "Parameter 'jobNumber' is null.");
            throw new NullPointerException("jobNumber");
        }
        if (string5 == null) {
            Trace.log(2, "Parameter 'jobSysName' is null.");
            throw new NullPointerException("jobSysName");
        }
        if (string6 == null) {
            Trace.log(2, "Parameter 'createDate' is null.");
            throw new NullPointerException("createDate");
        }
        if (string7 == null) {
            Trace.log(2, "Parameter 'createTime' is null.");
            throw new NullPointerException("createTime");
        }
    }

    public void answerMessage(String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).answerMessage(string);
        this.attrs = this.impl_.getAttrValue();
        this.fMsgRetrieved_ = ((SpooledFileImpl)this.impl_).getFMsgRetrieved();
    }

    void chooseImpl() throws IOException, AS400SecurityException {
        AS400 aS400 = this.getSystem();
        if (aS400 == null) {
            Trace.log(2, "Attempt to use SpooledFile before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (SpooledFileImpl)aS400.loadImpl2("com.ibm.as400.access.SpooledFileImplRemote", "com.ibm.as400.access.SpooledFileImplProxy");
        super.setImpl();
    }

    public SpooledFile copy() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        String string = this.getStringAttribute(-6);
        OutputQueue outputQueue = new OutputQueue(this.getSystem(), string);
        SpooledFile spooledFile = this.copy(outputQueue);
        return spooledFile;
    }

    public SpooledFile copy(OutputQueue outputQueue) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPCPIDSplF nPCPIDSplF;
        block4: {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            if (outputQueue.getImpl() == null) {
                outputQueue.chooseImpl();
            }
            nPCPIDSplF = ((SpooledFileImpl)this.impl_).copy((OutputQueueImpl)outputQueue.getImpl());
            try {
                nPCPIDSplF.setConverter(new Converter((int)this.getSystem().getCcsid(), (AS400)this.getSystem()).impl);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!Trace.isTraceErrorOn()) break block4;
                Trace.log(2, "Error initializing converter for spooled file.");
            }
        }
        SpooledFile spooledFile = new SpooledFile(this.getSystem(), nPCPIDSplF, null);
        return spooledFile;
    }

    public void delete() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).delete();
    }

    public PrintObjectInputStream getInputStream() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        PrintObjectInputStream printObjectInputStream = new PrintObjectInputStream(this, null);
        return printObjectInputStream;
    }

    public PrintObjectInputStream getInputStream(PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        PrintObjectInputStream printObjectInputStream = new PrintObjectInputStream(this, printParameterList);
        return printObjectInputStream;
    }

    public PrintObjectInputStream getInputACIFMergedStream(boolean bl) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        String string = bl ? "Y" : "N";
        PrintObjectInputStream printObjectInputStream = new PrintObjectInputStream(this, null, string);
        return printObjectInputStream;
    }

    public PrintObjectInputStream getAFPInputStream() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        PrintObjectInputStream printObjectInputStream = new PrintObjectInputStream(this, null, "Y");
        return printObjectInputStream;
    }

    public String getJobName() {
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return "";
        }
        return nPCPID.getStringValue(59);
    }

    public String getJobNumber() {
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return "";
        }
        return nPCPID.getStringValue(60);
    }

    public String getJobUser() {
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return "";
        }
        return nPCPID.getStringValue(62);
    }

    public String getJobSysName() {
        String string = "";
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return string;
        }
        string = nPCPID.getStringValue(251);
        if (string == null) {
            try {
                string = this.getStringAttribute(251);
            }
            catch (Exception exception) {
                string = "";
            }
        }
        return string;
    }

    public String getCreateDate() {
        String string = "";
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return string;
        }
        string = nPCPID.getStringValue(34);
        if (string == null) {
            try {
                string = this.getStringAttribute(34);
            }
            catch (Exception exception) {
                string = "";
            }
        }
        return string;
    }

    public String getCreateTime() {
        String string = "";
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return string;
        }
        string = nPCPID.getStringValue(110);
        if (string == null) {
            try {
                string = this.getStringAttribute(110);
            }
            catch (Exception exception) {
                string = "";
            }
        }
        return string;
    }

    public AS400Message getMessage() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        AS400Message aS400Message = ((SpooledFileImpl)this.impl_).getMessage();
        this.fMsgRetrieved_ = ((SpooledFileImpl)this.impl_).getFMsgRetrieved();
        return aS400Message;
    }

    public String getName() {
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return "";
        }
        return nPCPID.getStringValue(104);
    }

    public int getNumber() {
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return 0;
        }
        return nPCPID.getIntValue(105);
    }

    public PrintObjectPageInputStream getPageInputStream(PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        PrintObjectPageInputStream printObjectPageInputStream = new PrintObjectPageInputStream(this, printParameterList);
        return printObjectPageInputStream;
    }

    public PrintObjectTransformedInputStream getTransformedInputStream(PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        PrintObjectTransformedInputStream printObjectTransformedInputStream = new PrintObjectTransformedInputStream(this, printParameterList);
        return printObjectTransformedInputStream;
    }

    public void hold(String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).hold(string);
        this.attrs = this.impl_.getAttrValue();
    }

    public void move(SpooledFile spooledFile) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (spooledFile.getImpl() == null) {
            spooledFile.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).move((SpooledFileImpl)spooledFile.getImpl());
        this.attrs = this.impl_.getAttrValue();
    }

    public void move(OutputQueue outputQueue) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (outputQueue.getImpl() == null) {
            outputQueue.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).move((OutputQueueImpl)outputQueue.getImpl());
        this.attrs = this.impl_.getAttrValue();
    }

    public void moveToTop() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).moveToTop();
        this.attrs = this.impl_.getAttrValue();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.fMsgRetrieved_ = false;
    }

    public void release() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).release();
        this.attrs = this.impl_.getAttrValue();
    }

    public void sendNet(PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).sendNet(printParameterList);
    }

    public void sendTCP(PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).sendTCP(printParameterList);
    }

    public void setAttributes(PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (printParameterList == null) {
            Trace.log(2, "Parameter 'attributes' is null.");
            throw new NullPointerException("attributes");
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((SpooledFileImpl)this.impl_).setAttributes(printParameterList);
        if (this.attrs == null) {
            this.attrs = new NPCPAttribute();
        }
        this.attrs = this.impl_.getAttrValue();
    }
}

