/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.metadata;

import java.util.ArrayList;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.metadata.IMetadataDialog;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class MetadataEditorDialog
extends Dialog
implements IMetadataDialog {
    private static final Class<?> PKG = MetadataEditorDialog.class;
    private Shell shell;
    private MetadataEditor<?> editor;
    private String result;

    public MetadataEditorDialog(Shell parent, MetadataEditor<?> editor) {
        super(parent);
        this.editor = editor;
    }

    @Override
    public String open() {
        PropsUi props = PropsUi.getInstance();
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.shell.setText(this.editor.getTitle());
        this.shell.setImage(this.editor.getTitleImage());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin() * 2;
        formLayout.marginHeight = PropsUi.getFormMargin() * 2;
        this.shell.setLayout((Layout)formLayout);
        PropsUi.setLook((Widget)this.shell);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        ArrayList<Button> buttons = new ArrayList<Button>();
        buttons.add(wOk);
        Button[] extras = this.editor.createButtonsForButtonBar((Composite)this.shell);
        if (extras != null) {
            for (Button button : extras) {
                buttons.add(button);
            }
        }
        buttons.add(wCancel);
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, buttons.toArray(new Button[0]), props.getMargin(), null);
        Button wHelp = this.editor.createHelpButton(this.shell);
        FormData fdHelp = new FormData();
        fdHelp.bottom = new FormAttachment(100, 0);
        fdHelp.left = new FormAttachment(0, 0);
        wHelp.setLayoutData((Object)fdHelp);
        Composite area = new Composite((Composite)this.shell, 0);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        area.setLayout((Layout)layout);
        FormData fdArea = new FormData();
        fdArea.left = new FormAttachment(0, 0);
        fdArea.top = new FormAttachment(0, 0);
        fdArea.right = new FormAttachment(100, 0);
        fdArea.bottom = new FormAttachment((Control)wOk, -props.getMargin());
        area.setLayoutData((Object)fdArea);
        PropsUi.setLook((Widget)area);
        this.editor.createControl(area);
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.result;
    }

    protected void cancel() {
        this.dispose();
    }

    protected void ok() {
        try {
            this.editor.save();
            this.result = this.editor.getMetadata().getName();
            this.dispose();
        }
        catch (HopException e) {
            new ErrorDialog(this.getParent(), BaseMessages.getString(PKG, (String)"MetadataEditor.Dialog.Ok.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetadataEditor.Dialog.Ok.Error.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void dispose() {
        PropsUi.getInstance().setScreen(new WindowProperty(this.shell));
        this.editor.dispose();
        this.shell.dispose();
    }
}

