/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.userdefinedjavaclass;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.rowgenerator.GeneratorField;
import org.apache.hop.pipeline.transforms.rowgenerator.RowGeneratorMeta;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.FieldHelper;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.InfoTransformDefinition;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.TargetTransformDefinition;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.UsageParameter;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.UserDefinedJavaClassCodeSnippits;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.UserDefinedJavaClassDef;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.UserDefinedJavaClassMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.dialog.ShowMessageDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.TextSizeUtilFacade;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class UserDefinedJavaClassDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = UserDefinedJavaClassMeta.class;
    private ModifyListener lsMod;
    private TableView wFields;
    private Label wlPosition;
    private Button wClearResultFields;
    private Tree wTree;
    private TreeItem wTreeClassesItem;
    private Image imageActiveScript;
    private Image imageInactiveScript;
    private CTabFolder folder;
    private CTabFolder wTabFolder;
    private Menu cMenu;
    private Menu tMenu;
    private TreeItem[] lastItem;
    private TreeEditor editor;
    private String strActiveScript;
    private UserDefinedJavaClassMeta input;
    private UserDefinedJavaClassCodeSnippits snippitsHelper;
    private static final GuiResource guiResource = GuiResource.getInstance();
    private TreeItem itemInput;
    private TreeItem itemInfo;
    private TreeItem itemOutput;
    private IRowMeta inputRowMeta;
    private IRowMeta infoRowMeta;
    private IRowMeta outputRowMeta;
    private RowGeneratorMeta genMeta;
    private CTabItem fieldsTab;
    private int margin;
    private TableView wInfoTransforms;
    private TableView wTargetTransforms;
    private TableView wParameters;
    private String[] prevTransformNames;
    private String[] nextTransformNames;

    public UserDefinedJavaClassDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (UserDefinedJavaClassMeta)((Object)in);
        this.genMeta = null;
        try {
            this.imageActiveScript = SwtSvgImageUtil.getImage((Display)parent.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"userdefinedjavaclass.svg", (int)16, (int)16);
            this.imageInactiveScript = SwtSvgImageUtil.getImage((Display)parent.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"userdefinedjavaclass.svg", (int)16, (int)16);
        }
        catch (Exception e) {
            this.imageActiveScript = guiResource.getImageEmpty();
            this.imageInactiveScript = guiResource.getImageEmpty();
        }
        try {
            this.snippitsHelper = UserDefinedJavaClassCodeSnippits.getSnippitsHelper();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Unexpected error", "There was an unexpected error reading the code snippets file", e);
        }
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        UserDefinedJavaClassDialog userDefinedJavaClassDialog = this;
        this.margin = userDefinedJavaClassDialog.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        Button wTest = new Button((Composite)this.shell, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.TestClass.Button", (String[])new String[0]));
        wTest.addListener(13, e -> this.test());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, wTest, this.wCancel}, this.margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -this.margin);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, this.margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        SashForm wSash = new SashForm((Composite)this.shell, 512);
        Composite wTop = new Composite((Composite)wSash, 0);
        PropsUi.setLook((Widget)wTop);
        FormLayout topLayout = new FormLayout();
        topLayout.marginWidth = PropsUi.getFormMargin();
        topLayout.marginHeight = PropsUi.getFormMargin();
        wTop.setLayout((Layout)topLayout);
        Label wlScriptFunctions = new Label(wTop, 0);
        wlScriptFunctions.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ClassesAndSnippits.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlScriptFunctions);
        FormData fdlScriptFunctions = new FormData();
        fdlScriptFunctions.left = new FormAttachment(0, 0);
        fdlScriptFunctions.top = new FormAttachment(0, 0);
        wlScriptFunctions.setLayoutData((Object)fdlScriptFunctions);
        this.wTree = new Tree(wTop, 2816);
        PropsUi.setLook((Widget)this.wTree);
        FormData fdlTree = new FormData();
        fdlTree.left = new FormAttachment(0, 0);
        fdlTree.top = new FormAttachment((Control)wlScriptFunctions, this.margin);
        fdlTree.right = new FormAttachment(20, 0);
        fdlTree.bottom = new FormAttachment(100, -this.margin);
        this.wTree.setLayoutData((Object)fdlTree);
        Label wlScript = new Label(wTop, 0);
        wlScript.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Class.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlScript);
        FormData fdlScript = new FormData();
        fdlScript.left = new FormAttachment((Control)this.wTree, this.margin);
        fdlScript.top = new FormAttachment(0, 0);
        wlScript.setLayoutData((Object)fdlScript);
        this.wlPosition = new Label(wTop, 0);
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Position.Label", (Object[])new Object[]{1, 1}));
        PropsUi.setLook((Widget)this.wlPosition);
        FormData fdlPosition = new FormData();
        fdlPosition.left = new FormAttachment((Control)this.wTree, this.margin);
        fdlPosition.right = new FormAttachment(30, 0);
        fdlPosition.bottom = new FormAttachment(100, 0);
        this.wlPosition.setLayoutData((Object)fdlPosition);
        this.folder = new CTabFolder(wTop, 2064);
        this.folder.setUnselectedImageVisible(true);
        this.folder.setUnselectedCloseVisible(true);
        FormData fdScript = new FormData();
        fdScript.left = new FormAttachment((Control)this.wTree, this.margin);
        fdScript.top = new FormAttachment((Control)wlScript, this.margin);
        fdScript.right = new FormAttachment(100, -5);
        fdScript.bottom = new FormAttachment((Control)this.wlPosition, -this.margin);
        this.folder.setLayoutData((Object)fdScript);
        Text wlHelpLabel = new Text(wTop, 16896);
        wlHelpLabel.setEditable(false);
        wlHelpLabel.setText("Help");
        PropsUi.setLook((Widget)wlHelpLabel);
        FormData fdHelpLabel = new FormData();
        fdHelpLabel.left = new FormAttachment((Control)this.wlPosition, this.margin);
        fdHelpLabel.top = new FormAttachment((Control)this.folder, this.margin);
        fdHelpLabel.right = new FormAttachment(100, -5);
        fdHelpLabel.bottom = new FormAttachment(100, 0);
        wlHelpLabel.setLayoutData((Object)fdHelpLabel);
        wlHelpLabel.setVisible(false);
        FormData fdTop = new FormData();
        fdTop.left = new FormAttachment(0, 0);
        fdTop.top = new FormAttachment(0, 0);
        fdTop.right = new FormAttachment(100, 0);
        fdTop.bottom = new FormAttachment(100, 0);
        wTop.setLayoutData((Object)fdTop);
        this.wTabFolder = new CTabFolder((Composite)wSash, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, (int)4);
        this.wTabFolder.setUnselectedCloseVisible(false);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.top = new FormAttachment(0, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * this.margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.addFieldsTab();
        this.addParametersTab();
        this.prevTransformNames = this.pipelineMeta.getPrevTransformNames(this.transformMeta);
        this.nextTransformNames = this.pipelineMeta.getNextTransformNames(this.transformMeta);
        this.addInfoTab();
        this.addTargetTab();
        this.wTabFolder.setSelection(this.fieldsTab);
        FormData fdSash = new FormData();
        fdSash.left = new FormAttachment(0, 0);
        fdSash.top = new FormAttachment((Control)this.wTransformName, 0);
        fdSash.right = new FormAttachment(100, 0);
        fdSash.bottom = new FormAttachment((Control)this.wOk, -2 * this.margin);
        wSash.setLayoutData((Object)fdSash);
        wSash.setWeights(new int[]{75, 25});
        this.wTree.addListener(8, this::treeDblClick);
        this.folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                CTabItem cItem = (CTabItem)event.item;
                event.doit = false;
                if (cItem != null && UserDefinedJavaClassDialog.this.folder.getItemCount() > 1) {
                    MessageBox messageBox = new MessageBox(UserDefinedJavaClassDialog.this.shell, 196);
                    messageBox.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.DeleteItem.Label", (String[])new String[0]));
                    messageBox.setMessage(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ConfirmDeleteItem.Label", (String[])new String[]{cItem.getText()}));
                    switch (messageBox.open()) {
                        case 64: {
                            UserDefinedJavaClassDialog.this.modifyTabTree(cItem, TabActions.DELETE_ITEM);
                            event.doit = true;
                            break;
                        }
                    }
                }
            }
        });
        this.cMenu = new Menu((Decorations)this.shell, 8);
        this.buildingFolderMenu();
        this.tMenu = new Menu((Decorations)this.shell, 8);
        this.buildingTreeMenu();
        this.wTreeClassesItem = new TreeItem(this.wTree, 0);
        this.wTreeClassesItem.setImage(guiResource.getImageFolder());
        this.wTreeClassesItem.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Classes.Label", (String[])new String[0]));
        this.getData();
        this.buildSnippitsTree();
        this.itemInput = new TreeItem(this.wTree, 0);
        this.itemInput.setImage(guiResource.getImageInput());
        this.itemInput.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.InputFields.Label", (String[])new String[0]));
        this.itemInput.setData((Object)"Field Helpers");
        this.itemInfo = new TreeItem(this.wTree, 0);
        this.itemInfo.setImage(guiResource.getImageInput());
        this.itemInfo.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.InfoFields.Label", (String[])new String[0]));
        this.itemInfo.setData((Object)"Field Helpers");
        this.itemOutput = new TreeItem(this.wTree, 0);
        this.itemOutput.setImage(guiResource.getImageOutput());
        this.itemOutput.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.OutputFields.Label", (String[])new String[0]));
        this.itemOutput.setData((Object)"Field Helpers");
        TreeItem itemWaitFieldsIn = new TreeItem(this.itemInput, 0);
        itemWaitFieldsIn.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.GettingFields.Label", (String[])new String[0]));
        itemWaitFieldsIn.setForeground(guiResource.getColorDirectory());
        this.itemInput.setExpanded(true);
        TreeItem itemWaitFieldsInfo = new TreeItem(this.itemInfo, 0);
        itemWaitFieldsInfo.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.GettingFields.Label", (String[])new String[0]));
        itemWaitFieldsInfo.setForeground(guiResource.getColorDirectory());
        this.itemInfo.setExpanded(true);
        TreeItem itemWaitFieldsOut = new TreeItem(this.itemOutput, 0);
        itemWaitFieldsOut.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.GettingFields.Label", (String[])new String[0]));
        itemWaitFieldsOut.setForeground(guiResource.getColorDirectory());
        this.itemOutput.setExpanded(true);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    this.inputRowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    this.infoRowMeta = this.pipelineMeta.getPrevInfoFields(this.variables, transformMeta);
                    this.outputRowMeta = this.pipelineMeta.getThisTransformFields(this.variables, transformMeta, null, this.inputRowMeta.clone());
                    this.populateFieldsTree();
                }
                catch (HopException e) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Throwable)e);
                }
            }
        };
        new Thread(runnable).start();
        this.addRenameToTreeScriptItems();
        this.input.setChanged(this.changed);
        DragSource ds = new DragSource((Control)this.wTree, 2);
        ds.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        ds.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                boolean doit = false;
                TreeItem item = UserDefinedJavaClassDialog.this.wTree.getSelection()[0];
                if (item != null && item.getParentItem() != null) {
                    if ("Snippits Category".equals(item.getParentItem().getData()) && !"Snippits Category".equals(item.getData())) {
                        doit = true;
                    } else if ("Field Helpers".equals(item.getParentItem().getData())) {
                        doit = true;
                    } else if (item.getParentItem().getParentItem() != null && "Field Helpers".equals(item.getParentItem().getParentItem().getData())) {
                        doit = true;
                    }
                }
                event.doit = doit;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = UserDefinedJavaClassDialog.this.wTree.getSelection()[0].getData();
            }
        });
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected boolean createPlugin() {
        UserDefinedJavaClassMeta udjcMeta = new UserDefinedJavaClassMeta();
        this.getInfo(udjcMeta);
        try {
            String pluginName = "Processor";
            for (UserDefinedJavaClassDef def : udjcMeta.getDefinitions()) {
                if (!def.isTransformClass()) continue;
                pluginName = def.getClassName();
            }
            File pluginFile = new File(String.format("plugins/transforms/%s/%s.transform.xml", pluginName, pluginName));
            pluginFile.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(new FileWriter(pluginFile));
            StringBuilder outXML = new StringBuilder("<transform>\n");
            outXML.append(String.format("\t<name>%s</name>\n", this.transformName));
            outXML.append("\t<type>UserDefinedJavaClass</type>\n");
            outXML.append("\t<description/>\n\t");
            outXML.append(udjcMeta.getXml());
            outXML.append("</transform>");
            pw.println(outXML.toString());
            pw.flush();
            pw.close();
            ShowMessageDialog msgDialog = new ShowMessageDialog(this.shell, 34, BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Plugin.CreateSuccess", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Plugin.CreatedFile", (String[])new String[]{pluginFile.getPath()}), false);
            msgDialog.open();
        }
        catch (IOException e) {
            e.printStackTrace();
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Plugin.CreateErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Plugin.CreateErrorMessage", (String[])new String[]{this.transformName}), (Exception)e);
        }
        return true;
    }

    private void addFieldsTab() {
        this.fieldsTab = new CTabItem(this.wTabFolder, 0);
        this.fieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        this.fieldsTab.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Tabs.Fields.Title", (String[])new String[0]));
        this.fieldsTab.setToolTipText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Tabs.Fields.TooltipText", (String[])new String[0]));
        Composite wBottom = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wBottom);
        this.fieldsTab.setControl((Control)wBottom);
        FormLayout bottomLayout = new FormLayout();
        bottomLayout.marginWidth = PropsUi.getFormMargin();
        bottomLayout.marginHeight = PropsUi.getFormMargin();
        wBottom.setLayout((Layout)bottomLayout);
        Label wlFields = new Label(wBottom, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(0, 0);
        wlFields.setLayoutData((Object)fdlFields);
        this.wClearResultFields = new Button(wBottom, 32);
        this.wClearResultFields.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ClearResultFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wClearResultFields);
        FormData fdClearResultFields = new FormData();
        fdClearResultFields.right = new FormAttachment(100, 0);
        fdClearResultFields.top = new FormAttachment(0, 0);
        this.wClearResultFields.setLayoutData((Object)fdClearResultFields);
        int fieldsRows = this.input.getFieldInfo().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ColumnInfo.Filename", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false)};
        this.wFields = new TableView(this.variables, wBottom, 67586, colinf, fieldsRows, this.lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, 0);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdBottom = new FormData();
        fdBottom.left = new FormAttachment(0, 0);
        fdBottom.top = new FormAttachment(0, 0);
        fdBottom.right = new FormAttachment(100, 0);
        fdBottom.bottom = new FormAttachment(100, 0);
        wBottom.setLayoutData((Object)fdBottom);
    }

    private void addInfoTab() {
        CTabItem infoTab = new CTabItem(this.wTabFolder, 0);
        infoTab.setFont(GuiResource.getInstance().getFontDefault());
        infoTab.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Tabs.Info.Title", (String[])new String[0]));
        infoTab.setToolTipText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Tabs.Info.TooltipText", (String[])new String[0]));
        Composite wBottom = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wBottom);
        infoTab.setControl((Control)wBottom);
        FormLayout bottomLayout = new FormLayout();
        bottomLayout.marginWidth = PropsUi.getFormMargin();
        bottomLayout.marginHeight = PropsUi.getFormMargin();
        wBottom.setLayout((Layout)bottomLayout);
        Label wlFields = new Label(wBottom, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.InfoTransforms.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(0, 0);
        wlFields.setLayoutData((Object)fdlFields);
        int nrRows = this.input.getInfoTransformDefinitions().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ColumnInfo.TransformTag", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ColumnInfo.TransformName", (String[])new String[0]), 2, this.prevTransformNames), new ColumnInfo(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ColumnInfo.TransformDescription", (String[])new String[0]), 1, false)};
        this.wInfoTransforms = new TableView(this.variables, wBottom, 67586, colinf, nrRows, this.lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, 0);
        this.wInfoTransforms.setLayoutData((Object)fdFields);
        FormData fdBottom = new FormData();
        fdBottom.left = new FormAttachment(0, 0);
        fdBottom.top = new FormAttachment(0, 0);
        fdBottom.right = new FormAttachment(100, 0);
        fdBottom.bottom = new FormAttachment(100, 0);
        wBottom.setLayoutData((Object)fdBottom);
    }

    private void addTargetTab() {
        CTabItem targetTab = new CTabItem(this.wTabFolder, 0);
        targetTab.setFont(GuiResource.getInstance().getFontDefault());
        targetTab.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Tabs.Target.Title", (String[])new String[0]));
        targetTab.setToolTipText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Tabs.Target.TooltipText", (String[])new String[0]));
        Composite wBottom = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wBottom);
        targetTab.setControl((Control)wBottom);
        FormLayout bottomLayout = new FormLayout();
        bottomLayout.marginWidth = PropsUi.getFormMargin();
        bottomLayout.marginHeight = PropsUi.getFormMargin();
        wBottom.setLayout((Layout)bottomLayout);
        Label wlFields = new Label(wBottom, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.TargetTransforms.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(0, 0);
        wlFields.setLayoutData((Object)fdlFields);
        int nrRows = this.input.getTargetTransformDefinitions().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ColumnInfo.TransformTag", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ColumnInfo.TransformName", (String[])new String[0]), 2, this.nextTransformNames), new ColumnInfo(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ColumnInfo.TransformDescription", (String[])new String[0]), 1, false)};
        this.wTargetTransforms = new TableView(this.variables, wBottom, 67586, colinf, nrRows, this.lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, 0);
        this.wTargetTransforms.setLayoutData((Object)fdFields);
        FormData fdBottom = new FormData();
        fdBottom.left = new FormAttachment(0, 0);
        fdBottom.top = new FormAttachment(0, 0);
        fdBottom.right = new FormAttachment(100, 0);
        fdBottom.bottom = new FormAttachment(100, 0);
        wBottom.setLayoutData((Object)fdBottom);
    }

    private void addParametersTab() {
        CTabItem parametersTab = new CTabItem(this.wTabFolder, 0);
        parametersTab.setFont(GuiResource.getInstance().getFontDefault());
        parametersTab.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Tabs.Parameters.Title", (String[])new String[0]));
        parametersTab.setToolTipText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Tabs.Parameters.TooltipText", (String[])new String[0]));
        Composite wBottom = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wBottom);
        parametersTab.setControl((Control)wBottom);
        FormLayout bottomLayout = new FormLayout();
        bottomLayout.marginWidth = PropsUi.getFormMargin();
        bottomLayout.marginHeight = PropsUi.getFormMargin();
        wBottom.setLayout((Layout)bottomLayout);
        Label wlFields = new Label(wBottom, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Parameters.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(0, 0);
        wlFields.setLayoutData((Object)fdlFields);
        int nrRows = this.input.getUsageParameters().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ColumnInfo.ParameterTag", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ColumnInfo.ParameterValue", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ColumnInfo.ParameterDescription", (String[])new String[0]), 1, false)};
        colinf[1].setUsingVariables(true);
        this.wParameters = new TableView(this.variables, wBottom, 67586, colinf, nrRows, this.lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, 0);
        this.wParameters.setLayoutData((Object)fdFields);
        FormData fdBottom = new FormData();
        fdBottom.left = new FormAttachment(0, 0);
        fdBottom.top = new FormAttachment(0, 0);
        fdBottom.right = new FormAttachment(100, 0);
        fdBottom.bottom = new FormAttachment(100, 0);
        wBottom.setLayoutData((Object)fdBottom);
    }

    private void setActiveCtab(String strName) {
        if (strName.length() == 0) {
            this.folder.setSelection(0);
        } else {
            this.folder.setSelection(this.getCTabPosition(strName));
        }
    }

    private void addCtab(String tabName, String tabCode, TabAddActions tabType) {
        CTabItem item = new CTabItem(this.folder, 64);
        item.setFont(GuiResource.getInstance().getFontDefault());
        switch (tabType) {
            case ADD_DEFAULT: {
                item.setText(tabName);
                break;
            }
            default: {
                item.setText(this.getNextName(tabName));
            }
        }
        StyledTextComp wScript = new StyledTextComp(this.variables, (Composite)item.getParent(), 17154, false);
        if (tabCode != null && tabCode.length() > 0) {
            wScript.setText(tabCode);
        } else {
            wScript.setText(this.snippitsHelper.getDefaultCode());
        }
        PropsUi.setLook((Widget)wScript, (int)1);
        Listener listener = e -> this.setPosition(wScript);
        wScript.addListener(24, listener);
        wScript.addListener(1, listener);
        wScript.addListener(2, listener);
        wScript.addListener(15, listener);
        wScript.addListener(16, listener);
        wScript.addListener(8, listener);
        wScript.addListener(4, listener);
        wScript.addListener(3, listener);
        wScript.addModifyListener(this.lsMod);
        item.setImage(this.imageInactiveScript);
        item.setControl((Control)wScript);
        this.modifyTabTree(item, TabActions.ADD_ITEM);
    }

    private void modifyTabTree(CTabItem ctabitem, TabActions action) {
        switch (action) {
            case DELETE_ITEM: {
                TreeItem dItem = this.getTreeItemByName(ctabitem.getText());
                if (dItem == null) break;
                dItem.dispose();
                this.input.setChanged();
                break;
            }
            case ADD_ITEM: {
                TreeItem item = new TreeItem(this.wTreeClassesItem, 0);
                item.setImage(this.imageActiveScript);
                item.setText(ctabitem.getText());
                this.input.setChanged();
                break;
            }
            case RENAME_ITEM: {
                this.input.setChanged();
                break;
            }
            case SET_ACTIVE_ITEM: {
                this.input.setChanged();
                break;
            }
        }
    }

    private TreeItem getTreeItemByName(String strTabName) {
        TreeItem[] tItems = this.wTreeClassesItem.getItems();
        for (int i = 0; i < tItems.length; ++i) {
            if (!tItems[i].getText().equals(strTabName)) continue;
            return tItems[i];
        }
        return null;
    }

    private int getCTabPosition(String strTabName) {
        CTabItem[] cItems = this.folder.getItems();
        for (int i = 0; i < cItems.length; ++i) {
            if (!cItems[i].getText().equals(strTabName)) continue;
            return i;
        }
        return -1;
    }

    private CTabItem getCTabItemByName(String strTabName) {
        CTabItem[] cItems = this.folder.getItems();
        for (int i = 0; i < cItems.length; ++i) {
            if (!cItems[i].getText().equals(strTabName)) continue;
            return cItems[i];
        }
        return null;
    }

    private void modifyCTabItem(TreeItem tItem, TabActions iModType, String strOption) {
        switch (iModType) {
            case DELETE_ITEM: {
                CTabItem dItem = this.folder.getItem(this.getCTabPosition(tItem.getText()));
                if (dItem == null) break;
                dItem.dispose();
                this.input.setChanged();
                break;
            }
            case RENAME_ITEM: {
                CTabItem rItem = this.folder.getItem(this.getCTabPosition(tItem.getText()));
                if (rItem == null) break;
                rItem.setText(strOption);
                this.input.setChanged();
                if (!rItem.getImage().equals((Object)this.imageActiveScript)) break;
                this.strActiveScript = strOption;
                break;
            }
            case SET_ACTIVE_ITEM: {
                CTabItem aItem = this.folder.getItem(this.getCTabPosition(tItem.getText()));
                if (aItem == null) break;
                this.input.setChanged();
                this.strActiveScript = tItem.getText();
                for (int i = 0; i < this.folder.getItemCount(); ++i) {
                    if (this.folder.getItem(i).equals(aItem)) {
                        aItem.setImage(this.imageActiveScript);
                        continue;
                    }
                    this.folder.getItem(i).setImage(this.imageInactiveScript);
                }
                break;
            }
        }
    }

    private StyledTextComp getStyledTextComp() {
        CTabItem item = this.folder.getSelection();
        if (item.getControl().isDisposed()) {
            return null;
        }
        return (StyledTextComp)item.getControl();
    }

    private StyledTextComp getStyledTextComp(CTabItem item) {
        return (StyledTextComp)item.getControl();
    }

    private String getNextName(String strActualName) {
        Object strRC = "";
        if (strActualName.length() == 0) {
            strActualName = "ExtraClass";
        }
        int i = 0;
        strRC = strActualName + "_" + i;
        while (this.getCTabItemByName((String)strRC) != null) {
            strRC = strActualName + "_" + ++i;
        }
        return strRC;
    }

    public void setPosition(StyledTextComp widget) {
        int lineNumber = widget.getLineNumber();
        int columnNumber = widget.getColumnNumber();
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Position.Label", (Object[])new Object[]{lineNumber, columnNumber}));
    }

    public void getData() {
        int colNr;
        TableItem item;
        int i = 0;
        for (UserDefinedJavaClassMeta.FieldInfo fi : this.input.getFieldInfo()) {
            TableItem item2 = this.wFields.table.getItem(i);
            ++i;
            item2.setText(1, fi.name);
            item2.setText(2, ValueMetaFactory.getValueMetaName((int)fi.type));
            if (fi.length >= 0) {
                item2.setText(3, "" + fi.length);
            }
            if (fi.precision < 0) continue;
            item2.setText(4, "" + fi.precision);
        }
        List<UserDefinedJavaClassDef> definitions = this.input.getDefinitions();
        if (definitions.size() == 0) {
            try {
                definitions = new ArrayList<UserDefinedJavaClassDef>();
                definitions.add(new UserDefinedJavaClassDef(UserDefinedJavaClassDef.ClassType.TRANSFORM_CLASS, "Processor", UserDefinedJavaClassCodeSnippits.getSnippitsHelper().getDefaultCode()));
                this.input.replaceDefinitions(definitions);
            }
            catch (HopXmlException e) {
                e.printStackTrace();
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Plugin.CreateErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Plugin.CreateErrorMessage", (String[])new String[]{this.transformName}), (Exception)((Object)e));
            }
        }
        for (UserDefinedJavaClassDef def : definitions) {
            if (def.isTransformClass()) {
                this.strActiveScript = def.getClassName();
            }
            this.addCtab(def.getClassName(), def.getSource(), TabAddActions.ADD_DEFAULT);
        }
        this.setActiveCtab(this.strActiveScript);
        this.refresh();
        this.wClearResultFields.setSelection(this.input.isClearingResultFields());
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        int rowNr = 0;
        for (InfoTransformDefinition infoTransformDefinition : this.input.getInfoTransformDefinitions()) {
            item = this.wInfoTransforms.table.getItem(rowNr++);
            colNr = 1;
            item.setText(colNr++, Const.NVL((String)infoTransformDefinition.tag, (String)""));
            item.setText(colNr++, infoTransformDefinition.transformMeta != null ? infoTransformDefinition.transformMeta.getName() : "");
            item.setText(colNr++, Const.NVL((String)infoTransformDefinition.description, (String)""));
        }
        this.wInfoTransforms.setRowNums();
        this.wInfoTransforms.optWidth(true);
        rowNr = 0;
        for (TargetTransformDefinition targetTransformDefinition : this.input.getTargetTransformDefinitions()) {
            item = this.wTargetTransforms.table.getItem(rowNr++);
            colNr = 1;
            item.setText(colNr++, Const.NVL((String)targetTransformDefinition.tag, (String)""));
            item.setText(colNr++, targetTransformDefinition.transformMeta != null ? targetTransformDefinition.transformMeta.getName() : "");
            item.setText(colNr++, Const.NVL((String)targetTransformDefinition.description, (String)""));
        }
        this.wTargetTransforms.setRowNums();
        this.wTargetTransforms.optWidth(true);
        rowNr = 0;
        for (UsageParameter usageParameter : this.input.getUsageParameters()) {
            item = this.wParameters.table.getItem(rowNr++);
            colNr = 1;
            item.setText(colNr++, Const.NVL((String)usageParameter.tag, (String)""));
            item.setText(colNr++, Const.NVL((String)usageParameter.value, (String)""));
            item.setText(colNr++, Const.NVL((String)usageParameter.description, (String)""));
        }
        this.wParameters.setRowNums();
        this.wParameters.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void refresh() {
        for (int i = 0; i < this.folder.getItemCount(); ++i) {
            CTabItem item = this.folder.getItem(i);
            if (item.getText().equals(this.strActiveScript)) {
                item.setImage(this.imageActiveScript);
                continue;
            }
            item.setImage(this.imageInactiveScript);
        }
    }

    private boolean cancel() {
        if (this.input.hasChanged()) {
            MessageBox box = new MessageBox(this.shell, 65728);
            box.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.WarningDialogChanged.Title", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.WarningDialogChanged.Message", (String[])new String[]{Const.CR}));
            int answer = box.open();
            if (answer == 128) {
                return false;
            }
        }
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
        return true;
    }

    private void getInfo(UserDefinedJavaClassMeta meta) {
        int i;
        int nrFields = this.wFields.nrNonEmpty();
        ArrayList<UserDefinedJavaClassMeta.FieldInfo> newFields = new ArrayList<UserDefinedJavaClassMeta.FieldInfo>(nrFields);
        for (int i2 = 0; i2 < nrFields; ++i2) {
            TableItem item = this.wFields.getNonEmpty(i2);
            newFields.add(new UserDefinedJavaClassMeta.FieldInfo(item.getText(1), ValueMetaFactory.getIdForValueMeta((String)item.getText(2)), Const.toInt((String)item.getText(3), (int)-1), Const.toInt((String)item.getText(4), (int)-1)));
        }
        meta.replaceFields(newFields);
        CTabItem[] cTabs = this.folder.getItems();
        if (cTabs.length > 0) {
            ArrayList<UserDefinedJavaClassDef> definitions = new ArrayList<UserDefinedJavaClassDef>(cTabs.length);
            for (i = 0; i < cTabs.length; ++i) {
                UserDefinedJavaClassDef def = new UserDefinedJavaClassDef(UserDefinedJavaClassDef.ClassType.NORMAL_CLASS, cTabs[i].getText(), this.getStyledTextComp(cTabs[i]).getText());
                if (cTabs[i].getImage().equals((Object)this.imageActiveScript)) {
                    def.setClassType(UserDefinedJavaClassDef.ClassType.TRANSFORM_CLASS);
                }
                definitions.add(def);
            }
            meta.replaceDefinitions(definitions);
        }
        meta.setClearingResultFields(this.wClearResultFields.getSelection());
        int nrInfos = this.wInfoTransforms.nrNonEmpty();
        meta.getInfoTransformDefinitions().clear();
        for (i = 0; i < nrInfos; ++i) {
            TableItem item = this.wInfoTransforms.getNonEmpty(i);
            InfoTransformDefinition transformDefinition = new InfoTransformDefinition();
            int colNr = 1;
            transformDefinition.tag = item.getText(colNr++);
            transformDefinition.transformName = item.getText(colNr++);
            transformDefinition.transformMeta = this.pipelineMeta.findTransform(transformDefinition.transformName);
            transformDefinition.description = item.getText(colNr++);
            meta.getInfoTransformDefinitions().add(transformDefinition);
        }
        int nrTargets = this.wTargetTransforms.nrNonEmpty();
        meta.getTargetTransformDefinitions().clear();
        for (int i3 = 0; i3 < nrTargets; ++i3) {
            TableItem item = this.wTargetTransforms.getNonEmpty(i3);
            TargetTransformDefinition transformDefinition = new TargetTransformDefinition();
            int colNr = 1;
            transformDefinition.tag = item.getText(colNr++);
            transformDefinition.transformName = item.getText(colNr++);
            transformDefinition.transformMeta = this.pipelineMeta.findTransform(transformDefinition.transformName);
            transformDefinition.description = item.getText(colNr++);
            meta.getTargetTransformDefinitions().add(transformDefinition);
        }
        int nrParameters = this.wParameters.nrNonEmpty();
        meta.getUsageParameters().clear();
        for (int i4 = 0; i4 < nrParameters; ++i4) {
            TableItem item = this.wParameters.getNonEmpty(i4);
            UsageParameter usageParameter = new UsageParameter();
            int colNr = 1;
            usageParameter.tag = item.getText(colNr++);
            usageParameter.value = item.getText(colNr++);
            usageParameter.description = item.getText(colNr++);
            meta.getUsageParameters().add(usageParameter);
        }
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        boolean bInputOK = false;
        bInputOK = this.checkForTransformClass();
        if (bInputOK) {
            this.getInfo(this.input);
            this.dispose();
        }
    }

    private boolean checkForTransformClass() {
        boolean hasTransformClass = true;
        if (this.getCTabItemByName(this.strActiveScript) == null) {
            MessageBox mb = new MessageBox(this.shell, 289);
            mb.setMessage(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.NoTransformClassSet", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ERROR.Label", (String[])new String[0]));
            switch (mb.open()) {
                case 32: {
                    this.strActiveScript = this.folder.getItem(0).getText();
                    this.refresh();
                    hasTransformClass = true;
                    break;
                }
                case 256: {
                    hasTransformClass = false;
                    break;
                }
            }
        }
        return hasTransformClass;
    }

    private boolean test() {
        PluginRegistry registry = PluginRegistry.getInstance();
        String scriptTransformName = this.wTransformName.getText();
        if (!this.checkForTransformClass()) {
            return false;
        }
        UserDefinedJavaClassMeta udjcMeta = new UserDefinedJavaClassMeta();
        this.getInfo(udjcMeta);
        try {
            udjcMeta.cookClasses();
            if (udjcMeta.cookErrors.size() == 1) {
                Exception e = udjcMeta.cookErrors.get(0);
                new ErrorDialog(this.shell, "Error during class compilation", e.toString(), e);
                return false;
            }
            if (udjcMeta.cookErrors.size() > 1) {
                Exception e = udjcMeta.cookErrors.get(0);
                new ErrorDialog(this.shell, "Errors during class compilation", String.format("Multiple errors during class compilation. First error:\n%s", e.toString()), e);
                return false;
            }
            IRowMeta rowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName).clone();
            if (rowMeta != null) {
                if (this.genMeta == null) {
                    this.genMeta = new RowGeneratorMeta();
                    this.genMeta.setRowLimit("10");
                    for (int i = 0; i < rowMeta.size(); ++i) {
                        IValueMeta valueMeta = rowMeta.getValueMeta(i);
                        if (valueMeta.isStorageBinaryString()) {
                            valueMeta.setStorageType(0);
                        }
                        GeneratorField field = new GeneratorField();
                        field.setName(valueMeta.getName());
                        field.setType(valueMeta.getTypeDesc());
                        field.setLength(valueMeta.getLength());
                        field.setPrecision(valueMeta.getPrecision());
                        field.setCurrency(valueMeta.getCurrencySymbol());
                        field.setDecimal(valueMeta.getDecimalSymbol());
                        field.setGroup(valueMeta.getGroupingSymbol());
                        String string = null;
                        switch (valueMeta.getType()) {
                            case 3: {
                                field.setFormat("yyyy/MM/dd HH:mm:ss");
                                valueMeta.setConversionMask(field.getFormat());
                                string = valueMeta.getString((Object)new Date());
                                break;
                            }
                            case 2: {
                                string = "test value test value";
                                break;
                            }
                            case 5: {
                                field.setFormat("#");
                                valueMeta.setConversionMask(field.getFormat());
                                string = valueMeta.getString((Object)0L);
                                break;
                            }
                            case 1: {
                                field.setFormat("#.#");
                                valueMeta.setConversionMask(field.getFormat());
                                string = valueMeta.getString((Object)0.0);
                                break;
                            }
                            case 6: {
                                field.setFormat("#.#");
                                valueMeta.setConversionMask(field.getFormat());
                                string = valueMeta.getString((Object)BigDecimal.ZERO);
                                break;
                            }
                            case 4: {
                                string = valueMeta.getString((Object)Boolean.TRUE);
                                break;
                            }
                            case 8: {
                                string = valueMeta.getString((Object)new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74});
                                break;
                            }
                        }
                        field.setValue(string);
                        this.genMeta.getFields().add(field);
                    }
                }
                TransformMeta genTransform = new TransformMeta(registry.getPluginId(TransformPluginType.class, (Object)this.genMeta), "## TEST DATA ##", (ITransformMeta)this.genMeta);
                genTransform.setLocation(50, 50);
                TransformMeta scriptTransform = new TransformMeta(registry.getPluginId(TransformPluginType.class, (Object)udjcMeta), Const.NVL((String)scriptTransformName, (String)"## SCRIPT ##"), (ITransformMeta)udjcMeta);
                scriptTransformName = scriptTransform.getName();
                scriptTransform.setLocation(150, 50);
                PipelineHopMeta hop = new PipelineHopMeta(genTransform, scriptTransform);
                PipelineMeta pipelineMeta = new PipelineMeta();
                pipelineMeta.setName(this.wTransformName.getText() + " - PREVIEW");
                pipelineMeta.addTransform(genTransform);
                pipelineMeta.addTransform(scriptTransform);
                pipelineMeta.addPipelineHop(hop);
                PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, pipelineMeta, new String[]{scriptTransformName}, new int[]{Const.toInt((String)this.genMeta.getRowLimit(), (int)10)});
                progressDialog.open();
                Pipeline pipeline = progressDialog.getPipeline();
                String loggingText = progressDialog.getLoggingText();
                if (!progressDialog.isCancelled() && pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString((String)"System.Dialog.PreviewError.Title"), BaseMessages.getString((String)"System.Dialog.PreviewError.Message"), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                }
                IRowMeta previewRowsMeta = progressDialog.getPreviewRowsMeta(this.wTransformName.getText());
                List previewRows = progressDialog.getPreviewRows(this.wTransformName.getText());
                if (previewRowsMeta != null && previewRows != null && previewRows.size() > 0) {
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), previewRowsMeta, previewRows, loggingText);
                    prd.open();
                }
                return true;
            }
            throw new HopException(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Exception.CouldNotGetFields", (String[])new String[0]));
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.TestFailed.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.TestFailed.DialogMessage", (String[])new String[0]), e);
            return false;
        }
    }

    private void buildSnippitsTree() {
        TreeItem item = new TreeItem(this.wTree, 0);
        item.setImage(guiResource.getImageFolder());
        item.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Snippits.Label", (String[])new String[0]));
        EnumMap<UserDefinedJavaClassCodeSnippits.Category, TreeItem> categoryTreeItems = new EnumMap<UserDefinedJavaClassCodeSnippits.Category, TreeItem>(UserDefinedJavaClassCodeSnippits.Category.class);
        for (UserDefinedJavaClassCodeSnippits.Category cat : UserDefinedJavaClassCodeSnippits.Category.values()) {
            TreeItem itemGroup = new TreeItem(item, 0);
            itemGroup.setImage(guiResource.getImageFolder());
            itemGroup.setText(cat.getDescription());
            itemGroup.setData((Object)"Snippits Category");
            categoryTreeItems.put(cat, itemGroup);
        }
        List<UserDefinedJavaClassCodeSnippits.Snippit> snippits = this.snippitsHelper.getSnippits();
        for (UserDefinedJavaClassCodeSnippits.Snippit snippit : snippits) {
            TreeItem itemGroup = (TreeItem)categoryTreeItems.get((Object)snippit.category);
            TreeItem itemSnippit = new TreeItem(itemGroup, 0);
            itemSnippit.setText(snippit.name);
            itemSnippit.setImage(GuiResource.getInstance().getImageLabel());
            itemSnippit.setData((Object)snippit.code);
        }
    }

    public boolean TreeItemExist(TreeItem itemToCheck, String strItemName) {
        boolean bRC = false;
        if (itemToCheck.getItemCount() > 0) {
            TreeItem[] items = itemToCheck.getItems();
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].getText().equals(strItemName)) continue;
                return true;
            }
        }
        return bRC;
    }

    private void populateFieldsTree() {
        this.shell.getDisplay().syncExec(() -> {
            TreeItem itemFieldSet;
            TreeItem itemFieldGet;
            TreeItem itemField;
            String itemData;
            String itemName;
            IValueMeta v;
            int i;
            this.itemInput.removeAll();
            this.itemInfo.removeAll();
            this.itemOutput.removeAll();
            if (this.inputRowMeta != null) {
                for (i = 0; i < this.inputRowMeta.size(); ++i) {
                    v = this.inputRowMeta.getValueMeta(i);
                    itemName = v.getName();
                    itemData = FieldHelper.getAccessor(true, itemName);
                    itemField = new TreeItem(this.itemInput, 0);
                    itemField.setImage(guiResource.getImage(v));
                    itemField.setText(itemName);
                    itemField.setData((Object)itemData);
                    itemFieldGet = new TreeItem(itemField, 0);
                    itemFieldGet.setText(String.format("get%s()", FieldHelper.getNativeDataTypeSimpleName(v)));
                    itemFieldGet.setData((Object)FieldHelper.getGetSignature(itemData, v));
                    itemFieldSet = new TreeItem(itemField, 0);
                    itemFieldSet.setText("setValue()");
                    itemFieldSet.setData((Object)(itemData + ".setValue(r, value);"));
                }
            }
            if (this.infoRowMeta != null) {
                for (i = 0; i < this.infoRowMeta.size(); ++i) {
                    v = this.infoRowMeta.getValueMeta(i);
                    itemName = v.getName();
                    itemData = FieldHelper.getAccessor(true, itemName);
                    itemField = new TreeItem(this.itemInfo, 0);
                    itemField.setImage(guiResource.getImage(v));
                    itemField.setText(itemName);
                    itemField.setData((Object)itemData);
                    itemFieldGet = new TreeItem(itemField, 0);
                    itemFieldGet.setText(String.format("get%s()", FieldHelper.getNativeDataTypeSimpleName(v)));
                    itemFieldGet.setData((Object)FieldHelper.getGetSignature(itemData, v));
                    itemFieldSet = new TreeItem(itemField, 0);
                    itemFieldSet.setText("setValue()");
                    itemFieldSet.setData((Object)(itemData + ".setValue(r, value);"));
                }
            }
            if (this.outputRowMeta != null) {
                for (i = 0; i < this.outputRowMeta.size(); ++i) {
                    v = this.outputRowMeta.getValueMeta(i);
                    itemName = v.getName();
                    itemData = FieldHelper.getAccessor(false, itemName);
                    itemField = new TreeItem(this.itemOutput, 0);
                    itemField.setImage(guiResource.getImage(v));
                    itemField.setText(itemName);
                    itemField.setData((Object)itemData);
                    itemFieldGet = new TreeItem(itemField, 0);
                    itemFieldGet.setText(String.format("get%s()", FieldHelper.getNativeDataTypeSimpleName(v)));
                    itemFieldGet.setData((Object)FieldHelper.getGetSignature(itemData, v));
                    itemFieldSet = new TreeItem(itemField, 0);
                    itemFieldSet.setText("setValue()");
                    itemFieldSet.setData((Object)(itemData + ".setValue(r, value);"));
                }
            }
        });
    }

    private void treeDblClick(Event event) {
        StyledTextComp wScript = this.getStyledTextComp();
        Point point = new Point(event.x, event.y);
        TreeItem item = this.wTree.getItem(point);
        if (item != null && item.getParentItem() != null) {
            if (item.getParentItem().equals(this.wTreeClassesItem)) {
                this.setActiveCtab(item.getText());
            } else if (!item.getData().equals("Snippit")) {
                int iStart = wScript.getTextWidget().getCaretPosition();
                int selCount = wScript.getSelectionCount();
                if ((iStart -= selCount) < 0) {
                    iStart = 0;
                }
                String strInsert = (String)item.getData();
                wScript.insert(strInsert);
                wScript.setSelection(iStart, iStart + strInsert.length());
            }
        }
    }

    private void buildingFolderMenu() {
        MenuItem addNewItem = new MenuItem(this.cMenu, 8);
        addNewItem.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.AddNewTab", (String[])new String[0]));
        addNewItem.addListener(13, e -> this.addCtab("", "", TabAddActions.ADD_BLANK));
        MenuItem copyItem = new MenuItem(this.cMenu, 8);
        copyItem.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.AddCopy", (String[])new String[0]));
        copyItem.addListener(13, e -> {
            CTabItem item = this.folder.getSelection();
            StyledTextComp st = (StyledTextComp)item.getControl();
            this.addCtab(item.getText(), st.getText(), TabAddActions.ADD_COPY);
        });
        new MenuItem(this.cMenu, 2);
        MenuItem setActiveScriptItem = new MenuItem(this.cMenu, 8);
        setActiveScriptItem.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.SetTransformClass", (String[])new String[0]));
        setActiveScriptItem.addListener(13, e -> {
            CTabItem item = this.folder.getSelection();
            for (int i = 0; i < this.folder.getItemCount(); ++i) {
                if (this.folder.getItem(i).equals(item)) {
                    if (item.getImage().equals((Object)this.imageActiveScript)) {
                        this.strActiveScript = "";
                    }
                    item.setImage(this.imageActiveScript);
                    this.strActiveScript = item.getText();
                    continue;
                }
                if (!this.folder.getItem(i).getImage().equals((Object)this.imageActiveScript)) continue;
                this.folder.getItem(i).setImage(this.imageInactiveScript);
            }
            this.modifyTabTree(item, TabActions.SET_ACTIVE_ITEM);
        });
        new MenuItem(this.cMenu, 2);
        MenuItem setRemoveScriptItem = new MenuItem(this.cMenu, 8);
        setRemoveScriptItem.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.RemoveClassType", (String[])new String[0]));
        setRemoveScriptItem.addListener(13, e -> {
            CTabItem item = this.folder.getSelection();
            this.input.setChanged(true);
            if (item.getImage().equals((Object)this.imageActiveScript)) {
                this.strActiveScript = "";
            }
            item.setImage(this.imageInactiveScript);
        });
        this.folder.setMenu(this.cMenu);
    }

    private void buildingTreeMenu() {
        MenuItem addDeleteItem = new MenuItem(this.tMenu, 8);
        addDeleteItem.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Delete.Label", (String[])new String[0]));
        addDeleteItem.addListener(13, e -> {
            if (this.wTree.getSelectionCount() <= 0) {
                return;
            }
            TreeItem tItem = this.wTree.getSelection()[0];
            if (tItem != null) {
                MessageBox messageBox = new MessageBox(this.shell, 196);
                messageBox.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.DeleteItem.Label", (String[])new String[0]));
                messageBox.setMessage(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.ConfirmDeleteItem.Label", (String[])new String[]{tItem.getText()}));
                switch (messageBox.open()) {
                    case 64: {
                        this.modifyCTabItem(tItem, TabActions.DELETE_ITEM, "");
                        tItem.dispose();
                        this.input.setChanged();
                        break;
                    }
                }
            }
        });
        MenuItem renItem = new MenuItem(this.tMenu, 8);
        renItem.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Rename.Label", (String[])new String[0]));
        renItem.addListener(13, e -> this.renameFunction(this.wTree.getSelection()[0]));
        new MenuItem(this.tMenu, 2);
        MenuItem helpItem = new MenuItem(this.tMenu, 8);
        helpItem.setText(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassDialog.Sample.Label", (String[])new String[0]));
        helpItem.addListener(13, e -> {
            String snippitFullName = this.wTree.getSelection()[0].getText();
            String sampleTabName = snippitFullName.replace("Implement ", "").replace(' ', '_') + "_Sample";
            if (this.getCTabPosition(sampleTabName) == -1) {
                this.addCtab(sampleTabName, this.snippitsHelper.getSample(snippitFullName), TabAddActions.ADD_DEFAULT);
            }
            if (this.getCTabPosition(sampleTabName) != -1) {
                this.setActiveCtab(sampleTabName);
            }
        });
        this.wTree.addListener(3, e -> {
            if (this.wTree.getSelectionCount() <= 0) {
                return;
            }
            TreeItem tItem = this.wTree.getSelection()[0];
            if (tItem != null) {
                TreeItem pItem = tItem.getParentItem();
                if (pItem != null && pItem.equals(this.wTreeClassesItem)) {
                    if (this.folder.getItemCount() > 1) {
                        this.tMenu.getItem(0).setEnabled(true);
                    } else {
                        this.tMenu.getItem(0).setEnabled(false);
                    }
                    this.tMenu.getItem(1).setEnabled(true);
                    this.tMenu.getItem(3).setEnabled(false);
                } else if (tItem.equals(this.wTreeClassesItem)) {
                    this.tMenu.getItem(0).setEnabled(false);
                    this.tMenu.getItem(1).setEnabled(false);
                    this.tMenu.getItem(3).setEnabled(false);
                } else if (pItem != null && pItem.getData() != null && pItem.getData().equals("Snippits Category")) {
                    this.tMenu.getItem(0).setEnabled(false);
                    this.tMenu.getItem(1).setEnabled(false);
                    this.tMenu.getItem(3).setEnabled(true);
                } else {
                    this.tMenu.getItem(0).setEnabled(false);
                    this.tMenu.getItem(1).setEnabled(false);
                    this.tMenu.getItem(3).setEnabled(false);
                }
            }
        });
        this.wTree.setMenu(this.tMenu);
    }

    private void addRenameToTreeScriptItems() {
        this.lastItem = new TreeItem[1];
        this.editor = new TreeEditor(this.wTree);
        this.wTree.addListener(13, event -> {
            TreeItem item = (TreeItem)event.item;
            this.renameFunction(item);
        });
    }

    private void renameFunction(TreeItem tItem) {
        TreeItem item = tItem;
        if (item.getParentItem() != null && item.getParentItem().equals(this.wTreeClassesItem) && item != null && item == this.lastItem[0]) {
            boolean isCarbon = SWT.getPlatform().equals("carbon");
            Composite composite = new Composite((Composite)this.wTree, 0);
            if (!isCarbon) {
                composite.setBackground(this.shell.getDisplay().getSystemColor(2));
            }
            Text text = new Text(composite, 0);
            int inset = isCarbon ? 0 : 1;
            composite.addListener(11, e -> {
                Rectangle rect = composite.getClientArea();
                text.setBounds(rect.x + inset, rect.y + inset, rect.width - inset * 2, rect.height - inset * 2);
            });
            Listener textListener = e -> {
                block0 : switch (e.type) {
                    case 16: {
                        if (text.getText().length() > 0 && this.getCTabItemByName(text.getText()) == null) {
                            this.modifyCTabItem(item, TabActions.RENAME_ITEM, text.getText());
                            item.setText(this.cleanClassName(text.getText()));
                        }
                        composite.dispose();
                        break;
                    }
                    case 25: {
                        String newText = text.getText();
                        String leftText = newText.substring(0, e.start);
                        String rightText = newText.substring(e.end, newText.length());
                        Point size = TextSizeUtilFacade.textExtent((String)(leftText + e.text + rightText));
                        size = text.computeSize(size.x, -1);
                        this.editor.horizontalAlignment = 16384;
                        Rectangle itemRect = item.getBounds();
                        Rectangle rect = this.wTree.getClientArea();
                        this.editor.minimumWidth = Math.max(size.x, itemRect.width) + inset * 2;
                        int left = itemRect.x;
                        int right = rect.x + rect.width;
                        this.editor.minimumWidth = Math.min(this.editor.minimumWidth, right - left);
                        this.editor.minimumHeight = size.y + inset * 2;
                        this.editor.layout();
                        break;
                    }
                    case 31: {
                        switch (e.detail) {
                            case 4: {
                                if (text.getText().length() > 0 && this.getCTabItemByName(text.getText()) == null) {
                                    this.modifyCTabItem(item, TabActions.RENAME_ITEM, text.getText());
                                    item.setText(this.cleanClassName(text.getText()));
                                }
                            }
                            case 2: {
                                composite.dispose();
                                e.doit = false;
                                break block0;
                            }
                        }
                        break;
                    }
                }
            };
            text.addListener(16, textListener);
            text.addListener(31, textListener);
            text.addListener(25, textListener);
            this.editor.setEditor((Control)composite, item);
            text.setText(item.getText());
            text.selectAll();
            text.setFocus();
        }
        this.lastItem[0] = item;
    }

    private String cleanClassName(String unsafeName) {
        return unsafeName.replaceAll("(?:^[^\\p{Alpha}])|[^\\w]", "");
    }

    private static enum TabAddActions {
        ADD_COPY,
        ADD_BLANK,
        ADD_DEFAULT;

    }

    private static enum TabActions {
        DELETE_ITEM,
        ADD_ITEM,
        RENAME_ITEM,
        SET_ACTIVE_ITEM;

    }
}

