/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.actions.runtests;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.actions.runtests.RunPipelineTests;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RunPipelineTestsDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = RunPipelineTestsDialog.class;
    private static final String COLON_SEPARATOR = " : ";
    private RunPipelineTests action;
    private Text wName;
    private TableView wTestNames;

    public RunPipelineTestsDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (RunPipelineTests)action;
        if (this.action.getName() == null) {
            this.action.setName("RunPipelineTests");
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RunPipelineTests.Name", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText("Action name");
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        Label wlTestNames = new Label((Composite)this.shell, 16384);
        wlTestNames.setText("Names of the tests to execute:");
        PropsUi.setLook((Widget)wlTestNames);
        FormData fdlTestNames = new FormData();
        fdlTestNames.left = new FormAttachment(0, 0);
        fdlTestNames.top = new FormAttachment((Control)lastControl, 2 * margin);
        fdlTestNames.right = new FormAttachment(100, 0);
        wlTestNames.setLayoutData((Object)fdlTestNames);
        lastControl = wlTestNames;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wGet = new Button((Composite)this.shell, 8);
        wGet.setText(BaseMessages.getString(PKG, (String)"RunTestsDialog.Button.GetTestNames", (String[])new String[0]));
        wGet.addListener(13, e -> this.getTestNames());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wGet, wCancel}, (int)margin, null);
        ColumnInfo[] columnInfos = new ColumnInfo[]{new ColumnInfo("Name", 1, false, false)};
        this.wTestNames = new TableView(this.variables, (Composite)this.shell, 2048, columnInfos, this.action.getTestNames().size(), null, this.props);
        PropsUi.setLook((Widget)this.wTestNames);
        FormData fdTestNames = new FormData();
        fdTestNames.left = new FormAttachment(0, 0);
        fdTestNames.right = new FormAttachment(100, 0);
        fdTestNames.top = new FormAttachment((Control)lastControl, margin);
        fdTestNames.bottom = new FormAttachment((Control)wOk, -margin * 2);
        this.wTestNames.setLayoutData((Object)fdTestNames);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void getTestNames() {
        try {
            IHopMetadataSerializer testSerializer = this.metadataProvider.getSerializer(PipelineUnitTest.class);
            List testNames = testSerializer.listObjectNames();
            for (String testName : testNames) {
                this.wTestNames.add(new String[]{testName});
            }
            this.wTestNames.optimizeTableView();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error getting list of pipeline unit test names", e);
        }
    }

    private void cancel() {
        this.action = null;
        this.dispose();
    }

    private void getData() {
        this.wName.setText(Const.NVL((String)this.action.getName(), (String)""));
        int rowNr = 0;
        for (String testName : this.action.getTestNames()) {
            TableItem item = this.wTestNames.table.getItem(rowNr++);
            item.setText(1, Const.NVL((String)testName, (String)""));
        }
        this.wTestNames.setRowNums();
        this.wTestNames.optWidth(true);
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText("Warning");
            mb.setMessage("The name of the action is missing!");
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.getTestNames().clear();
        for (int i = 0; i < this.wTestNames.nrNonEmpty(); ++i) {
            TableItem item = this.wTestNames.getNonEmpty(i);
            this.action.getTestNames().add(item.getText(1));
        }
        this.action.setChanged();
        this.dispose();
    }
}

