/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.update;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.utils.RowMetaUtils;
import org.apache.hop.pipeline.transforms.update.Update;
import org.apache.hop.pipeline.transforms.update.UpdateData;
import org.apache.hop.pipeline.transforms.update.UpdateField;
import org.apache.hop.pipeline.transforms.update.UpdateKeyField;
import org.apache.hop.pipeline.transforms.update.UpdateLookupField;

@Transform(id="Update", image="update.svg", name="i18n::Update.Name", description="i18n::Update.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::UpdateMeta.keyword"}, documentationUrl="/pipeline/transforms/update.html")
public class UpdateMeta
extends BaseTransformMeta<Update, UpdateData> {
    private static final Class<?> PKG = UpdateMeta.class;
    private IHopMetadataProvider metadataProvider;
    @HopMetadataProperty(key="commit", injectionKeyDescription="UpdateMeta.Injection.CommitSize", injectionKey="COMMIT_SIZE")
    private String commitSize;
    @HopMetadataProperty(key="lookup")
    private UpdateLookupField lookupField = new UpdateLookupField();
    @HopMetadataProperty(key="error_ignored", injectionKeyDescription="UpdateMeta.Injection.IgnoreLookupFailure", injectionKey="IGNORE_LOOKUP_FAILURE")
    private boolean errorIgnored;
    @HopMetadataProperty(key="ignore_flag_field", injectionKeyDescription="UpdateMeta.Injection.IgnoreFlagField", injectionKey="FLAG_FIELD")
    private String ignoreFlagField;
    @HopMetadataProperty(key="skip_lookup", injectionKeyDescription="UpdateMeta.Injection.SkipLookup", injectionKey="SKIP_LOOKUP")
    private boolean skipLookup;
    @HopMetadataProperty(key="use_batch", injectionKeyDescription="UpdateMeta.Injection.UseBatchUpdate", injectionKey="BATCH_UPDATE")
    private boolean useBatchUpdate;
    @HopMetadataProperty(key="connection", injectionKeyDescription="UpdateMeta.Injection.Connection", injectionKey="CONNECTIONNAME")
    private String connection;

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public UpdateLookupField getLookupField() {
        return this.lookupField;
    }

    public void setLookupField(UpdateLookupField lookupField) {
        this.lookupField = lookupField;
    }

    @Deprecated(since="2.0")
    public int getCommitSize() {
        return Integer.parseInt(this.commitSize);
    }

    public String getCommitSizeVar() {
        return this.commitSize;
    }

    public int getCommitSize(IVariables vs) {
        this.commitSize = this.commitSize == null ? "0" : this.commitSize;
        return Integer.parseInt(vs.resolve(this.commitSize));
    }

    @Deprecated(since="2.0")
    public void setCommitSize(int commitSize) {
        this.commitSize = Integer.toString(commitSize);
    }

    public void setCommitSize(String commitSize) {
        this.commitSize = commitSize;
    }

    public boolean isSkipLookup() {
        return this.skipLookup;
    }

    public void setSkipLookup(boolean skipLookup) {
        this.skipLookup = skipLookup;
    }

    public boolean isErrorIgnored() {
        return this.errorIgnored;
    }

    public void setErrorIgnored(boolean ignoreError) {
        this.errorIgnored = ignoreError;
    }

    public String getIgnoreFlagField() {
        return this.ignoreFlagField;
    }

    public void setIgnoreFlagField(String ignoreFlagField) {
        this.ignoreFlagField = ignoreFlagField;
    }

    public Object clone() {
        UpdateMeta retval = (UpdateMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.skipLookup = false;
        this.commitSize = "100";
        this.lookupField.setSchemaName("");
        this.lookupField.setTableName(BaseMessages.getString(PKG, (String)"UpdateMeta.DefaultTableName", (String[])new String[0]));
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.ignoreFlagField != null && this.ignoreFlagField.length() > 0) {
            ValueMetaBoolean v = new ValueMetaBoolean(this.ignoreFlagField);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Object errorMessage = "";
        DatabaseMeta databaseMeta = null;
        try {
            databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
        }
        catch (HopException e) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.DatabaseMetaError", (String[])new String[]{variables.resolve(this.connection)}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (databaseMeta != null) {
            Database db = new Database(loggingObject, variables, databaseMeta);
            try {
                boolean errorFound;
                boolean first;
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.lookupField.getTableName())) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.TableNameOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    IRowMeta r = db.getTableFieldsMeta(this.lookupField.getSchemaName(), this.lookupField.getTableName());
                    if (r != null) {
                        IValueMeta v;
                        int i;
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.TableExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        for (i = 0; i < this.lookupField.getLookupKeys().size(); ++i) {
                            UpdateKeyField keyItem = this.lookupField.getLookupKeys().get(i);
                            v = r.searchValueMeta(keyItem.getKeyLookup());
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.MissingCompareFieldsInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + keyItem.getKeyLookup() + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.AllLookupFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        first = true;
                        errorFound = false;
                        errorMessage = "";
                        for (i = 0; i < this.lookupField.getUpdateFields().size(); ++i) {
                            UpdateField fieldItem = this.lookupField.getUpdateFields().get(i);
                            v = r.searchValueMeta(fieldItem.getUpdateLookup());
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.MissingFieldsToUpdateInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + fieldItem.getUpdateLookup() + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.AllFieldsToUpdateFoundInTargetTable", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    IValueMeta v;
                    int i;
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.TransformReceivingDatas", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorMessage = "";
                    errorFound = false;
                    for (i = 0; i < this.lookupField.getLookupKeys().size(); ++i) {
                        UpdateKeyField keyItem = this.lookupField.getLookupKeys().get(i);
                        v = prev.searchValueMeta(keyItem.getKeyStream());
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + keyItem.getKeyStream() + Const.CR;
                    }
                    for (i = 0; i < this.lookupField.getLookupKeys().size(); ++i) {
                        UpdateKeyField keyItem = this.lookupField.getLookupKeys().get(i);
                        if (StringUtil.isEmpty((String)keyItem.getKeyStream2()) || (v = prev.searchValueMeta(keyItem.getKeyStream2())) != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.MissingFieldsInInput2", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + keyItem.getKeyStream2() + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    for (i = 0; i < this.lookupField.getUpdateFields().size(); ++i) {
                        UpdateField fieldItem = this.lookupField.getUpdateFields().get(i);
                        v = prev.searchValueMeta(fieldItem.getUpdateStream());
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.MissingInputStreamFields", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + fieldItem.getUpdateStream() + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.AllFieldsFoundInInput2", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                errorMessage = BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                errorMessage = BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) throws HopTransformException {
        SqlStatement retval;
        block21: {
            retval = null;
            try {
                DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
                retval = new SqlStatement(transformMeta.getName(), databaseMeta, null);
                if (databaseMeta != null) {
                    if (prev != null && prev.size() > 0) {
                        int i;
                        String[] keyLookup = null;
                        String[] keyStream = null;
                        String[] updateLookup = null;
                        String[] updateStream = null;
                        if (this.lookupField.getLookupKeys().size() > 0) {
                            keyLookup = new String[this.lookupField.getLookupKeys().size()];
                            for (i = 0; i < this.lookupField.getLookupKeys().size(); ++i) {
                                keyLookup[i] = this.lookupField.getLookupKeys().get(i).getKeyLookup();
                            }
                        }
                        if (this.lookupField.getLookupKeys().size() > 0) {
                            keyStream = new String[this.lookupField.getLookupKeys().size()];
                            for (i = 0; i < this.lookupField.getLookupKeys().size(); ++i) {
                                keyStream[i] = this.lookupField.getLookupKeys().get(i).getKeyStream();
                            }
                        }
                        if (this.lookupField.getLookupKeys().size() > 0) {
                            updateLookup = new String[this.lookupField.getUpdateFields().size()];
                            for (i = 0; i < this.lookupField.getUpdateFields().size(); ++i) {
                                updateLookup[i] = this.lookupField.getUpdateFields().get(i).getUpdateLookup();
                            }
                        }
                        if (this.lookupField.getLookupKeys().size() > 0) {
                            updateStream = new String[this.lookupField.getUpdateFields().size()];
                            for (i = 0; i < this.lookupField.getUpdateFields().size(); ++i) {
                                updateStream[i] = this.lookupField.getUpdateFields().get(i).getUpdateStream();
                            }
                        }
                        IRowMeta tableFields = RowMetaUtils.getRowMetaForUpdate((IRowMeta)prev, (String[])keyLookup, (String[])keyStream, (String[])updateLookup, (String[])updateStream);
                        if (!Utils.isEmpty((CharSequence)this.lookupField.getTableName())) {
                            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.lookupField.getSchemaName(), this.lookupField.getTableName());
                            Database db = new Database(loggingObject, variables, databaseMeta);
                            try {
                                String sql;
                                db.connect();
                                if (this.getIgnoreFlagField() != null && this.getIgnoreFlagField().length() > 0) {
                                    prev.addValueMeta((IValueMeta)new ValueMetaBoolean(this.getIgnoreFlagField()));
                                }
                                String crTable = db.getDDL(schemaTable, tableFields, null, false, null, true);
                                String crIndex = "";
                                String[] idxFields = null;
                                if (this.lookupField.getLookupKeys().size() > 0) {
                                    idxFields = new String[this.lookupField.getLookupKeys().size()];
                                    for (int i2 = 0; i2 < this.lookupField.getLookupKeys().size(); ++i2) {
                                        idxFields[i2] = this.lookupField.getLookupKeys().get(i2).getKeyLookup();
                                    }
                                } else {
                                    retval.setError(BaseMessages.getString(PKG, (String)"UpdateMeta.CheckResult.MissingKeyFields", (String[])new String[0]));
                                }
                                if (idxFields != null && idxFields.length > 0 && !db.checkIndexExists(schemaTable, idxFields)) {
                                    String indexname = "idx_" + this.lookupField.getTableName() + "_lookup";
                                    crIndex = db.getCreateIndexStatement(schemaTable, indexname, idxFields, false, false, false, true);
                                }
                                if ((sql = crTable + crIndex).length() == 0) {
                                    retval.setSql(null);
                                    break block21;
                                }
                                retval.setSql(sql);
                            }
                            catch (HopException e) {
                                retval.setError(BaseMessages.getString(PKG, (String)"UpdateMeta.ReturnValue.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                            }
                            break block21;
                        }
                        retval.setError(BaseMessages.getString(PKG, (String)"UpdateMeta.ReturnValue.NoTableDefinedOnConnection", (String[])new String[0]));
                        break block21;
                    }
                    retval.setError(BaseMessages.getString(PKG, (String)"UpdateMeta.ReturnValue.NotReceivingAnyFields", (String[])new String[0]));
                    break block21;
                }
                retval.setError(BaseMessages.getString(PKG, (String)"UpdateMeta.ReturnValue.NoConnectionDefined", (String[])new String[0]));
            }
            catch (HopException e) {
                throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection), (Throwable)e);
            }
        }
        return retval;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            if (prev != null) {
                DatabaseImpact ii;
                IValueMeta v;
                int i;
                for (i = 0; i < this.lookupField.getLookupKeys().size(); ++i) {
                    UpdateKeyField keyFieldItem = this.lookupField.getLookupKeys().get(i);
                    v = prev.searchValueMeta(keyFieldItem.getKeyStream());
                    ii = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), this.lookupField.getTableName(), keyFieldItem.getKeyLookup(), keyFieldItem.getKeyStream(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
                for (i = 0; i < this.lookupField.getUpdateFields().size(); ++i) {
                    UpdateField fieldItem = this.lookupField.getUpdateFields().get(i);
                    v = prev.searchValueMeta(fieldItem.getUpdateStream());
                    ii = new DatabaseImpact(6, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), this.lookupField.getTableName(), fieldItem.getUpdateLookup(), fieldItem.getUpdateStream(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
            }
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection), (Throwable)e);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public boolean isUseBatchUpdate() {
        return this.useBatchUpdate;
    }

    public void setUseBatchUpdate(boolean useBatchUpdate) {
        this.useBatchUpdate = useBatchUpdate;
    }
}

