/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannelFileWriterBuffer;
import org.apache.hop.core.logging.LoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.util.EnvUtil;

public class LoggingRegistry {
    private static LoggingRegistry registry = new LoggingRegistry();
    private Map<String, ILoggingObject> map;
    private Map<String, LogChannelFileWriterBuffer> fileWriterBuffers;
    private Map<String, List<String>> childrenMap;
    private Date lastModificationTime;
    private int maxSize;
    private final int DEFAULT_MAX_SIZE = 10000;
    private final Object syncObject = new Object();

    private LoggingRegistry() {
        this.map = new ConcurrentHashMap<String, ILoggingObject>();
        this.childrenMap = new ConcurrentHashMap<String, List<String>>();
        this.fileWriterBuffers = new ConcurrentHashMap<String, LogChannelFileWriterBuffer>();
        this.lastModificationTime = new Date();
        this.maxSize = Const.toInt(EnvUtil.getSystemProperty("HOP_MAX_LOGGING_REGISTRY_SIZE"), 10000);
    }

    public static LoggingRegistry getInstance() {
        return registry;
    }

    public String registerLoggingSource(Object object) {
        return this.registerLoggingSource(object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerLoggingSource(Object object, boolean forceNewEntry) {
        Object object2 = this.syncObject;
        synchronized (object2) {
            String parentLogChannelId;
            LoggingObject loggingSource = new LoggingObject(object);
            ILoggingObject found = forceNewEntry ? null : this.findExistingLoggingSource(loggingSource);
            if (found != null) {
                ILoggingObject foundParent = found.getParent();
                ILoggingObject loggingSourceParent = loggingSource.getParent();
                String foundLogChannelId = found.getLogChannelId();
                if (foundParent != null && loggingSourceParent != null) {
                    String foundParentLogChannelId = foundParent.getLogChannelId();
                    String sourceParentLogChannelId = loggingSourceParent.getLogChannelId();
                    if (foundParentLogChannelId != null && foundParentLogChannelId.equals(sourceParentLogChannelId) && foundLogChannelId != null) {
                        return foundLogChannelId;
                    }
                }
                if (foundParent == null && loggingSourceParent == null && foundLogChannelId != null) {
                    return foundLogChannelId;
                }
            }
            String logChannelId = UUID.randomUUID().toString();
            loggingSource.setLogChannelId(logChannelId);
            this.map.put(logChannelId, loggingSource);
            if (loggingSource.getParent() != null && (parentLogChannelId = loggingSource.getParent().getLogChannelId()) != null) {
                List parentChildren = this.childrenMap.computeIfAbsent(parentLogChannelId, k -> new ArrayList());
                parentChildren.add(logChannelId);
            }
            this.lastModificationTime = new Date();
            loggingSource.setRegistrationDate(this.lastModificationTime);
            if (this.maxSize > 0 && this.map.size() > this.maxSize) {
                ArrayList<ILoggingObject> all = new ArrayList<ILoggingObject>(this.map.values());
                Collections.sort(all, (o1, o2) -> {
                    if (o1 == null && o2 != null) {
                        return -1;
                    }
                    if (o1 != null && o2 == null) {
                        return 1;
                    }
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1.getRegistrationDate() == null && o2.getRegistrationDate() != null) {
                        return -1;
                    }
                    if (o1.getRegistrationDate() != null && o2.getRegistrationDate() == null) {
                        return 1;
                    }
                    if (o1.getRegistrationDate() == null && o2.getRegistrationDate() == null) {
                        return 0;
                    }
                    return o1.getRegistrationDate().compareTo(o2.getRegistrationDate());
                });
                int cutCount = this.maxSize < 1000 ? this.maxSize : 1000;
                Set<String> channelsNotToRemove = this.getLogChannelFileWriterBufferIds();
                for (int i = 0; i < cutCount; ++i) {
                    ILoggingObject toRemove = (ILoggingObject)all.get(i);
                    if (channelsNotToRemove.contains(toRemove.getLogChannelId())) continue;
                    this.map.remove(toRemove.getLogChannelId());
                }
                this.removeOrphans();
            }
            return logChannelId;
        }
    }

    public ILoggingObject findExistingLoggingSource(ILoggingObject loggingObject) {
        ILoggingObject found = null;
        for (ILoggingObject verify : this.map.values()) {
            if (!loggingObject.equals(verify)) continue;
            found = verify;
            break;
        }
        return found;
    }

    public ILoggingObject getLoggingObject(String logChannelId) {
        return this.map.get(logChannelId);
    }

    public Map<String, ILoggingObject> getMap() {
        return this.map;
    }

    public List<String> getLogChannelChildren(String parentLogChannelId) {
        if (parentLogChannelId == null) {
            return null;
        }
        List<String> list = this.getLogChannelChildren(new ArrayList<String>(), parentLogChannelId);
        list.add(parentLogChannelId);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getLogChannelChildren(List<String> children, String parentLogChannelId) {
        Object object = this.syncObject;
        synchronized (object) {
            List<String> list = this.childrenMap.get(parentLogChannelId);
            if (list == null) {
                return children;
            }
            for (String logChannelId : list) {
                this.getLogChannelChildren(children, logChannelId);
                children.add(logChannelId);
            }
        }
        return children;
    }

    public Date getLastModificationTime() {
        return this.lastModificationTime;
    }

    public String dump(boolean includeGeneral) {
        StringBuilder out = new StringBuilder(50000);
        for (ILoggingObject o : this.map.values()) {
            if (!includeGeneral && o.getObjectType().equals((Object)LoggingObjectType.GENERAL)) continue;
            out.append(o.getContainerId());
            out.append("\t");
            out.append(o.getLogChannelId());
            out.append("\t");
            out.append(o.getObjectType().name());
            out.append("\t");
            out.append(o.getObjectName());
            out.append("\t");
            out.append(o.getParent() != null ? o.getParent().getLogChannelId() : "-");
            out.append("\t");
            out.append(o.getParent() != null ? o.getParent().getObjectType().name() : "-");
            out.append("\t");
            out.append(o.getParent() != null ? o.getParent().getObjectName() : "-");
            out.append("\n");
        }
        return out.toString();
    }

    Map<String, ILoggingObject> dumpItems() {
        return Collections.unmodifiableMap(this.map);
    }

    Map<String, List<String>> dumpChildren() {
        return Collections.unmodifiableMap(this.childrenMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIncludingChildren(String logChannelId) {
        Map<String, ILoggingObject> map = this.map;
        synchronized (map) {
            List<String> children = this.getLogChannelChildren(logChannelId);
            for (String child : children) {
                this.map.remove(child);
            }
            this.map.remove(logChannelId);
            this.removeOrphans();
        }
    }

    public void removeOrphans() {
        this.childrenMap.keySet().retainAll(this.map.keySet());
    }

    public void registerLogChannelFileWriterBuffer(LogChannelFileWriterBuffer fileWriterBuffer) {
        this.fileWriterBuffers.put(fileWriterBuffer.getLogChannelId(), fileWriterBuffer);
    }

    public LogChannelFileWriterBuffer getLogChannelFileWriterBuffer(String id) {
        for (String bufferId : this.fileWriterBuffers.keySet()) {
            if (!this.getLogChannelChildren(bufferId).contains(id)) continue;
            return this.fileWriterBuffers.get(bufferId);
        }
        return null;
    }

    protected Set<String> getLogChannelFileWriterBufferIds() {
        Set<String> bufferIds = this.fileWriterBuffers.keySet();
        HashSet<String> ids = new HashSet<String>();
        for (String id : bufferIds) {
            ids.addAll(this.getLogChannelChildren(id));
        }
        ids.addAll(bufferIds);
        return ids;
    }

    public void removeLogChannelFileWriterBuffer(String id) {
        Set<String> bufferIds = this.fileWriterBuffers.keySet();
        for (String bufferId : bufferIds) {
            if (!this.getLogChannelChildren(id).contains(bufferId)) continue;
            this.fileWriterBuffers.remove(bufferId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.syncObject;
        synchronized (object) {
            this.map.clear();
            this.childrenMap.clear();
            this.fileWriterBuffers.clear();
        }
    }

    public Map<String, List<String>> getChildrenMap() {
        return this.childrenMap;
    }
}

