/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git;

import java.util.Map;
import java.util.Optional;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.workflow.WorkflowHopMeta;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;

public class HopDiff {
    public static String ATTR_GIT = "Git";
    public static String ATTR_STATUS = "Status";
    public static String ATTR_GIT_HOPS = "GitHops";
    public static final String UNCHANGED = "UNCHANGED";
    public static final String CHANGED = "CHANGED";
    public static final String REMOVED = "REMOVED";
    public static final String ADDED = "ADDED";

    public static PipelineMeta compareTransforms(PipelineMeta pipelineMeta1, PipelineMeta pipelineMeta2, boolean isForward) {
        pipelineMeta1.getTransforms().forEach(transform -> {
            String status;
            block4: {
                block5: {
                    Optional<TransformMeta> transform2 = pipelineMeta2.getTransforms().stream().filter(obj -> transform.getName().equals(obj.getName())).findFirst();
                    status = null;
                    if (!transform2.isPresent()) break block5;
                    Map tmp = null;
                    Map tmp2 = null;
                    try {
                        tmp = (Map)transform.getAttributesMap().remove(ATTR_GIT);
                        tmp2 = (Map)transform2.get().getAttributesMap().remove(ATTR_GIT);
                        status = transform.getXml().equals(transform2.get().getXml()) ? UNCHANGED : CHANGED;
                    }
                    catch (HopException e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            transform.setAttributes(ATTR_GIT, tmp);
                            transform2.get().setAttributes(ATTR_GIT, tmp2);
                            throw throwable;
                        }
                        transform.setAttributes(ATTR_GIT, tmp);
                        transform2.get().setAttributes(ATTR_GIT, tmp2);
                        break block4;
                    }
                    transform.setAttributes(ATTR_GIT, tmp);
                    transform2.get().setAttributes(ATTR_GIT, tmp2);
                    break block4;
                }
                status = isForward ? REMOVED : ADDED;
            }
            transform.setAttribute(ATTR_GIT, ATTR_STATUS, status);
        });
        return pipelineMeta1;
    }

    public static PipelineMeta comparePipelineHops(PipelineMeta pipelineMeta1, PipelineMeta pipelineMeta2, boolean isForward) {
        pipelineMeta1.getPipelineHops().forEach(hop -> {
            String hopName = HopDiff.getPipelineHopName(hop);
            Optional<PipelineHopMeta> hop2 = pipelineMeta2.getPipelineHops().stream().filter(otherHop -> hopName.equals(HopDiff.getPipelineHopName(otherHop))).findFirst();
            String status = null;
            if (hop2.isPresent()) {
                if (hop.isEnabled() != hop2.get().isEnabled()) {
                    status = CHANGED;
                }
            } else {
                status = isForward ? REMOVED : ADDED;
            }
            if (status != null) {
                pipelineMeta1.setAttribute(ATTR_GIT_HOPS, hopName, status);
            }
        });
        return pipelineMeta1;
    }

    public static final String getPipelineHopName(PipelineHopMeta hopMeta) {
        Object name = "";
        TransformMeta from = hopMeta.getFromTransform();
        if (from != null) {
            name = (String)name + from.getName();
        }
        name = (String)name + " - ";
        TransformMeta to = hopMeta.getFromTransform();
        if (to != null) {
            name = (String)name + to.getName();
        }
        return name;
    }

    public static WorkflowMeta compareActions(WorkflowMeta workflowMeta1, WorkflowMeta workflowMeta2, boolean isForward) {
        workflowMeta1.getActions().forEach(je -> {
            Optional<ActionMeta> je2 = workflowMeta2.getActions().stream().filter(obj -> je.getName().equals(obj.getName())).findFirst();
            String status = null;
            if (je2.isPresent()) {
                Map tmp = null;
                Map tmp2 = null;
                tmp = (Map)je.getAttributesMap().remove(ATTR_GIT);
                tmp2 = (Map)je2.get().getAttributesMap().remove(ATTR_GIT);
                status = je.getXml().equals(je2.get().getXml()) ? UNCHANGED : CHANGED;
                je.setAttributes(ATTR_GIT, tmp);
                je2.get().setAttributes(ATTR_GIT, tmp2);
            } else {
                status = isForward ? REMOVED : ADDED;
            }
            je.setAttribute(ATTR_GIT, ATTR_STATUS, status);
        });
        return workflowMeta1;
    }

    public static WorkflowMeta compareWorkflowHops(WorkflowMeta workflowMeta1, WorkflowMeta workflowMeta2, boolean isForward) {
        workflowMeta1.getWorkflowHops().forEach(hop -> {
            String hopName = HopDiff.getWorkflowHopName(hop);
            Optional<WorkflowHopMeta> hop2 = workflowMeta2.getWorkflowHops().stream().filter(otherHop -> hopName.equals(HopDiff.getWorkflowHopName(otherHop))).findFirst();
            String status = null;
            if (hop2.isPresent()) {
                if (hop.isEnabled() != hop2.get().isEnabled()) {
                    status = CHANGED;
                }
            } else {
                status = isForward ? REMOVED : ADDED;
            }
            if (status != null) {
                workflowMeta1.setAttribute(ATTR_GIT_HOPS, hopName, status);
            }
        });
        return workflowMeta1;
    }

    public static final String getWorkflowHopName(WorkflowHopMeta hopMeta) {
        Object name = "";
        ActionMeta from = hopMeta.getFromAction();
        if (from != null) {
            name = (String)name + from.getName();
        }
        name = (String)name + " - ";
        ActionMeta to = hopMeta.getToAction();
        if (to != null) {
            name = (String)name + to.getName();
        }
        return name;
    }
}

