/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.types;

import org.apache.beam.runners.flink.translation.types.EncodedValueTypeInformation;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Bytes;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WindowedKvKeySelector<@UnknownKeyFor InputT, @UnknownKeyFor K>
implements KeySelector<WindowedValue<KV<K, InputT>>, byte[]>,
ResultTypeQueryable<byte[]> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder;

    public WindowedKvKeySelector(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
        this.keyCoder = keyCoder;
        this.windowCoder = windowCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getKey(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>> value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        byte[] encodedKey = CoderUtils.encodeToByteArray(this.keyCoder, (Object)((KV)value.getValue()).getKey());
        byte[] encodedWindow = CoderUtils.encodeToByteArray(this.windowCoder, (Object)((BoundedWindow)Iterables.getOnlyElement((Iterable)value.getWindows())));
        return Bytes.concat((byte[][])new byte[][]{encodedKey, encodedWindow});
    }

    public @UnknownKeyFor @NonNull @Initialized TypeInformation<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getProducedType() {
        return new EncodedValueTypeInformation();
    }
}

