/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.core.ApiService;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ProxyService;
import com.google.cloud.pubsublite.internal.wire.Subscriber;
import com.google.cloud.pubsublite.proto.FlowControlRequest;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryBufferedSubscriber;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryLimiter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemoryBufferedSubscriberImpl
extends ProxyService
implements MemoryBufferedSubscriber {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MemoryBufferedSubscriberImpl.class);
    private final @UnknownKeyFor @NonNull @Initialized Partition partition;
    private final @UnknownKeyFor @NonNull @Initialized MemoryLimiter limiter;
    private final @UnknownKeyFor @NonNull @Initialized Subscriber subscriber;
    private @UnknownKeyFor @NonNull @Initialized long targetMemory;
    private @UnknownKeyFor @NonNull @Initialized Offset fetchOffset;
    private @UnknownKeyFor @NonNull @Initialized MemoryLimiter.Block memBlock;
    private @UnknownKeyFor @NonNull @Initialized long bytesOutstandingToServer = 0L;
    private @UnknownKeyFor @NonNull @Initialized long bytesOutstanding = 0L;
    private final @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized SequencedMessage> messages = new ArrayDeque<SequencedMessage>();
    private @UnknownKeyFor @NonNull @Initialized boolean shutdown = false;

    public MemoryBufferedSubscriberImpl(@UnknownKeyFor @NonNull @Initialized Partition partition, @UnknownKeyFor @NonNull @Initialized Offset startOffset, @UnknownKeyFor @NonNull @Initialized MemoryLimiter limiter, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SequencedMessage>>, @UnknownKeyFor @NonNull @Initialized Subscriber> subscriberFactory) {
        super(new ApiService[0]);
        this.partition = partition;
        this.fetchOffset = startOffset;
        this.limiter = limiter;
        this.targetMemory = limiter.maxBlockSize();
        this.subscriber = subscriberFactory.apply(this::onReceive);
        this.addServices(new ApiService[]{this.subscriber});
        this.memBlock = limiter.claim(this.targetMemory);
    }

    protected synchronized void start() throws @UnknownKeyFor @NonNull @Initialized CheckedApiException {
        this.bytesOutstandingToServer += this.memBlock.claimed();
        this.bytesOutstanding += this.memBlock.claimed();
        this.subscriber.allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(this.memBlock.claimed()).setAllowedMessages(Long.MAX_VALUE).build());
    }

    protected synchronized void stop() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.memBlock.close();
    }

    protected synchronized void handlePermanentError(@UnknownKeyFor @NonNull @Initialized CheckedApiException e) {
        this.stop();
    }

    private synchronized void onReceive(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SequencedMessage> batch) {
        if (this.shutdown) {
            return;
        }
        for (SequencedMessage message : batch) {
            this.bytesOutstandingToServer -= message.getSizeBytes();
        }
        this.messages.addAll(batch);
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized Offset fetchOffset() {
        return this.fetchOffset;
    }

    @Override
    public synchronized void rebuffer() throws @UnknownKeyFor @NonNull @Initialized ApiException {
        if (this.shutdown) {
            return;
        }
        if (this.bytesOutstandingToServer < this.targetMemory / 3L) {
            this.targetMemory = Math.min(this.limiter.maxBlockSize(), this.targetMemory * 2L);
        } else if (this.bytesOutstandingToServer > 2L * this.targetMemory / 3L) {
            this.targetMemory = Math.max(this.limiter.minBlockSize(), this.targetMemory / 2L);
        }
        long claimTarget = Math.max(this.bytesOutstanding, this.targetMemory);
        this.memBlock.close();
        this.memBlock = this.limiter.claim(claimTarget);
        long toAllow = Math.max(this.memBlock.claimed() - this.bytesOutstanding, 0L);
        if (toAllow > 0L) {
            this.bytesOutstanding += toAllow;
            this.bytesOutstandingToServer += toAllow;
            try {
                this.subscriber.allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(toAllow).build());
            }
            catch (CheckedApiException e) {
                throw e.underlying;
            }
        } else {
            LOG.debug("Not claiming memory: partition {} outstanding {} to server {} target {} claimed {} messages {}", new Object[]{this.partition, this.bytesOutstanding, this.bytesOutstandingToServer, this.targetMemory, this.memBlock.claimed(), this.messages.size()});
        }
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized SequencedMessage> peek() {
        return Optional.ofNullable(this.messages.peek());
    }

    @Override
    public synchronized void pop() {
        SequencedMessage message = this.messages.remove();
        this.bytesOutstanding -= message.getSizeBytes();
        this.fetchOffset = Offset.of((long)(message.getCursor().getOffset() + 1L));
    }
}

