/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.Committer;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BlockingCommitterImpl
implements BlockingCommitter {
    private final @UnknownKeyFor @NonNull @Initialized Committer committer;

    BlockingCommitterImpl(@UnknownKeyFor @NonNull @Initialized Committer committer) {
        if (!committer.isRunning()) {
            throw new IllegalStateException("Committer passed to BlockingCommitter which is not running.", committer.failureCause());
        }
        this.committer = committer;
    }

    @Override
    public void commitOffset(@UnknownKeyFor @NonNull @Initialized Offset offset) {
        if (!this.committer.isRunning()) {
            throw new IllegalStateException("Committer not running when commitOffset called.", this.committer.failureCause());
        }
        try {
            this.committer.commitOffset(offset).get(1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw ExtractStatus.toCanonical((Throwable)e).underlying;
        }
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.committer.stopAsync().awaitTerminated(1L, TimeUnit.MINUTES);
    }
}

