/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.streaming.runtime.operators.sink.committables.SinkV1CommittableDeserializer;
import org.apache.flink.util.Preconditions;

@Internal
class SinkV1WriterCommittableSerializer<CommT>
implements SimpleVersionedSerializer<List<CommT>> {
    private final SimpleVersionedSerializer<CommT> committableSerializer;

    public SinkV1WriterCommittableSerializer(SimpleVersionedSerializer<CommT> committableSerializer) {
        this.committableSerializer = (SimpleVersionedSerializer)Preconditions.checkNotNull(committableSerializer);
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(List<CommT> obj) throws IOException {
        throw new UnsupportedOperationException("This serializer should only be used to deserialize legacy committable state.");
    }

    public List<CommT> deserialize(int version, byte[] serialized) throws IOException {
        return SinkV1CommittableDeserializer.readVersionAndDeserializeList(this.committableSerializer, (DataInputView)new DataInputDeserializer(serialized));
    }
}

