/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.rest;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.rest.RestConnection;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RestConnectionEditor
extends MetadataEditor<RestConnection> {
    private static final Class<?> PKG = RestConnectionEditor.class;
    private Text wName;
    private TextVar wBaseUrl;
    private TextVar wTestUrl;
    private TextVar wAuthorizationName;
    private TextVar wAuthorizationPrefix;
    private PasswordTextVar wAuthorizationValue;

    public RestConnectionEditor(HopGui hopGui, MetadataManager<RestConnection> manager, RestConnection restConnection) {
        super(hopGui, manager, (IHopMetadata)restConnection);
    }

    public void createControl(Composite composite) {
        Control[] controls;
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = props.getMargin();
        IVariables variables = this.hopGui.getVariables();
        Label wlName = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.Name", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(composite, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(95, 0);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        Label wlBaseUrl = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlBaseUrl);
        wlBaseUrl.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.BaseUrl", (String[])new String[0]));
        FormData fdlBaseUrl = new FormData();
        fdlBaseUrl.top = new FormAttachment((Control)lastControl, margin);
        fdlBaseUrl.left = new FormAttachment(0, 0);
        fdlBaseUrl.right = new FormAttachment(middle, -margin);
        wlBaseUrl.setLayoutData((Object)fdlBaseUrl);
        this.wBaseUrl = new TextVar(variables, composite, 18436);
        PropsUi.setLook((Widget)this.wBaseUrl);
        FormData fdBaseUrl = new FormData();
        fdBaseUrl.top = new FormAttachment((Control)wlBaseUrl, 0, 0x1000000);
        fdBaseUrl.left = new FormAttachment(middle, 0);
        fdBaseUrl.right = new FormAttachment(95, 0);
        this.wBaseUrl.setLayoutData((Object)fdBaseUrl);
        lastControl = this.wBaseUrl;
        Label wlTestUrl = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlTestUrl);
        wlTestUrl.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.TestUrl", (String[])new String[0]));
        FormData fdlTestUrl = new FormData();
        fdlTestUrl.top = new FormAttachment((Control)lastControl, margin);
        fdlTestUrl.left = new FormAttachment(0, 0);
        fdlTestUrl.right = new FormAttachment(middle, -margin);
        wlTestUrl.setLayoutData((Object)fdlTestUrl);
        this.wTestUrl = new TextVar(variables, composite, 18436);
        PropsUi.setLook((Widget)this.wTestUrl);
        FormData fdTestUrl = new FormData();
        fdTestUrl.top = new FormAttachment((Control)wlTestUrl, 0, 0x1000000);
        fdTestUrl.left = new FormAttachment(middle, 0);
        fdTestUrl.right = new FormAttachment(95, 0);
        this.wTestUrl.setLayoutData((Object)fdTestUrl);
        lastControl = this.wTestUrl;
        Label wlAuthorizationName = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlAuthorizationName);
        wlAuthorizationName.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.AuthorizationName", (String[])new String[0]));
        FormData fdlAuthorizationName = new FormData();
        fdlAuthorizationName.top = new FormAttachment((Control)lastControl, margin);
        fdlAuthorizationName.left = new FormAttachment(0, 0);
        fdlAuthorizationName.right = new FormAttachment(middle, -margin);
        wlAuthorizationName.setLayoutData((Object)fdlAuthorizationName);
        this.wAuthorizationName = new TextVar(variables, composite, 18436);
        PropsUi.setLook((Widget)this.wAuthorizationName);
        FormData fdAuthorizationName = new FormData();
        fdAuthorizationName.top = new FormAttachment((Control)wlAuthorizationName, 0, 0x1000000);
        fdAuthorizationName.left = new FormAttachment(middle, 0);
        fdAuthorizationName.right = new FormAttachment(95, 0);
        this.wAuthorizationName.setLayoutData((Object)fdAuthorizationName);
        lastControl = this.wAuthorizationName;
        Label wlAuthorizationPrefix = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlAuthorizationPrefix);
        wlAuthorizationPrefix.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.AuthorizationPrefix", (String[])new String[0]));
        FormData fdlAuthorizationPrefix = new FormData();
        fdlAuthorizationPrefix.top = new FormAttachment((Control)lastControl, margin);
        fdlAuthorizationPrefix.left = new FormAttachment(0, 0);
        fdlAuthorizationPrefix.right = new FormAttachment(middle, -margin);
        wlAuthorizationPrefix.setLayoutData((Object)fdlAuthorizationPrefix);
        this.wAuthorizationPrefix = new TextVar(variables, composite, 18436);
        PropsUi.setLook((Widget)this.wAuthorizationPrefix);
        FormData fdAuthorizationPrefix = new FormData();
        fdAuthorizationPrefix.top = new FormAttachment((Control)wlAuthorizationPrefix, 0, 0x1000000);
        fdAuthorizationPrefix.left = new FormAttachment(middle, 0);
        fdAuthorizationPrefix.right = new FormAttachment(95, 0);
        this.wAuthorizationPrefix.setLayoutData((Object)fdAuthorizationPrefix);
        lastControl = this.wAuthorizationPrefix;
        Label wlAuthorizationValue = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlAuthorizationValue);
        wlAuthorizationValue.setText(BaseMessages.getString(PKG, (String)"RestConnectionEditor.AuthorizationValue", (String[])new String[0]));
        FormData fdlAuthorizationValue = new FormData();
        fdlAuthorizationValue.top = new FormAttachment((Control)lastControl, margin);
        fdlAuthorizationValue.left = new FormAttachment(0, 0);
        fdlAuthorizationValue.right = new FormAttachment(middle, -margin);
        wlAuthorizationValue.setLayoutData((Object)fdlAuthorizationValue);
        this.wAuthorizationValue = new PasswordTextVar(variables, composite, 18436);
        PropsUi.setLook((Widget)this.wAuthorizationValue);
        FormData fdAuthorizationValue = new FormData();
        fdAuthorizationValue.top = new FormAttachment((Control)wlAuthorizationValue, 0, 0x1000000);
        fdAuthorizationValue.left = new FormAttachment(middle, 0);
        fdAuthorizationValue.right = new FormAttachment(95, 0);
        this.wAuthorizationValue.setLayoutData((Object)fdAuthorizationValue);
        lastControl = this.wAuthorizationValue;
        this.setWidgetsContent();
        for (Control control : controls = new Control[]{this.wName, this.wAuthorizationName, this.wAuthorizationValue, this.wBaseUrl, this.wTestUrl}) {
            control.addListener(24, e -> this.setChanged());
            control.addListener(13, e -> this.setChanged());
        }
    }

    public Button[] createButtonsForButtonBar(Composite composite) {
        Button wTest = new Button(composite, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"System.Button.Test", (String[])new String[0]));
        wTest.addListener(13, e -> this.test());
        return new Button[]{wTest};
    }

    private void test() {
        IVariables variables = this.hopGui.getVariables();
        RestConnection restConnection = new RestConnection();
        restConnection.setName(this.wName.getText());
        if (StringUtils.isEmpty((String)this.wTestUrl.getText())) {
            restConnection.setTestUrl(this.wBaseUrl.getText());
        }
        restConnection.setBaseUrl(this.wBaseUrl.getText());
        restConnection.setTestUrl(this.wTestUrl.getText());
        restConnection.setAuthorizationHeaderName(this.wAuthorizationName.getText());
        restConnection.setAuthHeaderPrefix(this.wAuthorizationPrefix.getText());
        restConnection.setAuthorizationHeaderValue(this.wAuthorizationValue.getText());
        try {
            restConnection.testConnection();
            MessageBox box = new MessageBox(this.hopGui.getShell(), 32);
            box.setText("OK");
            String message = BaseMessages.getString(PKG, (String)"RestConnectionEditor.ConnectionTestSuccess", (String[])new String[0]) + Const.CR;
            message = message + Const.CR;
            message = message + "URL : " + this.wTestUrl.getText();
            box.setMessage(message);
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), "Error", "Error connecting to REST URL : " + this.wTestUrl.getText(), e);
        }
    }

    public void dispose() {
    }

    public void setWidgetsContent() {
        this.wName.setText(Const.NVL((String)((RestConnection)this.metadata).getName(), (String)""));
        this.wBaseUrl.setText(Const.NVL((String)((RestConnection)this.metadata).getBaseUrl(), (String)""));
        this.wTestUrl.setText(Const.NVL((String)((RestConnection)this.metadata).getTestUrl(), (String)""));
        this.wAuthorizationName.setText(Const.NVL((String)((RestConnection)this.metadata).getAuthorizationHeaderName(), (String)""));
        this.wAuthorizationPrefix.setText(Const.NVL((String)((RestConnection)this.metadata).getAuthHeaderPrefix(), (String)""));
        this.wAuthorizationValue.setText(Const.NVL((String)((RestConnection)this.metadata).getAuthorizationHeaderValue(), (String)""));
    }

    public void getWidgetsContent(RestConnection connection) {
        connection.setName(this.wName.getText());
        connection.setBaseUrl(this.wBaseUrl.getText());
        connection.setTestUrl(this.wTestUrl.getText());
        connection.setAuthorizationHeaderName(this.wAuthorizationName.getText());
        connection.setAuthHeaderPrefix(this.wAuthorizationPrefix.getText());
        connection.setAuthorizationHeaderValue(this.wAuthorizationValue.getText());
    }

    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }
}

