/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.functions.sink.filesystem.AbstractPartFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.CompactingFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputStreamBasedCompactingFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.WriterProperties;
import org.apache.flink.util.IOUtils;

public abstract class OutputStreamBasedPartFileWriter<IN, BucketID>
extends AbstractPartFileWriter<IN, BucketID>
implements OutputStreamBasedCompactingFileWriter {
    final RecoverableFsDataOutputStream currentPartStream;
    @Nullable
    final Path targetPath;
    private CompactingFileWriter.Type writeType = null;

    OutputStreamBasedPartFileWriter(BucketID bucketID, @Nullable Path path, RecoverableFsDataOutputStream recoverableFsDataOutputStream, long createTime) {
        super(bucketID, createTime);
        this.targetPath = path;
        this.currentPartStream = recoverableFsDataOutputStream;
    }

    @Override
    public InProgressFileWriter.InProgressFileRecoverable persist() throws IOException {
        return new OutputStreamBasedInProgressFileRecoverable(this.currentPartStream.persist(), this.targetPath);
    }

    @Override
    public InProgressFileWriter.PendingFileRecoverable closeForCommit() throws IOException {
        long size = this.currentPartStream.getPos();
        return new OutputStreamBasedPendingFileRecoverable(this.currentPartStream.closeForCommit().getRecoverable(), this.targetPath, size);
    }

    @Override
    public void dispose() {
        IOUtils.closeQuietly((AutoCloseable)this.currentPartStream);
    }

    @Override
    public long getSize() throws IOException {
        return this.currentPartStream.getPos();
    }

    @Override
    public OutputStream asOutputStream() throws IOException {
        this.ensureWriteType(CompactingFileWriter.Type.OUTPUT_STREAM);
        return this.currentPartStream;
    }

    protected void ensureWriteType(CompactingFileWriter.Type type) {
        if (type != this.writeType) {
            if (this.writeType == null) {
                this.writeType = type;
            } else {
                throw new IllegalStateException("Writer has already been opened as " + (Object)((Object)this.writeType) + " type, but trying to reopen it as " + (Object)((Object)type) + " type.");
            }
        }
    }

    public static class OutputStreamBasedPendingFileRecoverableSerializer
    implements SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable> {
        private static final int MAGIC_NUMBER = 746929289;
        private final SimpleVersionedSerializer<RecoverableWriter.CommitRecoverable> commitSerializer;

        OutputStreamBasedPendingFileRecoverableSerializer(SimpleVersionedSerializer<RecoverableWriter.CommitRecoverable> commitSerializer) {
            this.commitSerializer = commitSerializer;
        }

        public int getVersion() {
            return 2;
        }

        public byte[] serialize(InProgressFileWriter.PendingFileRecoverable pendingFileRecoverable) throws IOException {
            OutputStreamBasedPendingFileRecoverable outputStreamBasedPendingFileRecoverable = (OutputStreamBasedPendingFileRecoverable)pendingFileRecoverable;
            DataOutputSerializer dataOutputSerializer = new DataOutputSerializer(256);
            dataOutputSerializer.writeInt(746929289);
            this.serializeV2(outputStreamBasedPendingFileRecoverable, (DataOutputView)dataOutputSerializer);
            return dataOutputSerializer.getCopyOfBuffer();
        }

        public InProgressFileWriter.PendingFileRecoverable deserialize(int version, byte[] serialized) throws IOException {
            switch (version) {
                case 1: {
                    DataInputDeserializer in = new DataInputDeserializer(serialized);
                    OutputStreamBasedPendingFileRecoverableSerializer.validateMagicNumber((DataInputView)in);
                    return this.deserializeV1((DataInputView)in);
                }
                case 2: {
                    DataInputDeserializer in = new DataInputDeserializer(serialized);
                    OutputStreamBasedPendingFileRecoverableSerializer.validateMagicNumber((DataInputView)in);
                    return this.deserializeV2((DataInputView)in);
                }
            }
            throw new IOException("Unrecognized version or corrupt state: " + version);
        }

        public SimpleVersionedSerializer<RecoverableWriter.CommitRecoverable> getCommitSerializer() {
            return this.commitSerializer;
        }

        private void serializeV2(OutputStreamBasedPendingFileRecoverable outputStreamBasedPendingFileRecoverable, DataOutputView dataOutputView) throws IOException {
            boolean pathAvailable = outputStreamBasedPendingFileRecoverable.targetPath != null;
            dataOutputView.writeBoolean(pathAvailable);
            if (pathAvailable) {
                dataOutputView.writeUTF(outputStreamBasedPendingFileRecoverable.targetPath.toUri().toString());
            }
            dataOutputView.writeLong(outputStreamBasedPendingFileRecoverable.getSize());
            SimpleVersionedSerialization.writeVersionAndSerialize(this.commitSerializer, (Object)outputStreamBasedPendingFileRecoverable.getCommitRecoverable(), (DataOutputView)dataOutputView);
        }

        private OutputStreamBasedPendingFileRecoverable deserializeV1(DataInputView dataInputView) throws IOException {
            return new OutputStreamBasedPendingFileRecoverable((RecoverableWriter.CommitRecoverable)SimpleVersionedSerialization.readVersionAndDeSerialize(this.commitSerializer, (DataInputView)dataInputView));
        }

        private OutputStreamBasedPendingFileRecoverable deserializeV2(DataInputView dataInputView) throws IOException {
            Path path = null;
            if (dataInputView.readBoolean()) {
                path = new Path(dataInputView.readUTF());
            }
            long size = dataInputView.readLong();
            return new OutputStreamBasedPendingFileRecoverable((RecoverableWriter.CommitRecoverable)SimpleVersionedSerialization.readVersionAndDeSerialize(this.commitSerializer, (DataInputView)dataInputView), path, size);
        }

        private static void validateMagicNumber(DataInputView dataInputView) throws IOException {
            int magicNumber = dataInputView.readInt();
            if (magicNumber != 746929289) {
                throw new IOException(String.format("Corrupt data: Unexpected magic number %08X", magicNumber));
            }
        }
    }

    public static class OutputStreamBasedInProgressFileRecoverableSerializer
    implements SimpleVersionedSerializer<InProgressFileWriter.InProgressFileRecoverable> {
        private static final int MAGIC_NUMBER = -1281095875;
        private final SimpleVersionedSerializer<RecoverableWriter.ResumeRecoverable> resumeSerializer;

        OutputStreamBasedInProgressFileRecoverableSerializer(SimpleVersionedSerializer<RecoverableWriter.ResumeRecoverable> resumeSerializer) {
            this.resumeSerializer = resumeSerializer;
        }

        public int getVersion() {
            return 2;
        }

        public byte[] serialize(InProgressFileWriter.InProgressFileRecoverable inProgressRecoverable) throws IOException {
            OutputStreamBasedInProgressFileRecoverable outputStreamBasedInProgressRecoverable = (OutputStreamBasedInProgressFileRecoverable)inProgressRecoverable;
            DataOutputSerializer dataOutputSerializer = new DataOutputSerializer(256);
            dataOutputSerializer.writeInt(-1281095875);
            this.serializeV2(outputStreamBasedInProgressRecoverable, (DataOutputView)dataOutputSerializer);
            return dataOutputSerializer.getCopyOfBuffer();
        }

        public InProgressFileWriter.InProgressFileRecoverable deserialize(int version, byte[] serialized) throws IOException {
            switch (version) {
                case 1: {
                    DataInputDeserializer dataInputView = new DataInputDeserializer(serialized);
                    OutputStreamBasedInProgressFileRecoverableSerializer.validateMagicNumber((DataInputView)dataInputView);
                    return this.deserializeV1((DataInputView)dataInputView);
                }
                case 2: {
                    DataInputDeserializer dataInputView = new DataInputDeserializer(serialized);
                    OutputStreamBasedInProgressFileRecoverableSerializer.validateMagicNumber((DataInputView)dataInputView);
                    return this.deserializeV2((DataInputView)dataInputView);
                }
            }
            throw new IOException("Unrecognized version or corrupt state: " + version);
        }

        public SimpleVersionedSerializer<RecoverableWriter.ResumeRecoverable> getResumeSerializer() {
            return this.resumeSerializer;
        }

        private void serializeV2(OutputStreamBasedInProgressFileRecoverable outputStreamBasedInProgressRecoverable, DataOutputView dataOutputView) throws IOException {
            boolean pathAvailable = outputStreamBasedInProgressRecoverable.targetPath != null;
            dataOutputView.writeBoolean(pathAvailable);
            if (pathAvailable) {
                dataOutputView.writeUTF(outputStreamBasedInProgressRecoverable.targetPath.toUri().toString());
            }
            SimpleVersionedSerialization.writeVersionAndSerialize(this.resumeSerializer, (Object)outputStreamBasedInProgressRecoverable.getResumeRecoverable(), (DataOutputView)dataOutputView);
        }

        private OutputStreamBasedInProgressFileRecoverable deserializeV1(DataInputView dataInputView) throws IOException {
            return new OutputStreamBasedInProgressFileRecoverable((RecoverableWriter.ResumeRecoverable)SimpleVersionedSerialization.readVersionAndDeSerialize(this.resumeSerializer, (DataInputView)dataInputView));
        }

        private OutputStreamBasedInProgressFileRecoverable deserializeV2(DataInputView dataInputView) throws IOException {
            Path path = null;
            if (dataInputView.readBoolean()) {
                path = new Path(dataInputView.readUTF());
            }
            return new OutputStreamBasedInProgressFileRecoverable((RecoverableWriter.ResumeRecoverable)SimpleVersionedSerialization.readVersionAndDeSerialize(this.resumeSerializer, (DataInputView)dataInputView), path);
        }

        private static void validateMagicNumber(DataInputView dataInputView) throws IOException {
            int magicNumber = dataInputView.readInt();
            if (magicNumber != -1281095875) {
                throw new IOException(String.format("Corrupt data: Unexpected magic number %08X", magicNumber));
            }
        }
    }

    static final class OutputStreamBasedPendingFile
    implements BucketWriter.PendingFile {
        private final RecoverableFsDataOutputStream.Committer committer;

        OutputStreamBasedPendingFile(RecoverableFsDataOutputStream.Committer committer) {
            this.committer = committer;
        }

        @Override
        public void commit() throws IOException {
            this.committer.commit();
        }

        @Override
        public void commitAfterRecovery() throws IOException {
            this.committer.commitAfterRecovery();
        }
    }

    public static final class OutputStreamBasedInProgressFileRecoverable
    implements InProgressFileWriter.InProgressFileRecoverable {
        private final RecoverableWriter.ResumeRecoverable resumeRecoverable;
        @Nullable
        private final Path targetPath;

        @Deprecated
        public OutputStreamBasedInProgressFileRecoverable(RecoverableWriter.ResumeRecoverable resumeRecoverable) {
            this(resumeRecoverable, null);
        }

        public OutputStreamBasedInProgressFileRecoverable(RecoverableWriter.ResumeRecoverable resumeRecoverable, @Nullable Path targetPath) {
            this.resumeRecoverable = resumeRecoverable;
            this.targetPath = targetPath;
        }

        RecoverableWriter.ResumeRecoverable getResumeRecoverable() {
            return this.resumeRecoverable;
        }

        @Override
        public Path getPath() {
            return this.targetPath;
        }

        @Override
        public long getSize() {
            return -1L;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutputStreamBasedInProgressFileRecoverable that = (OutputStreamBasedInProgressFileRecoverable)o;
            return Objects.equals(this.resumeRecoverable, that.resumeRecoverable) && Objects.equals(this.targetPath, that.targetPath);
        }

        public int hashCode() {
            return Objects.hash(this.resumeRecoverable, this.targetPath);
        }
    }

    public static final class OutputStreamBasedPendingFileRecoverable
    implements InProgressFileWriter.PendingFileRecoverable {
        private final RecoverableWriter.CommitRecoverable commitRecoverable;
        @Nullable
        private final Path targetPath;
        private final long fileSize;

        @Deprecated
        public OutputStreamBasedPendingFileRecoverable(RecoverableWriter.CommitRecoverable commitRecoverable) {
            this(commitRecoverable, null, -1L);
        }

        public OutputStreamBasedPendingFileRecoverable(RecoverableWriter.CommitRecoverable commitRecoverable, @Nullable Path targetPath, long fileSize) {
            this.commitRecoverable = commitRecoverable;
            this.targetPath = targetPath;
            this.fileSize = fileSize;
        }

        RecoverableWriter.CommitRecoverable getCommitRecoverable() {
            return this.commitRecoverable;
        }

        @Override
        public Path getPath() {
            return this.targetPath;
        }

        @Override
        public long getSize() {
            return this.fileSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutputStreamBasedPendingFileRecoverable that = (OutputStreamBasedPendingFileRecoverable)o;
            return this.fileSize == that.fileSize && Objects.equals(this.commitRecoverable, that.commitRecoverable) && Objects.equals(this.targetPath, that.targetPath);
        }

        public int hashCode() {
            return Objects.hash(this.commitRecoverable, this.targetPath, this.fileSize);
        }
    }

    static abstract class OutputStreamBasedBucketWriter<IN, BucketID>
    implements BucketWriter<IN, BucketID> {
        private final RecoverableWriter recoverableWriter;

        OutputStreamBasedBucketWriter(RecoverableWriter recoverableWriter) {
            this.recoverableWriter = recoverableWriter;
        }

        @Override
        public InProgressFileWriter<IN, BucketID> openNewInProgressFile(BucketID bucketID, Path path, long creationTime) throws IOException {
            return this.openNew(bucketID, this.recoverableWriter.open(path), path, creationTime);
        }

        @Override
        public CompactingFileWriter openNewCompactingFile(CompactingFileWriter.Type type, BucketID bucketID, Path path, long creationTime) throws IOException {
            return this.openNewInProgressFile(bucketID, path, creationTime);
        }

        @Override
        public InProgressFileWriter<IN, BucketID> resumeInProgressFileFrom(BucketID bucketID, InProgressFileWriter.InProgressFileRecoverable inProgressFileRecoverable, long creationTime) throws IOException {
            OutputStreamBasedInProgressFileRecoverable outputStreamBasedInProgressRecoverable = (OutputStreamBasedInProgressFileRecoverable)inProgressFileRecoverable;
            return this.resumeFrom(bucketID, this.recoverableWriter.recover(outputStreamBasedInProgressRecoverable.getResumeRecoverable()), inProgressFileRecoverable.getPath(), outputStreamBasedInProgressRecoverable.getResumeRecoverable(), creationTime);
        }

        @Override
        public BucketWriter.PendingFile recoverPendingFile(InProgressFileWriter.PendingFileRecoverable pendingFileRecoverable) throws IOException {
            RecoverableWriter.CommitRecoverable commitRecoverable;
            if (pendingFileRecoverable instanceof OutputStreamBasedPendingFileRecoverable) {
                commitRecoverable = ((OutputStreamBasedPendingFileRecoverable)pendingFileRecoverable).getCommitRecoverable();
            } else if (pendingFileRecoverable instanceof OutputStreamBasedInProgressFileRecoverable) {
                commitRecoverable = ((OutputStreamBasedInProgressFileRecoverable)pendingFileRecoverable).getResumeRecoverable();
            } else {
                throw new IllegalArgumentException("can not recover from the pendingFileRecoverable");
            }
            return new OutputStreamBasedPendingFile(this.recoverableWriter.recoverForCommit(commitRecoverable));
        }

        @Override
        public boolean cleanupInProgressFileRecoverable(InProgressFileWriter.InProgressFileRecoverable inProgressFileRecoverable) throws IOException {
            RecoverableWriter.ResumeRecoverable resumeRecoverable = ((OutputStreamBasedInProgressFileRecoverable)inProgressFileRecoverable).getResumeRecoverable();
            return this.recoverableWriter.cleanupRecoverableState(resumeRecoverable);
        }

        @Override
        public WriterProperties getProperties() {
            return new WriterProperties(new OutputStreamBasedInProgressFileRecoverableSerializer((SimpleVersionedSerializer<RecoverableWriter.ResumeRecoverable>)this.recoverableWriter.getResumeRecoverableSerializer()), new OutputStreamBasedPendingFileRecoverableSerializer((SimpleVersionedSerializer<RecoverableWriter.CommitRecoverable>)this.recoverableWriter.getCommitRecoverableSerializer()), this.recoverableWriter.supportsResume());
        }

        public abstract InProgressFileWriter<IN, BucketID> openNew(BucketID var1, RecoverableFsDataOutputStream var2, Path var3, long var4) throws IOException;

        public abstract InProgressFileWriter<IN, BucketID> resumeFrom(BucketID var1, RecoverableFsDataOutputStream var2, Path var3, RecoverableWriter.ResumeRecoverable var4, long var5) throws IOException;
    }
}

