/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.function.Consumer;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.calledmethods.qual.EnsuresCalledMethodsIf;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CountingWritableByteChannel
implements WritableByteChannel {
    private final @UnknownKeyFor @NonNull @Initialized WritableByteChannel delegate;
    private final @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Integer> bytesWrittenConsumer;

    @VisibleForTesting
    public static @UnknownKeyFor @NonNull @Initialized CountingWritableByteChannel createWithNoOpConsumer(@UnknownKeyFor @NonNull @Initialized WritableByteChannel delegate) {
        return new CountingWritableByteChannel(delegate, __ -> {});
    }

    public CountingWritableByteChannel(@UnknownKeyFor @NonNull @Initialized WritableByteChannel delegate, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Integer> bytesWrittenConsumer) {
        this.delegate = (WritableByteChannel)Preconditions.checkNotNull((Object)delegate);
        this.bytesWrittenConsumer = (Consumer)Preconditions.checkNotNull(bytesWrittenConsumer);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int write(@UnknownKeyFor @NonNull @Initialized ByteBuffer src) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int bytesWritten = this.delegate.write(src);
        this.bytesWrittenConsumer.accept(bytesWritten);
        return bytesWritten;
    }

    @Override
    @EnsuresCalledMethodsIf(expression={"this"}, result=false, methods={"close"})
    public @UnknownKeyFor @NonNull @Initialized boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.delegate.close();
    }
}

