/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;

@Internal
public class WindowingStrategy<@UnknownKeyFor T, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_ALLOWED_LATENESS = Duration.ZERO;
    private static final @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized GlobalWindow> DEFAULT = WindowingStrategy.of(new GlobalWindows());
    private final @UnknownKeyFor @NonNull @Initialized WindowFn<T, W> windowFn;
    private final @UnknownKeyFor @NonNull @Initialized Trigger trigger;
    private final @UnknownKeyFor @NonNull @Initialized AccumulationMode mode;
    private final @UnknownKeyFor @NonNull @Initialized Duration allowedLateness;
    private final  @UnknownKeyFor @NonNull @Initialized Window.ClosingBehavior closingBehavior;
    private final  @UnknownKeyFor @NonNull @Initialized Window.OnTimeBehavior onTimeBehavior;
    private final @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner;
    private final @UnknownKeyFor @NonNull @Initialized String environmentId;
    private final @UnknownKeyFor @NonNull @Initialized boolean alreadyMerged;
    private final @UnknownKeyFor @NonNull @Initialized boolean triggerSpecified;
    private final @UnknownKeyFor @NonNull @Initialized boolean modeSpecified;
    private final @UnknownKeyFor @NonNull @Initialized boolean allowedLatenessSpecified;
    private final @UnknownKeyFor @NonNull @Initialized boolean timestampCombinerSpecified;

    private WindowingStrategy(@UnknownKeyFor @NonNull @Initialized WindowFn<T, W> windowFn, @UnknownKeyFor @NonNull @Initialized Trigger trigger, @UnknownKeyFor @NonNull @Initialized boolean triggerSpecified, @UnknownKeyFor @NonNull @Initialized AccumulationMode mode, @UnknownKeyFor @NonNull @Initialized boolean modeSpecified, @UnknownKeyFor @NonNull @Initialized Duration allowedLateness, @UnknownKeyFor @NonNull @Initialized boolean allowedLatenessSpecified, @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner, @UnknownKeyFor @NonNull @Initialized boolean timestampCombinerSpecified,  @UnknownKeyFor @NonNull @Initialized Window.ClosingBehavior closingBehavior,  @UnknownKeyFor @NonNull @Initialized Window.OnTimeBehavior onTimeBehavior, @UnknownKeyFor @NonNull @Initialized String environmentId, @UnknownKeyFor @NonNull @Initialized boolean alreadyMerged) {
        this.windowFn = windowFn;
        this.trigger = trigger;
        this.triggerSpecified = triggerSpecified;
        this.mode = mode;
        this.modeSpecified = modeSpecified;
        this.allowedLateness = allowedLateness;
        this.allowedLatenessSpecified = allowedLatenessSpecified;
        this.closingBehavior = closingBehavior;
        this.onTimeBehavior = onTimeBehavior;
        this.timestampCombiner = timestampCombiner;
        this.timestampCombinerSpecified = timestampCombinerSpecified;
        this.environmentId = environmentId;
        this.alreadyMerged = alreadyMerged;
    }

    public static @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized GlobalWindow> globalDefault() {
        return DEFAULT;
    }

    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized WindowingStrategy<T, W> of(@UnknownKeyFor @NonNull @Initialized WindowFn<T, W> windowFn) {
        return new WindowingStrategy<T, W>(windowFn, DefaultTrigger.of(), false, AccumulationMode.DISCARDING_FIRED_PANES, false, DEFAULT_ALLOWED_LATENESS, false, TimestampCombiner.END_OF_WINDOW, false, Window.ClosingBehavior.FIRE_IF_NON_EMPTY, Window.OnTimeBehavior.FIRE_ALWAYS, "", false);
    }

    public @UnknownKeyFor @NonNull @Initialized WindowFn<T, W> getWindowFn() {
        return this.windowFn;
    }

    public @UnknownKeyFor @NonNull @Initialized Trigger getTrigger() {
        return this.trigger;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isTriggerSpecified() {
        return this.triggerSpecified;
    }

    public @UnknownKeyFor @NonNull @Initialized Duration getAllowedLateness() {
        return this.allowedLateness;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isAllowedLatenessSpecified() {
        return this.allowedLatenessSpecified;
    }

    public @UnknownKeyFor @NonNull @Initialized AccumulationMode getMode() {
        return this.mode;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isModeSpecified() {
        return this.modeSpecified;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isAlreadyMerged() {
        return this.alreadyMerged;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean needsMerge() {
        return !this.getWindowFn().isNonMerging() && !this.isAlreadyMerged();
    }

    public  @UnknownKeyFor @NonNull @Initialized Window.ClosingBehavior getClosingBehavior() {
        return this.closingBehavior;
    }

    public  @UnknownKeyFor @NonNull @Initialized Window.OnTimeBehavior getOnTimeBehavior() {
        return this.onTimeBehavior;
    }

    public @UnknownKeyFor @NonNull @Initialized TimestampCombiner getTimestampCombiner() {
        return this.timestampCombiner;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isTimestampCombinerSpecified() {
        return this.timestampCombinerSpecified;
    }

    public @UnknownKeyFor @NonNull @Initialized String getEnvironmentId() {
        return this.environmentId;
    }

    public @UnknownKeyFor @NonNull @Initialized WindowingStrategy<T, W> withTrigger(@UnknownKeyFor @NonNull @Initialized Trigger trigger) {
        return new WindowingStrategy<T, W>(this.windowFn, trigger, true, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, this.timestampCombiner, this.timestampCombinerSpecified, this.closingBehavior, this.onTimeBehavior, this.environmentId, this.alreadyMerged);
    }

    public @UnknownKeyFor @NonNull @Initialized WindowingStrategy<T, W> withMode(@UnknownKeyFor @NonNull @Initialized AccumulationMode mode) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, mode, true, this.allowedLateness, this.allowedLatenessSpecified, this.timestampCombiner, this.timestampCombinerSpecified, this.closingBehavior, this.onTimeBehavior, this.environmentId, this.alreadyMerged);
    }

    public @UnknownKeyFor @NonNull @Initialized WindowingStrategy<T, W> withWindowFn(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> wildcardWindowFn) {
        WindowFn<?, ?> typedWindowFn = wildcardWindowFn;
        return new WindowingStrategy(typedWindowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, this.timestampCombiner, this.timestampCombinerSpecified, this.closingBehavior, this.onTimeBehavior, this.environmentId, this.alreadyMerged);
    }

    public @UnknownKeyFor @NonNull @Initialized WindowingStrategy<T, W> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, allowedLateness, true, this.timestampCombiner, this.timestampCombinerSpecified, this.closingBehavior, this.onTimeBehavior, this.environmentId, this.alreadyMerged);
    }

    public @UnknownKeyFor @NonNull @Initialized WindowingStrategy<T, W> withClosingBehavior( @UnknownKeyFor @NonNull @Initialized Window.ClosingBehavior closingBehavior) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, this.timestampCombiner, this.timestampCombinerSpecified, closingBehavior, this.onTimeBehavior, this.environmentId, this.alreadyMerged);
    }

    public @UnknownKeyFor @NonNull @Initialized WindowingStrategy<T, W> withOnTimeBehavior( @UnknownKeyFor @NonNull @Initialized Window.OnTimeBehavior onTimeBehavior) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, this.timestampCombiner, this.timestampCombinerSpecified, this.closingBehavior, onTimeBehavior, this.environmentId, this.alreadyMerged);
    }

    public @UnknownKeyFor @NonNull @Initialized WindowingStrategy<T, W> withTimestampCombiner(@UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, timestampCombiner, true, this.closingBehavior, this.onTimeBehavior, this.environmentId, this.alreadyMerged);
    }

    public @UnknownKeyFor @NonNull @Initialized WindowingStrategy<T, W> withEnvironmentId(@UnknownKeyFor @NonNull @Initialized String environmentId) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, this.timestampCombiner, this.timestampCombinerSpecified, this.closingBehavior, this.onTimeBehavior, environmentId, this.alreadyMerged);
    }

    public @UnknownKeyFor @NonNull @Initialized WindowingStrategy<T, W> withAlreadyMerged(@UnknownKeyFor @NonNull @Initialized boolean alreadyMerged) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, this.timestampCombiner, this.timestampCombinerSpecified, this.closingBehavior, this.onTimeBehavior, this.environmentId, alreadyMerged);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper(this).add("windowFn", this.windowFn).add("allowedLateness", this.allowedLateness).add("trigger", this.trigger).add("accumulationMode", (Object)this.mode).add("timestampCombiner", (Object)this.timestampCombiner).add("environmentId", this.environmentId).add("alreadyMerged", this.alreadyMerged).toString();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (!(object instanceof WindowingStrategy)) {
            return false;
        }
        WindowingStrategy other = (WindowingStrategy)object;
        return this.isAllowedLatenessSpecified() == other.isAllowedLatenessSpecified() && this.isModeSpecified() == other.isModeSpecified() && this.isTimestampCombinerSpecified() == other.isTimestampCombinerSpecified() && this.isAlreadyMerged() == other.isAlreadyMerged() && this.getMode().equals((Object)other.getMode()) && this.getAllowedLateness().equals((Object)other.getAllowedLateness()) && this.getClosingBehavior().equals((Object)other.getClosingBehavior()) && this.getOnTimeBehavior().equals((Object)other.getOnTimeBehavior()) && this.getTrigger().equals(other.getTrigger()) && this.getTimestampCombiner().equals((Object)other.getTimestampCombiner()) && this.getWindowFn().equals(other.getWindowFn()) && this.getEnvironmentId().equals(other.getEnvironmentId());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(new Object[]{this.allowedLatenessSpecified, this.modeSpecified, this.timestampCombinerSpecified, this.mode, this.allowedLateness, this.closingBehavior, this.trigger, this.timestampCombiner, this.windowFn, this.environmentId, this.alreadyMerged});
    }

    @VisibleForTesting
    public @UnknownKeyFor @NonNull @Initialized WindowingStrategy<T, W> fixDefaults() {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, true, this.mode, true, this.allowedLateness, true, this.timestampCombiner, true, this.closingBehavior, this.onTimeBehavior, this.environmentId, this.alreadyMerged);
    }

    public static enum AccumulationMode {
        DISCARDING_FIRED_PANES,
        ACCUMULATING_FIRED_PANES,
        RETRACTING_FIRED_PANES;

    }
}

