/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction.graph;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.util.construction.graph.ExecutableStage;
import org.apache.beam.sdk.util.construction.graph.QueryablePipeline;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GreedyPCollectionFusers {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(GreedyPCollectionFusers.class);
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FusibilityChecker> URN_FUSIBILITY_CHECKERS = ImmutableMap.builder().put("beam:transform:pardo:v1", GreedyPCollectionFusers::canFuseParDo).put("beam:transform:sdf_pair_with_restriction:v1", GreedyPCollectionFusers::canFuseParDo).put("beam:transform:sdf_process_keyed_elements:v1", GreedyPCollectionFusers::cannotFuse).put("beam:transform:sdf_process_elements:v1", GreedyPCollectionFusers::cannotFuse).put("beam:transform:sdf_split_and_size_restrictions:v1", GreedyPCollectionFusers::canFuseParDo).put("beam:transform:sdf_process_sized_element_and_restrictions:v1", GreedyPCollectionFusers::cannotFuse).put("beam:transform:combine_per_key_precombine:v1", GreedyPCollectionFusers::canFuseCompatibleEnvironment).put("beam:transform:combine_per_key_merge_accumulators:v1", GreedyPCollectionFusers::canFuseCompatibleEnvironment).put("beam:transform:combine_per_key_extract_outputs:v1", GreedyPCollectionFusers::canFuseCompatibleEnvironment).put("beam:transform:window_into:v1", GreedyPCollectionFusers::canFuseCompatibleEnvironment).put("beam:transform:flatten:v1", GreedyPCollectionFusers::canAlwaysFuse).put("beam:transform:group_by_key:v1", GreedyPCollectionFusers::cannotFuse).put("beam:transform:create_view:v1", GreedyPCollectionFusers::cannotFuse).build();
    private static final @UnknownKeyFor @NonNull @Initialized FusibilityChecker DEFAULT_FUSIBILITY_CHECKER = GreedyPCollectionFusers::unknownTransformFusion;
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CompatibilityChecker> URN_COMPATIBILITY_CHECKERS = ImmutableMap.builder().put("beam:transform:pardo:v1", GreedyPCollectionFusers::parDoCompatibility).put("beam:transform:sdf_pair_with_restriction:v1", GreedyPCollectionFusers::parDoCompatibility).put("beam:transform:sdf_split_and_size_restrictions:v1", GreedyPCollectionFusers::parDoCompatibility).put("beam:transform:sdf_process_sized_element_and_restrictions:v1", GreedyPCollectionFusers::parDoCompatibility).put("beam:transform:combine_per_key_precombine:v1", GreedyPCollectionFusers::compatibleEnvironments).put("beam:transform:combine_per_key_merge_accumulators:v1", GreedyPCollectionFusers::compatibleEnvironments).put("beam:transform:combine_per_key_extract_outputs:v1", GreedyPCollectionFusers::compatibleEnvironments).put("beam:transform:window_into:v1", GreedyPCollectionFusers::compatibleEnvironments).put("beam:transform:flatten:v1", GreedyPCollectionFusers::noCompatibility).put("beam:transform:group_by_key:v1", GreedyPCollectionFusers::noCompatibility).put("beam:transform:create_view:v1", GreedyPCollectionFusers::noCompatibility).build();
    private static final @UnknownKeyFor @NonNull @Initialized CompatibilityChecker DEFAULT_COMPATIBILITY_CHECKER = GreedyPCollectionFusers::unknownTransformCompatibility;

    GreedyPCollectionFusers() {
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean canFuse( @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode candidate, @UnknownKeyFor @NonNull @Initialized Collection< @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> stagePCollections, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline) {
        return URN_FUSIBILITY_CHECKERS.getOrDefault(transformNode.getTransform().getSpec().getUrn(), DEFAULT_FUSIBILITY_CHECKER).canFuse(transformNode, environment, candidate, stagePCollections, pipeline);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isCompatible( @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode left,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode right, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline) {
        CompatibilityChecker leftChecker = URN_COMPATIBILITY_CHECKERS.getOrDefault(left.getTransform().getSpec().getUrn(), DEFAULT_COMPATIBILITY_CHECKER);
        CompatibilityChecker rightChecker = URN_COMPATIBILITY_CHECKERS.getOrDefault(right.getTransform().getSpec().getUrn(), DEFAULT_COMPATIBILITY_CHECKER);
        return leftChecker.isCompatible(left, right, pipeline) && rightChecker.isCompatible(right, left, pipeline);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean canFuseParDo( @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode parDo, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode candidate, @UnknownKeyFor @NonNull @Initialized Collection< @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> stagePCollections, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline) {
        Optional<RunnerApi.Environment> env = pipeline.getEnvironment(parDo);
        Preconditions.checkArgument(env.isPresent(), "A %s must have an %s associated with it", (Object)RunnerApi.ParDoPayload.class.getSimpleName(), (Object)RunnerApi.Environment.class.getSimpleName());
        if (!env.get().equals((Object)environment)) {
            return false;
        }
        try {
            RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)parDo.getTransform().getSpec().getPayload());
            if (Maps.filterKeys(parDo.getTransform().getInputsMap(), s -> payload.getTimerFamilySpecsMap().containsKey(s)).values().contains(candidate.getId())) {
                return true;
            }
            if (payload.getStateSpecsCount() > 0 || payload.getTimerFamilySpecsCount() > 0) {
                return false;
            }
            if (!pipeline.getSideInputs(parDo).isEmpty()) {
                return false;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
        return true;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean parDoCompatibility( @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode parDo,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode other, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline) {
        return parDo.equals(other) || pipeline.getSideInputs(parDo).isEmpty() && pipeline.getUserStates(parDo).isEmpty() && pipeline.getTimers(parDo).isEmpty() && GreedyPCollectionFusers.compatibleEnvironments(parDo, other, pipeline);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean canFuseCompatibleEnvironment( @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode operation, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode candidate, @UnknownKeyFor @NonNull @Initialized Collection< @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> stagePCollections, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline) {
        Optional<RunnerApi.Environment> operationEnvironment = pipeline.getEnvironment(operation);
        return environment.equals(operationEnvironment.orElse(null));
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean compatibleEnvironments( @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode left,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode right, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline) {
        return pipeline.getEnvironment(left).equals(pipeline.getEnvironment(right));
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean canAlwaysFuse( @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode flatten, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode candidate, @UnknownKeyFor @NonNull @Initialized Collection< @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> stagePCollections, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline) {
        return true;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean cannotFuse( @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode cannotFuse, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode candidate, @UnknownKeyFor @NonNull @Initialized Collection< @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> stagePCollections, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline) {
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean noCompatibility( @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode self,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode other, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline) {
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean unknownTransformFusion( @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode candidate, @UnknownKeyFor @NonNull @Initialized Collection< @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> stagePCollections, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline) {
        LOG.debug("Unknown {} {} will not fuse into an existing {}", new Object[]{RunnerApi.PTransform.class.getSimpleName(), transform.getTransform(), ExecutableStage.class.getSimpleName()});
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean unknownTransformCompatibility( @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode other, @UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline) {
        LOG.debug("Unknown {} {} will not root a {} with other {}", new Object[]{RunnerApi.PTransform.class.getSimpleName(), transform.getTransform(), ExecutableStage.class.getSimpleName(), RunnerApi.PTransform.class.getSimpleName()});
        return false;
    }

    private static interface CompatibilityChecker {
        public @UnknownKeyFor @NonNull @Initialized boolean isCompatible( @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode var1,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode var2, @UnknownKeyFor @NonNull @Initialized QueryablePipeline var3);
    }

    private static interface FusibilityChecker {
        public @UnknownKeyFor @NonNull @Initialized boolean canFuse( @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode var1, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment var2,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode var3, @UnknownKeyFor @NonNull @Initialized Collection< @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> var4, @UnknownKeyFor @NonNull @Initialized QueryablePipeline var5);
    }
}

