/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.state;

import java.util.Objects;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.MapState;
import org.apache.beam.sdk.state.MultimapState;
import org.apache.beam.sdk.state.OrderedListState;
import org.apache.beam.sdk.state.SetState;
import org.apache.beam.sdk.state.StateBinder;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.state.WatermarkHoldState;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class StateSpecs {
    private static final @UnknownKeyFor @NonNull @Initialized CoderRegistry STANDARD_REGISTRY = CoderRegistry.createDefault();

    private StateSpecs() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<T>> value() {
        return new ValueStateSpec(null);
    }

    public static @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Row>> rowValue(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return StateSpecs.value(RowCoder.of(schema));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<T>> value(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
        Preconditions.checkArgument(valueCoder != null, "valueCoder should not be null. Consider value() instead");
        return new ValueStateSpec(valueCoder);
    }

    public static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> combining( @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        return new CombiningStateSpec(null, combineFn);
    }

    @Internal
    public static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> combining( @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
        return new CombiningWithContextStateSpec(null, combineFn);
    }

    public static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> combining(@UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder,  @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        Preconditions.checkArgument(accumCoder != null, "accumCoder should not be null. Consider using combining(CombineFn<> combineFn) instead.");
        return StateSpecs.combiningInternal(accumCoder, combineFn);
    }

    @Internal
    public static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> combining(@UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder,  @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
        return StateSpecs.combiningInternal(accumCoder, combineFn);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized BagState<T>> bag() {
        return new BagStateSpec(null);
    }

    public static @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized BagState<@UnknownKeyFor @NonNull @Initialized Row>> rowBag(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new BagStateSpec<Row>(RowCoder.of(schema));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized BagState<T>> bag(@UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
        return new BagStateSpec(elemCoder);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized SetState<T>> set() {
        return new SetStateSpec(null);
    }

    public static @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized SetState<@UnknownKeyFor @NonNull @Initialized Row>> rowSet(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new SetStateSpec<Row>(RowCoder.of(schema));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized SetState<T>> set(@UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
        return new SetStateSpec(elemCoder);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized MapState<K, V>> map() {
        return new MapStateSpec(null, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized MapState<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row>> rowMap(@UnknownKeyFor @NonNull @Initialized Schema keySchema, @UnknownKeyFor @NonNull @Initialized Schema valueSchema) {
        return new MapStateSpec<Row, Row>(RowCoder.of(keySchema), RowCoder.of(valueSchema));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized MapState<K, V>> map(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        return new MapStateSpec(keyCoder, valueCoder);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized OrderedListState<T>> orderedList(@UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
        return new OrderedListStateSpec(elemCoder);
    }

    public static @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized OrderedListState<@UnknownKeyFor @NonNull @Initialized Row>> rowOrderedList(@UnknownKeyFor @NonNull @Initialized Schema valueSchema) {
        return new OrderedListStateSpec<Row>(RowCoder.of(valueSchema));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized MultimapState<K, V>> multimap() {
        return new MultimapStateSpec(null, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized MultimapState<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row>> rowMultimap(@UnknownKeyFor @NonNull @Initialized Schema keySchema, @UnknownKeyFor @NonNull @Initialized Schema valueSchema) {
        return new MultimapStateSpec<Row, Row>(RowCoder.of(keySchema), RowCoder.of(valueSchema));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized MultimapState<K, V>> multimap(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        return new MultimapStateSpec(keyCoder, valueCoder);
    }

    @Internal
    public static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> combiningFromInputInternal(@UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder,  @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        try {
            Coder accumCoder = combineFn.getAccumulatorCoder(STANDARD_REGISTRY, (Coder)inputCoder);
            return StateSpecs.combiningInternal(accumCoder, combineFn);
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalArgumentException("Unable to determine accumulator coder for " + combineFn.getClass().getSimpleName() + " from " + inputCoder, e);
        }
    }

    private static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> combiningInternal(@UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder,  @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        return new CombiningStateSpec(accumCoder, combineFn);
    }

    private static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> combiningInternal(@UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder,  @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
        return new CombiningWithContextStateSpec(accumCoder, combineFn);
    }

    @Internal
    public static @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized WatermarkHoldState> watermarkStateInternal(@UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
        return new WatermarkStateSpecInternal(timestampCombiner);
    }

    @Internal
    public static <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized BagState<AccumT>> convertToBagSpecInternal(@UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> combiningSpec) {
        if (combiningSpec instanceof CombiningStateSpec) {
            CombiningStateSpec typedSpec = (CombiningStateSpec)combiningSpec;
            return typedSpec.asBagSpec();
        }
        if (combiningSpec instanceof CombiningWithContextStateSpec) {
            CombiningWithContextStateSpec typedSpec = (CombiningWithContextStateSpec)combiningSpec;
            return typedSpec.asBagSpec();
        }
        throw new IllegalArgumentException("Unexpected StateSpec " + combiningSpec);
    }

    @Internal
    public static <KeyT> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized MapState<KeyT, @UnknownKeyFor @NonNull @Initialized Boolean>> convertToMapSpecInternal(@UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized SetState<KeyT>> setStateSpec) {
        if (setStateSpec instanceof SetStateSpec) {
            SetStateSpec typedSpec = (SetStateSpec)setStateSpec;
            return typedSpec.asMapSpec();
        }
        throw new IllegalArgumentException("Unexpected StateSpec " + setStateSpec);
    }

    @Internal
    public static <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized MultimapState<KeyT, ValueT>> convertToMultimapSpecInternal(@UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized MapState<KeyT, ValueT>> spec) {
        if (spec instanceof MapStateSpec) {
            MapStateSpec typedSpec = (MapStateSpec)spec;
            return typedSpec.asMultimapSpec();
        }
        throw new IllegalArgumentException("Unexpected StateSpec " + spec);
    }

    private static class WatermarkStateSpecInternal
    implements StateSpec<WatermarkHoldState> {
        private final @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner;

        private WatermarkStateSpecInternal(@UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
            this.timestampCombiner = timestampCombiner;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WatermarkHoldState bind(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateBinder visitor) {
            return visitor.bindWatermark(id, this, this.timestampCombiner);
        }

        @Override
        public <ResultT> ResultT match(@UnknownKeyFor @NonNull @Initialized StateSpec.Cases<ResultT> cases) {
            throw new UnsupportedOperationException(String.format("%s is for internal use only and does not support case dispatch", this.getClass().getSimpleName()));
        }

        @Override
        public void offerCoders(@UnknownKeyFor @NonNull @Initialized Coder @UnknownKeyFor @NonNull @Initialized [] coders) {
        }

        @Override
        public void finishSpecifying() {
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof WatermarkStateSpecInternal;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getClass());
        }
    }

    private static class SetStateSpec<@UnknownKeyFor T>
    implements StateSpec<SetState<T>> {
        private @Nullable @UnknownKeyFor @Initialized Coder<T> elemCoder;

        private SetStateSpec(@Nullable @UnknownKeyFor @Initialized Coder<T> elemCoder) {
            this.elemCoder = elemCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized SetState<T> bind(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateBinder visitor) {
            return visitor.bindSet(id, this, this.elemCoder);
        }

        @Override
        public <ResultT> ResultT match(@UnknownKeyFor @NonNull @Initialized StateSpec.Cases<ResultT> cases) {
            return cases.dispatchSet(this.elemCoder);
        }

        @Override
        public void offerCoders(@UnknownKeyFor @NonNull @Initialized Coder @UnknownKeyFor @NonNull @Initialized [] coders) {
            if (this.elemCoder == null && coders[0] != null) {
                this.elemCoder = coders[0];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.elemCoder == null) {
                throw new IllegalStateException("Unable to infer a coder for SetState and no Coder was specified. Please set a coder by either invoking StateSpecs.set(Coder<T> elemCoder) or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SetStateSpec)) {
                return false;
            }
            SetStateSpec that = (SetStateSpec)obj;
            return Objects.equals(this.elemCoder, that.elemCoder);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getClass(), this.elemCoder);
        }

        private @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized MapState<T, @UnknownKeyFor @NonNull @Initialized Boolean>> asMapSpec() {
            return new MapStateSpec(this.elemCoder, BooleanCoder.of());
        }
    }

    private static class MultimapStateSpec<@UnknownKeyFor K, @UnknownKeyFor V>
    implements StateSpec<MultimapState<K, V>> {
        private @Nullable @UnknownKeyFor @Initialized Coder<K> keyCoder;
        private @Nullable @UnknownKeyFor @Initialized Coder<V> valueCoder;

        private MultimapStateSpec(@Nullable @UnknownKeyFor @Initialized Coder<K> keyCoder, @Nullable @UnknownKeyFor @Initialized Coder<V> valueCoder) {
            this.keyCoder = keyCoder;
            this.valueCoder = valueCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized MultimapState<K, V> bind(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateBinder visitor) {
            return visitor.bindMultimap(id, this, this.keyCoder, this.valueCoder);
        }

        @Override
        public <ResultT> ResultT match(@UnknownKeyFor @NonNull @Initialized StateSpec.Cases<ResultT> cases) {
            return cases.dispatchMultimap(this.keyCoder, this.valueCoder);
        }

        @Override
        public void offerCoders(@UnknownKeyFor @NonNull @Initialized Coder @UnknownKeyFor @NonNull @Initialized [] coders) {
            if (this.keyCoder == null && coders[0] != null) {
                this.keyCoder = coders[0];
            }
            if (this.valueCoder == null && coders[1] != null) {
                this.valueCoder = coders[1];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.keyCoder == null || this.valueCoder == null) {
                throw new IllegalStateException("Unable to infer a coder for MultimapState and no Coder was specified. Please set a coder by either invoking StateSpecs.multimap(Coder<K> keyCoder, Coder<V> valueCoder) or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MultimapStateSpec)) {
                return false;
            }
            MultimapStateSpec that = (MultimapStateSpec)obj;
            return Objects.equals(this.keyCoder, that.keyCoder) && Objects.equals(this.valueCoder, that.valueCoder);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getClass(), this.keyCoder, this.valueCoder);
        }
    }

    private static class MapStateSpec<@UnknownKeyFor K, @UnknownKeyFor V>
    implements StateSpec<MapState<K, V>> {
        private @Nullable @UnknownKeyFor @Initialized Coder<K> keyCoder;
        private @Nullable @UnknownKeyFor @Initialized Coder<V> valueCoder;

        private MapStateSpec(@Nullable @UnknownKeyFor @Initialized Coder<K> keyCoder, @Nullable @UnknownKeyFor @Initialized Coder<V> valueCoder) {
            this.keyCoder = keyCoder;
            this.valueCoder = valueCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized MapState<K, V> bind(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateBinder visitor) {
            return visitor.bindMap(id, this, this.keyCoder, this.valueCoder);
        }

        @Override
        public <ResultT> ResultT match(@UnknownKeyFor @NonNull @Initialized StateSpec.Cases<ResultT> cases) {
            return cases.dispatchMap(this.keyCoder, this.valueCoder);
        }

        @Override
        public void offerCoders(@UnknownKeyFor @NonNull @Initialized Coder @UnknownKeyFor @NonNull @Initialized [] coders) {
            if (this.keyCoder == null && coders[0] != null) {
                this.keyCoder = coders[0];
            }
            if (this.valueCoder == null && coders[1] != null) {
                this.valueCoder = coders[1];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.keyCoder == null || this.valueCoder == null) {
                throw new IllegalStateException("Unable to infer a coder for MapState and no Coder was specified. Please set a coder by either invoking StateSpecs.map(Coder<K> keyCoder, Coder<V> valueCoder) or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MapStateSpec)) {
                return false;
            }
            MapStateSpec that = (MapStateSpec)obj;
            return Objects.equals(this.keyCoder, that.keyCoder) && Objects.equals(this.valueCoder, that.valueCoder);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getClass(), this.keyCoder, this.valueCoder);
        }

        private @UnknownKeyFor @NonNull @Initialized MultimapStateSpec<K, V> asMultimapSpec() {
            return new MultimapStateSpec(this.keyCoder, this.valueCoder);
        }
    }

    private static class OrderedListStateSpec<@UnknownKeyFor T>
    implements StateSpec<OrderedListState<T>> {
        private @Nullable @UnknownKeyFor @Initialized Coder<T> elemCoder;

        private OrderedListStateSpec(@Nullable @UnknownKeyFor @Initialized Coder<T> elemCoder) {
            this.elemCoder = elemCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized OrderedListState<T> bind(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateBinder visitor) {
            return visitor.bindOrderedList(id, this, this.elemCoder);
        }

        @Override
        public <ResultT> ResultT match(@UnknownKeyFor @NonNull @Initialized StateSpec.Cases<ResultT> cases) {
            return cases.dispatchOrderedList(this.elemCoder);
        }

        @Override
        public void offerCoders(@UnknownKeyFor @NonNull @Initialized Coder @UnknownKeyFor @NonNull @Initialized [] coders) {
            if (this.elemCoder == null && coders[0] != null) {
                this.elemCoder = coders[0];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.elemCoder == null) {
                throw new IllegalStateException("Unable to infer a coder for OrderedListState and no Coder was specified. Please set a coder by either invoking StateSpecs.orderedListState(Coder<K> elemCoder), specifying a schema,  or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof OrderedListStateSpec)) {
                return false;
            }
            OrderedListStateSpec that = (OrderedListStateSpec)obj;
            return Objects.equals(this.elemCoder, that.elemCoder);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getClass(), this.elemCoder);
        }
    }

    private static class BagStateSpec<@UnknownKeyFor T>
    implements StateSpec<BagState<T>> {
        private @Nullable @UnknownKeyFor @Initialized Coder<T> elemCoder;

        private BagStateSpec(@Nullable @UnknownKeyFor @Initialized Coder<T> elemCoder) {
            this.elemCoder = elemCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BagState<T> bind(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateBinder visitor) {
            return visitor.bindBag(id, this, this.elemCoder);
        }

        @Override
        public <ResultT> ResultT match(@UnknownKeyFor @NonNull @Initialized StateSpec.Cases<ResultT> cases) {
            return cases.dispatchBag(this.elemCoder);
        }

        @Override
        public void offerCoders(@UnknownKeyFor @NonNull @Initialized Coder @UnknownKeyFor @NonNull @Initialized [] coders) {
            if (this.elemCoder == null && coders[0] != null) {
                this.elemCoder = coders[0];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.elemCoder == null) {
                throw new IllegalStateException("Unable to infer a coder for BagState and no Coder was specified. Please set a coder by either invoking StateSpecs.bag(Coder<T> elemCoder) or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BagStateSpec)) {
                return false;
            }
            BagStateSpec that = (BagStateSpec)obj;
            return Objects.equals(this.elemCoder, that.elemCoder);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getClass(), this.elemCoder);
        }
    }

    private static class CombiningWithContextStateSpec<@UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    implements StateSpec<CombiningState<InputT, AccumT, OutputT>> {
        private @Nullable @UnknownKeyFor @Initialized Coder<AccumT> accumCoder;
        private final  @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn;

        private CombiningWithContextStateSpec(@Nullable @UnknownKeyFor @Initialized Coder<AccumT> accumCoder,  @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
            this.combineFn = combineFn;
            this.accumCoder = accumCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> bind(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateBinder visitor) {
            return visitor.bindCombiningWithContext(id, this, this.accumCoder, this.combineFn);
        }

        @Override
        public <ResultT> ResultT match(@UnknownKeyFor @NonNull @Initialized StateSpec.Cases<ResultT> cases) {
            throw new UnsupportedOperationException(String.format("%s is for internal use only and does not support case dispatch", this.getClass().getSimpleName()));
        }

        @Override
        public void offerCoders(@UnknownKeyFor @NonNull @Initialized Coder @UnknownKeyFor @NonNull @Initialized [] coders) {
            if (this.accumCoder == null && coders[2] != null) {
                this.accumCoder = coders[2];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.accumCoder == null) {
                throw new IllegalStateException("Unable to infer a coder for CombiningWithContextState and no Coder was specified. Please set a coder by either invoking StateSpecs.combiningWithcontext(Coder<AccumT> accumCoder, CombineFnWithContext<InputT, AccumT, OutputT> combineFn) or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CombiningWithContextStateSpec)) {
                return false;
            }
            CombiningWithContextStateSpec that = (CombiningWithContextStateSpec)obj;
            return Objects.equals(this.accumCoder, that.accumCoder);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getClass(), this.accumCoder);
        }

        private @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized BagState<AccumT>> asBagSpec() {
            return new BagStateSpec(this.accumCoder);
        }
    }

    private static class CombiningStateSpec<@UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    implements StateSpec<CombiningState<InputT, AccumT, OutputT>> {
        private @Nullable @UnknownKeyFor @Initialized Coder<AccumT> accumCoder;
        private final  @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn;

        private CombiningStateSpec(@Nullable @UnknownKeyFor @Initialized Coder<AccumT> accumCoder,  @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            this.combineFn = combineFn;
            this.accumCoder = accumCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> bind(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateBinder visitor) {
            return visitor.bindCombining(id, this, this.accumCoder, this.combineFn);
        }

        @Override
        public <ResultT> ResultT match(@UnknownKeyFor @NonNull @Initialized StateSpec.Cases<ResultT> cases) {
            return cases.dispatchCombining(this.combineFn, this.accumCoder);
        }

        @Override
        public void offerCoders(@UnknownKeyFor @NonNull @Initialized Coder @UnknownKeyFor @NonNull @Initialized [] coders) {
            if (this.accumCoder == null && coders[1] != null) {
                this.accumCoder = coders[1];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.accumCoder == null) {
                throw new IllegalStateException("Unable to infer a coder for CombiningState and no Coder was specified. Please set a coder by either invoking StateSpecs.combining(Coder<AccumT> accumCoder, CombineFn<InputT, AccumT, OutputT> combineFn) or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CombiningStateSpec)) {
                return false;
            }
            CombiningStateSpec that = (CombiningStateSpec)obj;
            return Objects.equals(this.accumCoder, that.accumCoder);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getClass(), this.accumCoder);
        }

        private @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized BagState<AccumT>> asBagSpec() {
            return new BagStateSpec(this.accumCoder);
        }
    }

    private static class ValueStateSpec<@UnknownKeyFor T>
    implements StateSpec<ValueState<T>> {
        private @Nullable @UnknownKeyFor @Initialized Coder<T> coder;

        private ValueStateSpec(@Nullable @UnknownKeyFor @Initialized Coder<T> coder) {
            this.coder = coder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ValueState<T> bind(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateBinder visitor) {
            return visitor.bindValue(id, this, this.coder);
        }

        @Override
        public <ResultT> ResultT match(@UnknownKeyFor @NonNull @Initialized StateSpec.Cases<ResultT> cases) {
            return cases.dispatchValue(this.coder);
        }

        @Override
        public void offerCoders(@UnknownKeyFor @NonNull @Initialized Coder @UnknownKeyFor @NonNull @Initialized [] coders) {
            if (this.coder == null && coders[0] != null) {
                this.coder = coders[0];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.coder == null) {
                throw new IllegalStateException("Unable to infer a coder for ValueState and no Coder was specified. Please set a coder by either invoking StateSpecs.value(Coder<T> valueCoder) or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ValueStateSpec)) {
                return false;
            }
            ValueStateSpec that = (ValueStateSpec)obj;
            return Objects.equals(this.coder, that.coder);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getClass(), this.coder);
        }
    }
}

