/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.GetterBasedSchemaProviderV2;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.annotations.SchemaIgnore;
import org.apache.beam.sdk.schemas.utils.AutoValueUtils;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.JavaBeanUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class AutoValueSchema
extends GetterBasedSchemaProviderV2 {
    private static void validateFieldNumbers(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> types) {
        for (int i = 0; i < types.size(); ++i) {
            FieldValueTypeInformation type = types.get(i);
            Integer number = type.getNumber();
            if (number == null) {
                throw new RuntimeException("Unexpected null number for " + type.getName());
            }
            Preconditions.checkState(number == i, "Expected field number " + i + " for field + " + type.getName() + " instead got " + number);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter> fieldValueGetters(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return JavaBeanUtils.getGetters(targetTypeDescriptor, schema, AbstractGetterTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> fieldValueTypeInformations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return JavaBeanUtils.getFieldTypes(targetTypeDescriptor, schema, AbstractGetterTypeSupplier.INSTANCE);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator schemaTypeCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        Method annotated = ReflectUtils.getAnnotatedCreateMethod(targetTypeDescriptor.getRawType());
        if (annotated != null) {
            return JavaBeanUtils.getStaticCreator(targetTypeDescriptor, annotated, schema, AbstractGetterTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
        }
        SchemaUserTypeCreator creatorFactory = AutoValueUtils.getBuilderCreator(targetTypeDescriptor.getRawType(), schema, AbstractGetterTypeSupplier.INSTANCE);
        if (creatorFactory != null) {
            return creatorFactory;
        }
        creatorFactory = AutoValueUtils.getConstructorCreator(targetTypeDescriptor, schema, AbstractGetterTypeSupplier.INSTANCE);
        if (creatorFactory == null) {
            throw new RuntimeException("Could not find a way to create AutoValue class " + targetTypeDescriptor);
        }
        return creatorFactory;
    }

    @Override
    public <T> @Nullable @UnknownKeyFor @Initialized Schema schemaFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        return JavaBeanUtils.schemaFromJavaBeanClass(typeDescriptor, AbstractGetterTypeSupplier.INSTANCE);
    }

    @VisibleForTesting
    public static class AbstractGetterTypeSupplier
    implements FieldValueTypeSupplier {
        public static final @UnknownKeyFor @NonNull @Initialized AbstractGetterTypeSupplier INSTANCE = new AbstractGetterTypeSupplier();

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> get(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor) {
            TypeDescriptor<?> targetTypeDescriptor = AutoValueUtils.getBaseAutoValueClass(typeDescriptor);
            List methods = ReflectUtils.getMethods(targetTypeDescriptor.getRawType()).stream().filter(ReflectUtils::isGetter).filter(m -> Modifier.isAbstract(m.getModifiers())).filter(m -> !Modifier.isPrivate(m.getModifiers())).filter(m -> !Modifier.isProtected(m.getModifiers())).filter(m -> !m.isAnnotationPresent(SchemaIgnore.class)).collect(Collectors.toList());
            ArrayList<FieldValueTypeInformation> types = Lists.newArrayListWithCapacity(methods.size());
            for (int i = 0; i < methods.size(); ++i) {
                types.add(FieldValueTypeInformation.forGetter((Method)methods.get(i), i));
            }
            types.sort(Comparator.comparing(FieldValueTypeInformation::getNumber));
            AutoValueSchema.validateFieldNumbers(types);
            return types;
        }
    }
}

