/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.runners.core.ActiveWindowSet;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.SetCoder;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class MergingActiveWindowSet<@UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
implements ActiveWindowSet<W> {
    private final @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @NonNull @Initialized Object, W> windowFn;
    private final @UnknownKeyFor @NonNull @Initialized Map<W, @UnknownKeyFor @NonNull @Initialized Set<W>> activeWindowToStateAddressWindows;
    private final @UnknownKeyFor @NonNull @Initialized Map<W, @UnknownKeyFor @NonNull @Initialized Set<W>> originalActiveWindowToStateAddressWindows;
    private final @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Map<W, @UnknownKeyFor @NonNull @Initialized Set<W>>> valueState;

    public MergingActiveWindowSet(@UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @NonNull @Initialized Object, W> windowFn, @UnknownKeyFor @NonNull @Initialized StateInternals state) {
        this.windowFn = windowFn;
        StateTag tag = StateTags.makeSystemTagInternal(StateTags.value("tree", MapCoder.of(windowFn.windowCoder(), SetCoder.of(windowFn.windowCoder()))));
        this.valueState = state.state(StateNamespaces.global(), tag);
        this.activeWindowToStateAddressWindows = MergingActiveWindowSet.emptyIfNull(this.valueState.read());
        this.originalActiveWindowToStateAddressWindows = MergingActiveWindowSet.deepCopy(this.activeWindowToStateAddressWindows);
    }

    @Override
    public void cleanupTemporaryWindows() {
        this.activeWindowToStateAddressWindows.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty());
    }

    @Override
    public void persist() {
        this.checkInvariants();
        if (this.activeWindowToStateAddressWindows.isEmpty()) {
            this.valueState.clear();
            return;
        }
        if (this.activeWindowToStateAddressWindows.equals(this.originalActiveWindowToStateAddressWindows)) {
            return;
        }
        this.valueState.write(this.activeWindowToStateAddressWindows);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Set<W> getActiveAndNewWindows() {
        return this.activeWindowToStateAddressWindows.keySet();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isActive(W window) {
        Set<W> stateAddressWindows = this.activeWindowToStateAddressWindows.get(window);
        return stateAddressWindows != null && !stateAddressWindows.isEmpty();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isActiveOrNew(W window) {
        return this.activeWindowToStateAddressWindows.containsKey(window);
    }

    @Override
    public void ensureWindowExists(W window) {
        if (!this.activeWindowToStateAddressWindows.containsKey(window)) {
            this.activeWindowToStateAddressWindows.put(window, new LinkedHashSet());
        }
    }

    @Override
    public void ensureWindowIsActive(W window) {
        Set<W> stateAddressWindows = this.activeWindowToStateAddressWindows.get(window);
        Preconditions.checkState(stateAddressWindows != null, "Cannot ensure window %s is active since it is neither ACTIVE nor NEW", window);
        if (stateAddressWindows.isEmpty()) {
            stateAddressWindows.add(window);
        }
    }

    @Override
    @VisibleForTesting
    public void addActiveForTesting(W window) {
        if (!this.activeWindowToStateAddressWindows.containsKey(window)) {
            LinkedHashSet<W> stateAddressWindows = new LinkedHashSet<W>();
            stateAddressWindows.add(window);
            this.activeWindowToStateAddressWindows.put(window, stateAddressWindows);
        }
    }

    @VisibleForTesting
    public void addActiveForTesting(W window, @UnknownKeyFor @NonNull @Initialized Iterable<W> stateAddressWindows) {
        if (!this.activeWindowToStateAddressWindows.containsKey(window)) {
            this.activeWindowToStateAddressWindows.put(window, Sets.newLinkedHashSet(stateAddressWindows));
        }
    }

    @Override
    public void remove(W window) {
        this.activeWindowToStateAddressWindows.remove(window);
    }

    @Override
    public void merge(@UnknownKeyFor @NonNull @Initialized ActiveWindowSet.MergeCallback<W> mergeCallback) throws @UnknownKeyFor @NonNull @Initialized Exception {
        MergeContextImpl context = new MergeContextImpl(mergeCallback);
        this.windowFn.mergeWindows(context);
        context.recordMerges();
    }

    private void recordMerge(@UnknownKeyFor @NonNull @Initialized Collection<W> toBeMerged, W mergeResult) throws @UnknownKeyFor @NonNull @Initialized Exception {
        LinkedHashSet<Object> newStateAddressWindows = new LinkedHashSet<Object>();
        Set<W> existingStateAddressWindows = this.activeWindowToStateAddressWindows.get(mergeResult);
        if (existingStateAddressWindows != null) {
            newStateAddressWindows.addAll(existingStateAddressWindows);
        }
        for (BoundedWindow other : toBeMerged) {
            Set<W> otherStateAddressWindows = this.activeWindowToStateAddressWindows.get(other);
            Preconditions.checkState(otherStateAddressWindows != null, "Window %s is not ACTIVE or NEW", (Object)other);
            for (BoundedWindow otherStateAddressWindow : otherStateAddressWindows) {
                newStateAddressWindows.add(otherStateAddressWindow);
            }
            this.activeWindowToStateAddressWindows.remove(other);
        }
        if (newStateAddressWindows.isEmpty()) {
            newStateAddressWindows.add(mergeResult);
        }
        this.activeWindowToStateAddressWindows.put(mergeResult, newStateAddressWindows);
        this.merged(mergeResult);
    }

    @Override
    public void merged(W window) {
        Set<W> stateAddressWindows = this.activeWindowToStateAddressWindows.get(window);
        Preconditions.checkState(stateAddressWindows != null, "Window %s is not ACTIVE", window);
        BoundedWindow first = Iterables.getFirst(stateAddressWindows, null);
        stateAddressWindows.clear();
        stateAddressWindows.add(first);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Set<W> readStateAddresses(W window) {
        Set<W> stateAddressWindows = this.activeWindowToStateAddressWindows.get(window);
        Preconditions.checkState(stateAddressWindows != null, "Window %s is not ACTIVE", window);
        return stateAddressWindows;
    }

    @Override
    public W writeStateAddress(W window) {
        Set<W> stateAddressWindows = this.activeWindowToStateAddressWindows.get(window);
        Preconditions.checkState(stateAddressWindows != null, "Window %s is not ACTIVE", window);
        BoundedWindow result = Iterables.getFirst(stateAddressWindows, null);
        Preconditions.checkState(result != null, "Window %s is still NEW", window);
        return (W)result;
    }

    @Override
    public W mergedWriteStateAddress(@UnknownKeyFor @NonNull @Initialized Collection<W> toBeMerged, W mergeResult) {
        Set<W> stateAddressWindows = this.activeWindowToStateAddressWindows.get(mergeResult);
        if (stateAddressWindows != null && !stateAddressWindows.isEmpty()) {
            return (W)((BoundedWindow)Iterables.getFirst(stateAddressWindows, null));
        }
        for (BoundedWindow mergedWindow : toBeMerged) {
            stateAddressWindows = this.activeWindowToStateAddressWindows.get(mergedWindow);
            if (stateAddressWindows == null || stateAddressWindows.isEmpty()) continue;
            return (W)((BoundedWindow)Iterables.getFirst(stateAddressWindows, null));
        }
        return mergeResult;
    }

    @VisibleForTesting
    public void checkInvariants() {
        HashSet<BoundedWindow> knownStateAddressWindows = new HashSet<BoundedWindow>();
        for (Map.Entry<W, Set<W>> entry : this.activeWindowToStateAddressWindows.entrySet()) {
            BoundedWindow active = (BoundedWindow)entry.getKey();
            Preconditions.checkState(!entry.getValue().isEmpty(), "Unexpected empty state address window set for ACTIVE window %s", (Object)active);
            for (BoundedWindow stateAddressWindow : entry.getValue()) {
                Preconditions.checkState(knownStateAddressWindows.add(stateAddressWindow), "%s is in more than one state address window set", (Object)stateAddressWindow);
            }
        }
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MergingActiveWindowSet {\n");
        for (Map.Entry<W, Set<W>> entry : this.activeWindowToStateAddressWindows.entrySet()) {
            BoundedWindow active = (BoundedWindow)entry.getKey();
            Set<W> stateAddressWindows = entry.getValue();
            if (stateAddressWindows.isEmpty()) {
                sb.append("  NEW ");
                sb.append(active);
                sb.append('\n');
                continue;
            }
            sb.append("  ACTIVE ");
            sb.append(active);
            sb.append(":\n");
            for (BoundedWindow stateAddressWindow : stateAddressWindows) {
                sb.append("    ");
                sb.append(stateAddressWindow);
                sb.append("\n");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (!(o instanceof MergingActiveWindowSet)) {
            return false;
        }
        MergingActiveWindowSet other = (MergingActiveWindowSet)o;
        return this.activeWindowToStateAddressWindows.equals(other.activeWindowToStateAddressWindows);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hashCode(this.activeWindowToStateAddressWindows);
    }

    private static <W> @UnknownKeyFor @NonNull @Initialized Map<W, @UnknownKeyFor @NonNull @Initialized Set<W>> emptyIfNull(@Nullable @UnknownKeyFor @Initialized Map<W, @UnknownKeyFor @NonNull @Initialized Set<W>> multimap) {
        if (multimap == null) {
            return new HashMap();
        }
        for (Map.Entry<W, Set<W>> entry : multimap.entrySet()) {
            if (entry.getValue() != null) continue;
            entry.setValue(new LinkedHashSet());
        }
        return multimap;
    }

    private static <W> @UnknownKeyFor @NonNull @Initialized Map<W, @UnknownKeyFor @NonNull @Initialized Set<W>> deepCopy(@UnknownKeyFor @NonNull @Initialized Map<W, @UnknownKeyFor @NonNull @Initialized Set<W>> multimap) {
        HashMap newMultimap = new HashMap();
        for (Map.Entry<W, Set<W>> entry : multimap.entrySet()) {
            newMultimap.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
        }
        return newMultimap;
    }

    private class MergeContextImpl
    extends WindowFn.MergeContext {
        private @UnknownKeyFor @NonNull @Initialized ActiveWindowSet.MergeCallback<W> mergeCallback;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Collection<W>> allToBeMerged;
        private final @UnknownKeyFor @NonNull @Initialized List<W> allMergeResults;
        private final @UnknownKeyFor @NonNull @Initialized Set<W> seen;

        public MergeContextImpl(ActiveWindowSet.MergeCallback<W> mergeCallback) {
            super(MergingActiveWindowSet.this.windowFn);
            this.mergeCallback = mergeCallback;
            this.allToBeMerged = new ArrayList();
            this.allMergeResults = new ArrayList();
            this.seen = new HashSet();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Collection<W> windows() {
            return MergingActiveWindowSet.this.activeWindowToStateAddressWindows.keySet();
        }

        @Override
        public void merge(@UnknownKeyFor @NonNull @Initialized Collection<W> toBeMerged, W mergeResult) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Preconditions.checkNotNull(toBeMerged);
            Preconditions.checkNotNull(mergeResult);
            ArrayList<BoundedWindow> copyOfToBeMerged = new ArrayList<BoundedWindow>(toBeMerged.size());
            boolean includesMergeResult = false;
            for (BoundedWindow window : toBeMerged) {
                Preconditions.checkNotNull(window);
                Preconditions.checkState(MergingActiveWindowSet.this.isActiveOrNew(window), "Expecting merge window %s to be ACTIVE or NEW", (Object)window);
                if (window.equals(mergeResult)) {
                    includesMergeResult = true;
                }
                boolean notDup = this.seen.add(window);
                Preconditions.checkState(notDup, "Expecting merge window %s to appear in at most one merge set", (Object)window);
                copyOfToBeMerged.add(window);
            }
            if (!includesMergeResult) {
                Preconditions.checkState(!MergingActiveWindowSet.this.isActive(mergeResult), "Expecting result window %s to be NEW", mergeResult);
            }
            this.allToBeMerged.add(copyOfToBeMerged);
            this.allMergeResults.add(mergeResult);
        }

        public void recordMerges() throws @UnknownKeyFor @NonNull @Initialized Exception {
            int i;
            for (i = 0; i < this.allToBeMerged.size(); ++i) {
                this.mergeCallback.prefetchOnMerge(this.allToBeMerged.get(i), (BoundedWindow)this.allMergeResults.get(i));
            }
            for (i = 0; i < this.allToBeMerged.size(); ++i) {
                this.mergeCallback.onMerge(this.allToBeMerged.get(i), (BoundedWindow)this.allMergeResults.get(i));
                MergingActiveWindowSet.this.recordMerge(this.allToBeMerged.get(i), (BoundedWindow)this.allMergeResults.get(i));
            }
            this.allToBeMerged.clear();
            this.allMergeResults.clear();
            this.seen.clear();
        }
    }
}

