/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.azure.core.client.traits.AzureSasCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.ConnectionStringTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.util.BuilderHelper;
import com.azure.storage.blob.models.BlobContainerEncryptionScope;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.connectionstring.StorageAuthenticationSettings;
import com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.azure.storage.common.implementation.connectionstring.StorageEndpoint;
import com.azure.storage.common.policy.RequestRetryOptions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={BlobContainerClient.class, BlobContainerAsyncClient.class})
public final class BlobContainerClientBuilder
implements TokenCredentialTrait<BlobContainerClientBuilder>,
ConnectionStringTrait<BlobContainerClientBuilder>,
AzureSasCredentialTrait<BlobContainerClientBuilder>,
AzureNamedKeyCredentialTrait<BlobContainerClientBuilder>,
HttpTrait<BlobContainerClientBuilder>,
ConfigurationTrait<BlobContainerClientBuilder>,
EndpointTrait<BlobContainerClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(BlobContainerClientBuilder.class);
    private String endpoint;
    private String accountName;
    private String containerName;
    private CpkInfo customerProvidedKey;
    private EncryptionScope encryptionScope;
    private BlobContainerEncryptionScope blobContainerEncryptionScope;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private TokenCredential tokenCredential;
    private AzureSasCredential azureSasCredential;
    private String sasToken;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions;
    private RequestRetryOptions retryOptions;
    private RetryOptions coreRetryOptions;
    private HttpPipeline httpPipeline;
    private ClientOptions clientOptions = new ClientOptions();
    private Configuration configuration;
    private BlobServiceVersion version;

    public BlobContainerClientBuilder() {
        this.logOptions = BlobContainerClientBuilder.getDefaultHttpLogOptions();
    }

    public BlobContainerClient buildClient() {
        return new BlobContainerClient(this.buildAsyncClient());
    }

    public BlobContainerAsyncClient buildAsyncClient() {
        BuilderHelper.httpsValidation(this.customerProvidedKey, "customer provided key", this.endpoint, LOGGER);
        if (Objects.nonNull(this.customerProvidedKey) && Objects.nonNull(this.encryptionScope)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Customer provided key and encryption scope cannot both be set"));
        }
        String blobContainerName = CoreUtils.isNullOrEmpty((CharSequence)this.containerName) ? "$root" : this.containerName;
        BlobServiceVersion serviceVersion = this.version != null ? this.version : BlobServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.storageSharedKeyCredential, this.tokenCredential, this.azureSasCredential, this.sasToken, this.endpoint, this.retryOptions, this.coreRetryOptions, this.logOptions, this.clientOptions, this.httpClient, this.perCallPolicies, this.perRetryPolicies, this.configuration, LOGGER);
        return new BlobContainerAsyncClient(pipeline, this.endpoint, serviceVersion, this.accountName, blobContainerName, this.customerProvidedKey, this.encryptionScope, this.blobContainerEncryptionScope);
    }

    public BlobContainerClientBuilder endpoint(String endpoint) {
        try {
            URL url = new URL(endpoint);
            BlobUrlParts parts = BlobUrlParts.parse(url);
            this.accountName = parts.getAccountName();
            this.containerName = parts.getBlobContainerName() == null ? this.containerName : parts.getBlobContainerName();
            this.endpoint = BuilderHelper.getEndpoint(parts);
            String sasToken = parts.getCommonSasQueryParameters().encode();
            if (!CoreUtils.isNullOrEmpty((CharSequence)sasToken)) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Storage Blob endpoint url is malformed.", ex));
        }
        return this;
    }

    public BlobContainerClientBuilder customerProvidedKey(CustomerProvidedKey customerProvidedKey) {
        this.customerProvidedKey = customerProvidedKey == null ? null : new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        return this;
    }

    public BlobContainerClientBuilder encryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope == null ? null : new EncryptionScope().setEncryptionScope(encryptionScope);
        return this;
    }

    public BlobContainerClientBuilder blobContainerEncryptionScope(BlobContainerEncryptionScope blobContainerEncryptionScope) {
        this.blobContainerEncryptionScope = blobContainerEncryptionScope;
        return this;
    }

    public BlobContainerClientBuilder credential(StorageSharedKeyCredential credential) {
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = null;
        this.sasToken = null;
        return this;
    }

    public BlobContainerClientBuilder credential(AzureNamedKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this.credential(StorageSharedKeyCredential.fromAzureNamedKeyCredential((AzureNamedKeyCredential)credential));
    }

    public BlobContainerClientBuilder credential(TokenCredential credential) {
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.sasToken = null;
        return this;
    }

    public BlobContainerClientBuilder sasToken(String sasToken) {
        this.sasToken = Objects.requireNonNull(sasToken, "'sasToken' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    public BlobContainerClientBuilder credential(AzureSasCredential credential) {
        this.azureSasCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public BlobContainerClientBuilder setAnonymousAccess() {
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        this.azureSasCredential = null;
        this.sasToken = null;
        return this;
    }

    public BlobContainerClientBuilder connectionString(String connectionString) {
        StorageAuthenticationSettings authSettings;
        StorageConnectionString storageConnectionString = StorageConnectionString.create((String)connectionString, (ClientLogger)LOGGER);
        StorageEndpoint endpoint = storageConnectionString.getBlobEndpoint();
        if (endpoint == null || endpoint.getPrimaryUri() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("connectionString missing required settings to derive blob service endpoint."));
        }
        this.endpoint(endpoint.getPrimaryUri());
        if (storageConnectionString.getAccountName() != null) {
            this.accountName = storageConnectionString.getAccountName();
        }
        if ((authSettings = storageConnectionString.getStorageAuthSettings()).getType() == StorageAuthenticationSettings.Type.ACCOUNT_NAME_KEY) {
            this.credential(new StorageSharedKeyCredential(authSettings.getAccount().getName(), authSettings.getAccount().getAccessKey()));
        } else if (authSettings.getType() == StorageAuthenticationSettings.Type.SAS_TOKEN) {
            this.sasToken(authSettings.getSasToken());
        }
        return this;
    }

    public BlobContainerClientBuilder containerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public BlobContainerClientBuilder httpClient(HttpClient httpClient) {
        if (this.httpClient != null && httpClient == null) {
            LOGGER.info("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    public BlobContainerClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null");
        if (pipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(pipelinePolicy);
        } else {
            this.perRetryPolicies.add(pipelinePolicy);
        }
        return this;
    }

    public BlobContainerClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    public BlobContainerClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public BlobContainerClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public BlobContainerClientBuilder retryOptions(RetryOptions retryOptions) {
        this.coreRetryOptions = retryOptions;
        return this;
    }

    public BlobContainerClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = Objects.requireNonNull(clientOptions, "'clientOptions' cannot be null.");
        return this;
    }

    public BlobContainerClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            LOGGER.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public BlobContainerClientBuilder serviceVersion(BlobServiceVersion version) {
        this.version = version;
        return this;
    }
}

