/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google.auto.common;

import autovalue.shaded.com.google.auto.common.MoreTypes;
import autovalue.shaded.com.google.common.collect.ImmutableMap;
import autovalue.shaded.com.google.common.collect.Iterables;
import autovalue.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

final class AnnotationOutput {
    private static final AnnotationValueVisitor<AnnotationValue, AnnotationValue> ARRAY_VISITOR = new SimpleAnnotationValueVisitor8<AnnotationValue, AnnotationValue>(){

        @Override
        public AnnotationValue visitArray(List<? extends AnnotationValue> values, AnnotationValue input) {
            if (values.size() == 1) {
                return Iterables.getOnlyElement(values);
            }
            return input;
        }

        @Override
        protected AnnotationValue defaultAction(Object o, AnnotationValue input) {
            return input;
        }
    };

    private AnnotationOutput() {
    }

    private static AnnotationValue maybeShorten(AnnotationValue value) {
        return ARRAY_VISITOR.visit(value, value);
    }

    private static Optional<AnnotationValue> shortForm(Map<ExecutableElement, AnnotationValue> values) {
        if (values.size() == 1 && Iterables.getOnlyElement(values.keySet()).getSimpleName().contentEquals("value")) {
            return Optional.of(Iterables.getOnlyElement(values.values()));
        }
        return Optional.empty();
    }

    static String toString(AnnotationValue annotationValue) {
        StringBuilder sb = new StringBuilder();
        new SourceFormVisitor().visit(annotationValue, sb);
        return sb.toString();
    }

    static String toString(AnnotationMirror annotationMirror) {
        StringBuilder sb = new StringBuilder();
        new SourceFormVisitor().visitAnnotation(annotationMirror, sb);
        return sb.toString();
    }

    private static StringBuilder appendQuoted(StringBuilder sb, String s) {
        sb.append('\"');
        for (int i = 0; i < s.length(); ++i) {
            AnnotationOutput.appendEscaped(sb, s.charAt(i));
        }
        return sb.append('\"');
    }

    private static StringBuilder appendQuoted(StringBuilder sb, char c) {
        sb.append('\'');
        AnnotationOutput.appendEscaped(sb, c);
        return sb.append('\'');
    }

    private static void appendEscaped(StringBuilder sb, char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '\\': {
                sb.append('\\').append(c);
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            default: {
                if (c < ' ') {
                    sb.append(String.format("\\%03o", c));
                    break;
                }
                if (c < '\u007f' || Character.isLetter(c)) {
                    sb.append(c);
                    break;
                }
                sb.append(String.format("\\u%04x", c));
            }
        }
    }

    private static class SourceFormVisitor
    extends SimpleAnnotationValueVisitor8<Void, StringBuilder> {
        private SourceFormVisitor() {
        }

        private String formatType(TypeMirror typeMirror) {
            return MoreTypes.asTypeElement(typeMirror).getQualifiedName().toString();
        }

        @Override
        protected @Nullable Void defaultAction(Object value, StringBuilder sb) {
            sb.append(value);
            return null;
        }

        @Override
        public @Nullable Void visitArray(List<? extends AnnotationValue> values, StringBuilder sb) {
            sb.append('{');
            String sep = "";
            for (AnnotationValue annotationValue : values) {
                sb.append(sep);
                this.visit(annotationValue, sb);
                sep = ", ";
            }
            sb.append('}');
            return null;
        }

        @Override
        public @Nullable Void visitByte(byte b, StringBuilder sb) {
            sb.append("(byte) ").append(b);
            return null;
        }

        @Override
        public @Nullable Void visitShort(short s, StringBuilder sb) {
            sb.append("(short) ").append(s);
            return null;
        }

        @Override
        public @Nullable Void visitChar(char c, StringBuilder sb) {
            AnnotationOutput.appendQuoted(sb, c);
            return null;
        }

        @Override
        public @Nullable Void visitLong(long i, StringBuilder sb) {
            sb.append(i).append('L');
            return null;
        }

        @Override
        public @Nullable Void visitDouble(double d, StringBuilder sb) {
            if (Double.isNaN(d)) {
                sb.append("Double.NaN");
            } else if (d == Double.POSITIVE_INFINITY) {
                sb.append("Double.POSITIVE_INFINITY");
            } else if (d == Double.NEGATIVE_INFINITY) {
                sb.append("Double.NEGATIVE_INFINITY");
            } else {
                sb.append(d);
            }
            return null;
        }

        @Override
        public @Nullable Void visitFloat(float f, StringBuilder sb) {
            if (Float.isNaN(f)) {
                sb.append("Float.NaN");
            } else if (f == Float.POSITIVE_INFINITY) {
                sb.append("Float.POSITIVE_INFINITY");
            } else if (f == Float.NEGATIVE_INFINITY) {
                sb.append("Float.NEGATIVE_INFINITY");
            } else {
                sb.append(f).append('F');
            }
            return null;
        }

        @Override
        public @Nullable Void visitEnumConstant(VariableElement c, StringBuilder sb) {
            sb.append(this.formatType(c.asType())).append('.').append(c.getSimpleName());
            return null;
        }

        @Override
        public @Nullable Void visitString(String s, StringBuilder sb) {
            AnnotationOutput.appendQuoted(sb, s);
            return null;
        }

        @Override
        public @Nullable Void visitType(TypeMirror classConstant, StringBuilder sb) {
            sb.append(this.formatType(classConstant)).append(".class");
            return null;
        }

        @Override
        public @Nullable Void visitAnnotation(AnnotationMirror a, StringBuilder sb) {
            sb.append('@').append(this.formatType(a.getAnnotationType()));
            ImmutableMap<? extends ExecutableElement, ? extends AnnotationValue> map = ImmutableMap.copyOf(a.getElementValues());
            if (!map.isEmpty()) {
                sb.append('(');
                Optional shortForm = AnnotationOutput.shortForm(map);
                if (shortForm.isPresent()) {
                    this.visit(AnnotationOutput.maybeShorten((AnnotationValue)shortForm.get()), sb);
                } else {
                    String sep = "";
                    for (Map.Entry entry : map.entrySet()) {
                        sb.append(sep).append(((ExecutableElement)entry.getKey()).getSimpleName()).append(" = ");
                        sep = ", ";
                        this.visit(AnnotationOutput.maybeShorten((AnnotationValue)entry.getValue()), sb);
                    }
                }
                sb.append(')');
            }
            return null;
        }
    }
}

