/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.waitforsql;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;

@Action(id="WAIT_FOR_SQL", name="i18n::ActionWaitForSQL.Name", description="i18n::ActionWaitForSQL.Description", image="WaitForSQL.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", keywords={"i18n::ActionWaitForSql.keyword"}, documentationUrl="/workflow/actions/waitforsql.html")
public class ActionWaitForSql
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionWaitForSql.class;
    @HopMetadataProperty(key="clear_result_rows")
    private boolean clearResultList = true;
    @HopMetadataProperty(key="add_rows_result")
    private boolean addRowsResult = false;
    @HopMetadataProperty(key="is_usevars")
    private boolean useVars = false;
    @HopMetadataProperty(key="is_custom_sql")
    private boolean customSqlEnabled = false;
    @HopMetadataProperty(key="custom_sql")
    private String customSql = null;
    @HopMetadataProperty(key="connection")
    private String connection = null;
    @HopMetadataProperty(key="tablename")
    private String tableName = null;
    @HopMetadataProperty(key="schemaname")
    private String schemaName = null;
    @HopMetadataProperty(key="maximum_timeout")
    private String maximumTimeout = "0";
    @HopMetadataProperty(key="check_cycle_time")
    private String checkCycleTime = "60";
    @HopMetadataProperty(key="success_on_timeout")
    private boolean successOnTimeout = false;
    @HopMetadataProperty(key="rows_count_value")
    private String rowsCountValue = "0";
    @HopMetadataProperty(key="success_condition", storeWithCode=true)
    private SuccessCondition successCondition = SuccessCondition.ROWS_COUNT_GREATER;
    private static final String SELECT_COUNT = "SELECT count(*) FROM ";
    public static final int SUCCESS_CONDITION_ROWS_COUNT_EQUAL = 0;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_DIFFERENT = 1;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_SMALLER = 2;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_SMALLER_EQUAL = 3;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_GREATER = 4;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_GREATER_EQUAL = 5;
    private static final String DEFAULT_MAXIMUM_TIMEOUT = "0";
    private static final String DEFAULT_CHECK_CYCLE_TIME = "60";

    public ActionWaitForSql(String n) {
        super(n, "");
    }

    public ActionWaitForSql() {
        this("");
    }

    public Object clone() {
        return super.clone();
    }

    public SuccessCondition getSuccessCondition() {
        return this.successCondition;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    protected void checkConnection() throws HopDatabaseException {
        try {
            DatabaseMeta databaseMeta = this.parentWorkflowMeta.findDatabase(this.connection, this.getVariables());
            try (Database database = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);){
                database.connect();
            }
        }
        catch (HopException e) {
            throw new HopDatabaseException(e.getMessage(), (Throwable)e);
        }
    }

    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        result.setNrErrors(1L);
        String realCustomSql = null;
        String realTablename = this.resolve(this.tableName);
        String realSchemaname = this.resolve(this.schemaName);
        if (this.connection == null) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.NoDbConnection", (String[])new String[0]));
            return result;
        }
        if (this.customSqlEnabled) {
            if (this.clearResultList) {
                result.getRows().clear();
            }
            realCustomSql = this.customSql;
            if (this.useVars) {
                realCustomSql = this.resolve(realCustomSql);
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Log.EnteredCustomSQL", (String[])new String[]{realCustomSql}));
            }
            if (Utils.isEmpty((CharSequence)realCustomSql)) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Error.NoCustomSQL", (String[])new String[0]));
                return result;
            }
        } else if (Utils.isEmpty((CharSequence)realTablename)) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Error.NoTableName", (String[])new String[0]));
            return result;
        }
        try {
            this.checkConnection();
            long timeStart = System.currentTimeMillis() / 1000L;
            int nrRowsLimit = Const.toInt((String)this.resolve(this.rowsCountValue), (int)0);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Log.nrRowsLimit", (String[])new String[]{"" + nrRowsLimit}));
            }
            long iMaximumTimeout = Const.toInt((String)this.resolve(this.maximumTimeout), (int)Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0));
            long iCycleTime = Const.toInt((String)this.resolve(this.checkCycleTime), (int)Const.toInt((String)DEFAULT_CHECK_CYCLE_TIME, (int)0));
            if (iMaximumTimeout < 0L) {
                iMaximumTimeout = Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0);
                this.logBasic("Maximum timeout invalid, reset to " + iMaximumTimeout);
            }
            if (iCycleTime < 1L) {
                iCycleTime = Const.toInt((String)DEFAULT_CHECK_CYCLE_TIME, (int)1);
                this.logBasic("Check cycle time invalid, reset to " + iCycleTime);
            }
            if (iMaximumTimeout == 0L) {
                this.logBasic("Waiting indefinitely for SQL data");
            } else {
                this.logBasic("Waiting " + iMaximumTimeout + " seconds for SQL data");
            }
            boolean continueLoop = true;
            while (continueLoop && !this.parentWorkflow.isStopped()) {
                if (this.sqlDataOK(result, nrRowsLimit, realSchemaname, realTablename, realCustomSql)) {
                    this.logBasic("Detected SQL data within timeout");
                    result.setResult(true);
                    continueLoop = false;
                    continue;
                }
                long now = System.currentTimeMillis() / 1000L;
                if (iMaximumTimeout > 0L && now > timeStart + iMaximumTimeout) {
                    continueLoop = false;
                    if (this.isSuccessOnTimeout()) {
                        this.logBasic("Didn't detect SQL data before timeout, success");
                        result.setResult(true);
                    } else {
                        this.logBasic("Didn't detect SQL data before timeout, failure");
                        result.setResult(false);
                    }
                }
                long sleepTime = 0L;
                sleepTime = iMaximumTimeout == 0L ? iCycleTime : (now + iCycleTime < timeStart + iMaximumTimeout ? iCycleTime : iCycleTime - (now + iCycleTime - (timeStart + iMaximumTimeout)));
                try {
                    if (sleepTime <= 0L) continue;
                    if (this.log.isDetailed()) {
                        this.logDetailed("Sleeping " + sleepTime + " seconds before next check for SQL data");
                    }
                    Thread.sleep(sleepTime * 1000L);
                }
                catch (InterruptedException e) {
                    result.setResult(false);
                    continueLoop = false;
                }
            }
        }
        catch (Exception e) {
            this.logBasic("Exception while waiting for SQL data: " + e.getMessage());
        }
        if (result.getResult()) {
            result.setNrErrors(0L);
        }
        return result;
    }

    protected boolean sqlDataOK(Result result, long nrRowsLimit, String realSchemaName, String realTableName, String customSql) throws HopException {
        Object countStatement = null;
        long rowsCount = 0L;
        boolean successOK = false;
        List ar = null;
        IRowMeta rowMeta = null;
        DatabaseMeta databaseMeta = this.parentWorkflowMeta.findDatabase(this.connection, this.getVariables());
        try (Database db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);){
            db.connect();
            countStatement = this.customSqlEnabled ? customSql : (!Utils.isEmpty((CharSequence)realSchemaName) ? SELECT_COUNT + db.getDatabaseMeta().getQuotedSchemaTableCombination((IVariables)this, realSchemaName, realTableName) : SELECT_COUNT + db.getDatabaseMeta().quoteField(realTableName));
            if (countStatement != null) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Log.RunSQLStatement", (String[])new String[]{countStatement}));
                }
                if (this.customSqlEnabled) {
                    ar = db.getRows((String)countStatement, 0);
                    if (ar != null) {
                        rowsCount = ar.size();
                    } else if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Log.customSQLreturnedNothing", (String[])new String[]{countStatement}));
                    }
                } else {
                    RowMetaAndData row = db.getOneRow((String)countStatement);
                    if (row != null) {
                        rowsCount = row.getInteger(0);
                    }
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Log.NrRowsReturned", (String[])new String[]{"" + rowsCount}));
                }
                switch (this.successCondition) {
                    case ROWS_COUNT_EQUAL: {
                        successOK = rowsCount == nrRowsLimit;
                        break;
                    }
                    case ROWS_COUNT_DIFFERENT: {
                        successOK = rowsCount != nrRowsLimit;
                        break;
                    }
                    case ROWS_COUNT_SMALLER: {
                        successOK = rowsCount < nrRowsLimit;
                        break;
                    }
                    case ROWS_COUNT_SMALLER_EQUAL: {
                        successOK = rowsCount <= nrRowsLimit;
                        break;
                    }
                    case ROWS_COUNT_GREATER: {
                        successOK = rowsCount > nrRowsLimit;
                        break;
                    }
                    case ROWS_COUNT_GREATER_EQUAL: {
                        successOK = rowsCount >= nrRowsLimit;
                        break;
                    }
                }
            }
            if (this.addRowsResult && this.customSqlEnabled && ar != null) {
                rowMeta = db.getQueryFields((String)countStatement, false);
            }
        }
        catch (HopDatabaseException dbe) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Error.RunningEntry", (String[])new String[]{dbe.getMessage()}));
        }
        if (successOK && this.addRowsResult && this.customSqlEnabled && ar != null) {
            ArrayList<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
            for (int i = 0; i < ar.size(); ++i) {
                rows.add(new RowMetaAndData(rowMeta, (Object[])ar.get(i)));
            }
            if (rows != null) {
                result.getRows().addAll(rows);
            }
        }
        return successOK;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        DatabaseMeta databaseMeta = null;
        try {
            IHopMetadataProvider metadataProvider = workflowMeta.getMetadataProvider();
            databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
        }
        catch (HopException metadataProvider) {
            // empty catch block
        }
        if (databaseMeta != null) {
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(databaseMeta.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(databaseMeta.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "WaitForSQL", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    public boolean isClearResultList() {
        return this.clearResultList;
    }

    public void setClearResultList(boolean isClearResultList) {
        this.clearResultList = isClearResultList;
    }

    public boolean isAddRowsResult() {
        return this.addRowsResult;
    }

    public void setAddRowsResult(boolean isAddRowsResult) {
        this.addRowsResult = isAddRowsResult;
    }

    public boolean isUseVars() {
        return this.useVars;
    }

    public void setUseVars(boolean isUseVars) {
        this.useVars = isUseVars;
    }

    public boolean isCustomSqlEnabled() {
        return this.customSqlEnabled;
    }

    public void setCustomSqlEnabled(boolean isCustomSql) {
        this.customSqlEnabled = isCustomSql;
    }

    public String getCustomSql() {
        return this.customSql;
    }

    public void setCustomSql(String customSql) {
        this.customSql = customSql;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getMaximumTimeout() {
        return this.maximumTimeout;
    }

    public void setMaximumTimeout(String maximumTimeout) {
        this.maximumTimeout = maximumTimeout;
    }

    public String getCheckCycleTime() {
        return this.checkCycleTime;
    }

    public void setCheckCycleTime(String checkCycleTime) {
        this.checkCycleTime = checkCycleTime;
    }

    public boolean isSuccessOnTimeout() {
        return this.successOnTimeout;
    }

    public void setSuccessOnTimeout(boolean successOnTimeout) {
        this.successOnTimeout = successOnTimeout;
    }

    public static String getSelectCount() {
        return SELECT_COUNT;
    }

    public String getRowsCountValue() {
        return this.rowsCountValue;
    }

    public void setRowsCountValue(String rowsCountValue) {
        this.rowsCountValue = rowsCountValue;
    }

    public void setSuccessCondition(SuccessCondition successCondition) {
        this.successCondition = successCondition;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public static enum SuccessCondition implements IEnumHasCodeAndDescription
    {
        ROWS_COUNT_EQUAL("rows_count_equal", BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessWhenRowCountEqual.Label", (String[])new String[0])),
        ROWS_COUNT_DIFFERENT("rows_count_different", BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessWhenRowCountDifferent.Label", (String[])new String[0])),
        ROWS_COUNT_SMALLER("rows_count_smaller", BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessWhenRowCountSmallerThan.Label", (String[])new String[0])),
        ROWS_COUNT_SMALLER_EQUAL("rows_count_smaller_equal", BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessWhenRowCountSmallerOrEqualThan.Label", (String[])new String[0])),
        ROWS_COUNT_GREATER("rows_count_greater", BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessWhenRowCountGreaterThan.Label", (String[])new String[0])),
        ROWS_COUNT_GREATER_EQUAL("rows_count_greater_equal", BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessWhenRowCountGreaterOrEqual.Label", (String[])new String[0]));

        private final String code;
        private final String description;

        private SuccessCondition(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(SuccessCondition.class);
        }

        public static SuccessCondition lookupDescription(String description) {
            return (SuccessCondition)IEnumHasCodeAndDescription.lookupDescription(SuccessCondition.class, (String)description, (IEnumHasCodeAndDescription)ROWS_COUNT_EQUAL);
        }

        public static SuccessCondition lookupCode(String code) {
            return (SuccessCondition)IEnumHasCode.lookupCode(SuccessCondition.class, (String)code, (IEnumHasCode)ROWS_COUNT_EQUAL);
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

