/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.aws.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import java.util.List;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.aws.sqs.SqsReaderMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SqsReaderDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = SqsReaderMeta.class;
    private SqsReaderMeta meta;
    private ComboVar tAWSCredChain;
    private Label lblAWSKey;
    private TextVar tAWSKey;
    private Label lblAWSKeySecret;
    private PasswordTextVar tAWSKeySecret;
    private Label lblAWSRegion;
    private ComboVar tAWSRegion;
    private TextVar tMessageID;
    private TextVar tMessageBody;
    private TextVar tReceiptHandle;
    private TextVar tBodyMD5;
    private ComboVar tMessageDelete;
    private TextVar tSQSQueue;
    private TextVar tMaxMessages;
    private TextVar tSNSMessage;

    public SqsReaderDialog(Shell parent, IVariables variables, SqsReaderMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.meta = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.meta);
        this.changed = this.meta.hasChanged();
        ModifyListener lsMod = e -> this.meta.setChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SQSReader.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder tabFolder = new CTabFolder((Composite)this.shell, 2048);
        FormData fdTabFolder = new FormData();
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.bottom = new FormAttachment(100, -50);
        tabFolder.setLayoutData((Object)fdTabFolder);
        PropsUi.setLook((Widget)tabFolder);
        CTabItem tbtmSettings = new CTabItem(tabFolder, 0);
        tbtmSettings.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.Title", (String[])new String[0]));
        ScrolledComposite scrlSettingsComp = new ScrolledComposite((Composite)tabFolder, 768);
        scrlSettingsComp.setLayout((Layout)new FillLayout());
        PropsUi.setLook((Widget)scrlSettingsComp);
        Composite settingsComp = new Composite((Composite)scrlSettingsComp, 0);
        PropsUi.setLook((Widget)settingsComp);
        FormLayout settingsLayout = new FormLayout();
        settingsLayout.marginWidth = 3;
        settingsLayout.marginHeight = 3;
        settingsComp.setLayout((Layout)settingsLayout);
        Label lblAWSCredChain = new Label(settingsComp, 131072);
        PropsUi.setLook((Widget)lblAWSCredChain);
        FormData fdLblAWSCredChain = new FormData();
        fdLblAWSCredChain.left = new FormAttachment(0, 0);
        fdLblAWSCredChain.top = new FormAttachment(0, margin);
        fdLblAWSCredChain.right = new FormAttachment(middle, -margin);
        lblAWSCredChain.setLayoutData((Object)fdLblAWSCredChain);
        lblAWSCredChain.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSCredChain.Label", (String[])new String[0]));
        this.tAWSCredChain = new ComboVar(this.variables, settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSCredChain);
        FormData fdTAWSCredChain = new FormData();
        fdTAWSCredChain.top = new FormAttachment(0, margin);
        fdTAWSCredChain.left = new FormAttachment(middle, 0);
        fdTAWSCredChain.right = new FormAttachment(100, 0);
        this.tAWSCredChain.setLayoutData((Object)fdTAWSCredChain);
        this.tAWSCredChain.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSCredChain.Tooltip", (String[])new String[0]));
        this.tAWSCredChain.addModifyListener(arg0 -> this.changeCredentialChainSelection());
        this.lblAWSKey = new Label(settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblAWSKey);
        FormData fdLblAWSKey = new FormData();
        fdLblAWSKey.left = new FormAttachment(0, 0);
        fdLblAWSKey.top = new FormAttachment((Control)this.tAWSCredChain, margin);
        fdLblAWSKey.right = new FormAttachment(middle, -margin);
        this.lblAWSKey.setLayoutData((Object)fdLblAWSKey);
        this.lblAWSKey.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSKey.Label", (String[])new String[0]));
        this.tAWSKey = new TextVar(this.variables, settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSKey);
        FormData fdTAWSKey = new FormData();
        fdTAWSKey.top = new FormAttachment((Control)this.tAWSCredChain, margin);
        fdTAWSKey.left = new FormAttachment(middle, 0);
        fdTAWSKey.right = new FormAttachment(100, 0);
        this.tAWSKey.setLayoutData((Object)fdTAWSKey);
        this.tAWSKey.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSKey.Tooltip", (String[])new String[0]));
        this.lblAWSKeySecret = new Label(settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblAWSKeySecret);
        FormData fdLblAWSKeySecret = new FormData();
        fdLblAWSKeySecret.left = new FormAttachment(0, 0);
        fdLblAWSKeySecret.top = new FormAttachment((Control)this.tAWSKey, margin);
        fdLblAWSKeySecret.right = new FormAttachment(middle, -margin);
        this.lblAWSKeySecret.setLayoutData((Object)fdLblAWSKeySecret);
        this.lblAWSKeySecret.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSKeySecret.Label", (String[])new String[0]));
        this.tAWSKeySecret = new PasswordTextVar(this.variables, settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSKeySecret);
        FormData fdTAWSKeySecret = new FormData();
        fdTAWSKeySecret.top = new FormAttachment((Control)this.tAWSKey, margin);
        fdTAWSKeySecret.left = new FormAttachment(middle, 0);
        fdTAWSKeySecret.right = new FormAttachment(100, 0);
        this.tAWSKeySecret.setLayoutData((Object)fdTAWSKeySecret);
        this.tAWSKeySecret.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSKeySecret.Tooltip", (String[])new String[0]));
        this.lblAWSRegion = new Label(settingsComp, 131072);
        PropsUi.setLook((Widget)this.lblAWSRegion);
        FormData fdLblAWSRegion = new FormData();
        fdLblAWSRegion.left = new FormAttachment(0, 0);
        fdLblAWSRegion.top = new FormAttachment((Control)this.tAWSKeySecret, margin);
        fdLblAWSRegion.right = new FormAttachment(middle, -margin);
        this.lblAWSRegion.setLayoutData((Object)fdLblAWSRegion);
        this.lblAWSRegion.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSRegion.Label", (String[])new String[0]));
        this.tAWSRegion = new ComboVar(this.variables, settingsComp, 18436);
        PropsUi.setLook((Widget)this.tAWSRegion);
        FormData fdTAWSRegion = new FormData();
        fdTAWSRegion.top = new FormAttachment((Control)this.tAWSKeySecret, margin);
        fdTAWSRegion.left = new FormAttachment(middle, 0);
        fdTAWSRegion.right = new FormAttachment(100, 0);
        this.tAWSRegion.setLayoutData((Object)fdTAWSRegion);
        this.tAWSRegion.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.AWSRegion.Tooltip", (String[])new String[0]));
        this.populateAWSRegion(this.tAWSRegion);
        Label lblSQSQueue = new Label(settingsComp, 131072);
        PropsUi.setLook((Widget)lblSQSQueue);
        FormData fdLblSQSQueue = new FormData();
        fdLblSQSQueue.left = new FormAttachment(0, 0);
        fdLblSQSQueue.top = new FormAttachment((Control)this.tAWSRegion, margin);
        fdLblSQSQueue.right = new FormAttachment(middle, -margin);
        lblSQSQueue.setLayoutData((Object)fdLblSQSQueue);
        lblSQSQueue.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.SQSQueue.Label", (String[])new String[0]));
        this.tSQSQueue = new TextVar(this.variables, settingsComp, 18436);
        PropsUi.setLook((Widget)this.tSQSQueue);
        FormData fdTSQSQueue = new FormData();
        fdTSQSQueue.top = new FormAttachment((Control)this.tAWSRegion, margin);
        fdTSQSQueue.left = new FormAttachment(middle, 0);
        fdTSQSQueue.right = new FormAttachment(100, 0);
        this.tSQSQueue.setLayoutData((Object)fdTSQSQueue);
        this.tSQSQueue.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.Settings.SQSQueue.Tooltip", (String[])new String[0]));
        Control[] queueTabList = new Control[]{this.tAWSCredChain, this.tAWSKey, this.tAWSKeySecret, this.tAWSRegion};
        settingsComp.setTabList(queueTabList);
        settingsComp.pack();
        Rectangle settingsBounds = settingsComp.getBounds();
        scrlSettingsComp.setContent((Control)settingsComp);
        scrlSettingsComp.setExpandHorizontal(true);
        scrlSettingsComp.setExpandVertical(true);
        scrlSettingsComp.setMinWidth(settingsBounds.width);
        scrlSettingsComp.setMinHeight(settingsBounds.height);
        CTabItem tbtmReaderOutput = new CTabItem(tabFolder, 0);
        tbtmReaderOutput.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.Title", (String[])new String[0]));
        ScrolledComposite scrlreaderOutputComp = new ScrolledComposite((Composite)tabFolder, 768);
        scrlreaderOutputComp.setLayout((Layout)new FillLayout());
        PropsUi.setLook((Widget)scrlreaderOutputComp);
        Composite readerOutputComp = new Composite((Composite)scrlreaderOutputComp, 0);
        PropsUi.setLook((Widget)readerOutputComp);
        FormLayout readerOutputLayout = new FormLayout();
        readerOutputLayout.marginWidth = 3;
        readerOutputLayout.marginHeight = 3;
        readerOutputComp.setLayout((Layout)readerOutputLayout);
        Group grpOutputSettings = new Group(readerOutputComp, 32);
        PropsUi.setLook((Widget)grpOutputSettings);
        grpOutputSettings.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.OutputSettings.GroupTitle", (String[])new String[0]));
        FormData fdGrpOutputSettings = new FormData();
        fdGrpOutputSettings.top = new FormAttachment(0, margin);
        fdGrpOutputSettings.left = new FormAttachment(0, margin);
        fdGrpOutputSettings.right = new FormAttachment(100, -margin);
        fdGrpOutputSettings.bottom = new FormAttachment(40, -margin);
        grpOutputSettings.setLayoutData((Object)fdGrpOutputSettings);
        FormLayout outputSettingsLayout = new FormLayout();
        outputSettingsLayout.marginWidth = 10;
        outputSettingsLayout.marginHeight = 10;
        grpOutputSettings.setLayout((Layout)outputSettingsLayout);
        Label lblMessageDelete = new Label((Composite)grpOutputSettings, 131072);
        PropsUi.setLook((Widget)lblMessageDelete);
        FormData fdLblMessageDelete = new FormData();
        fdLblMessageDelete.left = new FormAttachment(0, 0);
        fdLblMessageDelete.top = new FormAttachment(0, margin);
        fdLblMessageDelete.right = new FormAttachment(middle, -margin);
        lblMessageDelete.setLayoutData((Object)fdLblMessageDelete);
        lblMessageDelete.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MessageDelete.Label", (String[])new String[0]));
        this.tMessageDelete = new ComboVar(this.variables, (Composite)grpOutputSettings, 18436);
        PropsUi.setLook((Widget)this.tMessageDelete);
        FormData fdTMessageDelete = new FormData();
        fdTMessageDelete.top = new FormAttachment(0, margin);
        fdTMessageDelete.left = new FormAttachment(middle, 0);
        fdTMessageDelete.right = new FormAttachment(100, 0);
        this.tMessageDelete.setLayoutData((Object)fdTMessageDelete);
        this.tMessageDelete.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MessageDelete.Tooltip", (String[])new String[0]));
        Label lblMaxMessages = new Label((Composite)grpOutputSettings, 131072);
        PropsUi.setLook((Widget)lblMaxMessages);
        FormData fdLblMaxMessages = new FormData();
        fdLblMaxMessages.left = new FormAttachment(0, 0);
        fdLblMaxMessages.top = new FormAttachment((Control)this.tMessageDelete, margin);
        fdLblMaxMessages.right = new FormAttachment(middle, -margin);
        lblMaxMessages.setLayoutData((Object)fdLblMaxMessages);
        lblMaxMessages.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MaxMessages.Label", (String[])new String[0]));
        this.tMaxMessages = new TextVar(this.variables, (Composite)grpOutputSettings, 18436);
        PropsUi.setLook((Widget)this.tMaxMessages);
        FormData fdTMaxMessages = new FormData();
        fdTMaxMessages.top = new FormAttachment((Control)this.tMessageDelete, margin);
        fdTMaxMessages.left = new FormAttachment(middle, 0);
        fdTMaxMessages.right = new FormAttachment(100, 0);
        this.tMaxMessages.setLayoutData((Object)fdTMaxMessages);
        this.tMaxMessages.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MaxMessages.Tooltip", (String[])new String[0]));
        Control[] readerSettingsTabList = new Control[]{this.tMessageDelete, this.tMaxMessages};
        grpOutputSettings.setTabList(readerSettingsTabList);
        Group grpOutputField = new Group(readerOutputComp, 32);
        PropsUi.setLook((Widget)grpOutputField);
        grpOutputField.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.OutputFields.GroupTitle", (String[])new String[0]));
        FormData fdGrpOutputField = new FormData();
        fdGrpOutputField.top = new FormAttachment(40, margin);
        fdGrpOutputField.left = new FormAttachment(0, margin);
        fdGrpOutputField.right = new FormAttachment(100, -margin);
        fdGrpOutputField.bottom = new FormAttachment(100, -margin);
        grpOutputField.setLayoutData((Object)fdGrpOutputField);
        FormLayout outputFieldsLayout = new FormLayout();
        outputFieldsLayout.marginWidth = 10;
        outputFieldsLayout.marginHeight = 10;
        grpOutputField.setLayout((Layout)outputFieldsLayout);
        Label lblMessageID = new Label((Composite)grpOutputField, 131072);
        PropsUi.setLook((Widget)lblMessageID);
        FormData fdLblMessageID = new FormData();
        fdLblMessageID.left = new FormAttachment(0, 0);
        fdLblMessageID.top = new FormAttachment(0, margin);
        fdLblMessageID.right = new FormAttachment(middle, -margin);
        lblMessageID.setLayoutData((Object)fdLblMessageID);
        lblMessageID.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MessageID.Label", (String[])new String[0]));
        this.tMessageID = new TextVar(this.variables, (Composite)grpOutputField, 18436);
        PropsUi.setLook((Widget)this.tMessageID);
        FormData fdTMessageID = new FormData();
        fdTMessageID.top = new FormAttachment(0, margin);
        fdTMessageID.left = new FormAttachment(middle, 0);
        fdTMessageID.right = new FormAttachment(100, 0);
        this.tMessageID.setLayoutData((Object)fdTMessageID);
        this.tMessageID.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MessageID.Tooltip", (String[])new String[0]));
        Label lblMessageBody = new Label((Composite)grpOutputField, 131072);
        PropsUi.setLook((Widget)lblMessageBody);
        FormData fdLblMessageBody = new FormData();
        fdLblMessageBody.left = new FormAttachment(0, 0);
        fdLblMessageBody.top = new FormAttachment((Control)this.tMessageID, margin);
        fdLblMessageBody.right = new FormAttachment(middle, -margin);
        lblMessageBody.setLayoutData((Object)fdLblMessageBody);
        lblMessageBody.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MessageBody.Label", (String[])new String[0]));
        this.tMessageBody = new TextVar(this.variables, (Composite)grpOutputField, 18436);
        PropsUi.setLook((Widget)this.tMessageBody);
        FormData fdTMessageBody = new FormData();
        fdTMessageBody.top = new FormAttachment((Control)this.tMessageID, margin);
        fdTMessageBody.left = new FormAttachment(middle, 0);
        fdTMessageBody.right = new FormAttachment(100, 0);
        this.tMessageBody.setLayoutData((Object)fdTMessageBody);
        this.tMessageBody.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.MessageBody.Tooltip", (String[])new String[0]));
        Label lblReceiptHandle = new Label((Composite)grpOutputField, 131072);
        PropsUi.setLook((Widget)lblReceiptHandle);
        FormData fdLblReceiptHandle = new FormData();
        fdLblReceiptHandle.left = new FormAttachment(0, 0);
        fdLblReceiptHandle.top = new FormAttachment((Control)this.tMessageBody, margin);
        fdLblReceiptHandle.right = new FormAttachment(middle, -margin);
        lblReceiptHandle.setLayoutData((Object)fdLblReceiptHandle);
        lblReceiptHandle.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.ReceiptHandle.Label", (String[])new String[0]));
        this.tReceiptHandle = new TextVar(this.variables, (Composite)grpOutputField, 18436);
        PropsUi.setLook((Widget)this.tReceiptHandle);
        FormData fdTReceiptHandle = new FormData();
        fdTReceiptHandle.top = new FormAttachment((Control)this.tMessageBody, margin);
        fdTReceiptHandle.left = new FormAttachment(middle, 0);
        fdTReceiptHandle.right = new FormAttachment(100, 0);
        this.tReceiptHandle.setLayoutData((Object)fdTReceiptHandle);
        this.tReceiptHandle.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.ReceiptHandle.Tooltip", (String[])new String[0]));
        Label lblBodyMD5 = new Label((Composite)grpOutputField, 131072);
        PropsUi.setLook((Widget)lblBodyMD5);
        FormData fdLblBodyMD5 = new FormData();
        fdLblBodyMD5.left = new FormAttachment(0, 0);
        fdLblBodyMD5.top = new FormAttachment((Control)this.tReceiptHandle, margin);
        fdLblBodyMD5.right = new FormAttachment(middle, -margin);
        lblBodyMD5.setLayoutData((Object)fdLblBodyMD5);
        lblBodyMD5.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.BodyMD5.Label", (String[])new String[0]));
        this.tBodyMD5 = new TextVar(this.variables, (Composite)grpOutputField, 18436);
        PropsUi.setLook((Widget)this.tBodyMD5);
        FormData fdTBodyMD5 = new FormData();
        fdTBodyMD5.top = new FormAttachment((Control)this.tReceiptHandle, margin);
        fdTBodyMD5.left = new FormAttachment(middle, 0);
        fdTBodyMD5.right = new FormAttachment(100, 0);
        this.tBodyMD5.setLayoutData((Object)fdTBodyMD5);
        this.tBodyMD5.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.BodyMD5.Tooltip", (String[])new String[0]));
        Label lblSNSMessage = new Label((Composite)grpOutputField, 131072);
        PropsUi.setLook((Widget)lblSNSMessage);
        FormData fdLblSNSMessage = new FormData();
        fdLblSNSMessage.left = new FormAttachment(0, 0);
        fdLblSNSMessage.top = new FormAttachment((Control)this.tBodyMD5, margin);
        fdLblSNSMessage.right = new FormAttachment(middle, -margin);
        lblSNSMessage.setLayoutData((Object)fdLblSNSMessage);
        lblSNSMessage.setText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.SNSMessage.Label", (String[])new String[0]));
        this.tSNSMessage = new TextVar(this.variables, (Composite)grpOutputField, 18436);
        PropsUi.setLook((Widget)this.tSNSMessage);
        FormData fdTSNSMessage = new FormData();
        fdTSNSMessage.top = new FormAttachment((Control)this.tBodyMD5, margin);
        fdTSNSMessage.left = new FormAttachment(middle, 0);
        fdTSNSMessage.right = new FormAttachment(100, 0);
        this.tSNSMessage.setLayoutData((Object)fdTSNSMessage);
        this.tSNSMessage.setToolTipText(BaseMessages.getString(PKG, (String)"SQSReaderTransform.ReaderOutput.SNSMessage.Tooltip", (String[])new String[0]));
        Control[] readerOutputTabList = new Control[]{this.tMessageID, this.tMessageBody, this.tReceiptHandle, this.tBodyMD5, this.tSNSMessage};
        grpOutputField.setTabList(readerOutputTabList);
        readerOutputComp.pack();
        Rectangle readerOutputBounds = readerOutputComp.getBounds();
        scrlreaderOutputComp.setContent((Control)readerOutputComp);
        scrlreaderOutputComp.setExpandHorizontal(true);
        scrlreaderOutputComp.setExpandVertical(true);
        scrlreaderOutputComp.setMinWidth(readerOutputBounds.width);
        scrlreaderOutputComp.setMinHeight(readerOutputBounds.height);
        scrlSettingsComp.layout();
        tbtmSettings.setControl((Control)scrlSettingsComp);
        scrlreaderOutputComp.layout();
        tbtmReaderOutput.setControl((Control)scrlreaderOutputComp);
        tabFolder.setSelection(0);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)margin, null);
        this.wOk.addListener(13, c -> this.ok());
        this.wCancel.addListener(13, c -> this.cancel());
        SelectionAdapter lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SqsReaderDialog.this.ok();
            }
        };
        this.wTransformName.addSelectionListener((SelectionListener)lsDef);
        this.tAWSKey.addSelectionListener(lsDef);
        this.tAWSKeySecret.addSelectionListener(lsDef);
        this.tAWSRegion.addSelectionListener((SelectionListener)lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SqsReaderDialog.this.cancel();
            }
        });
        this.setSize();
        this.populateYesNoSelection();
        this.populateDialog();
        this.meta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.transformName;
    }

    protected void changeCredentialChainSelection() {
        if (this.tAWSCredChain.getText().equalsIgnoreCase("Y")) {
            this.lblAWSKey.setEnabled(false);
            this.tAWSKey.setEnabled(false);
            this.lblAWSKeySecret.setEnabled(false);
            this.tAWSKeySecret.setEnabled(false);
            this.lblAWSRegion.setEnabled(false);
            this.tAWSRegion.setEnabled(false);
        } else {
            this.lblAWSKey.setEnabled(true);
            this.tAWSKey.setEnabled(true);
            this.lblAWSKeySecret.setEnabled(true);
            this.tAWSKeySecret.setEnabled(true);
            this.lblAWSRegion.setEnabled(true);
            this.tAWSRegion.setEnabled(true);
        }
        this.meta.setChanged();
    }

    private void populateYesNoSelection() {
        this.tAWSCredChain.removeAll();
        this.tAWSCredChain.add("Y");
        this.tAWSCredChain.add("N");
        this.tAWSCredChain.select(0);
        this.tMessageDelete.removeAll();
        this.tMessageDelete.add("Y");
        this.tMessageDelete.add("N");
        this.tMessageDelete.select(0);
    }

    private void populateAWSRegion(ComboVar tAWSRegion2) {
        tAWSRegion2.removeAll();
        try {
            List snsRegions = RegionUtils.getRegionsForService((String)"sqs");
            for (Region region : snsRegions) {
                tAWSRegion2.add(region.getName());
            }
        }
        catch (AmazonClientException e) {
            this.logError(BaseMessages.getString(PKG, (String)e.getMessage(), (String[])new String[0]));
        }
    }

    private void populateDialog() {
        this.wTransformName.selectAll();
        this.tAWSCredChain.setText(this.meta.getAwsCredChain());
        this.tAWSKey.setText(this.meta.getAwsKey());
        this.tAWSKeySecret.setText(this.meta.getAwsKeySecret());
        this.tAWSRegion.setText(this.meta.getAwsRegion());
        this.tSQSQueue.setText(this.meta.getSqsQueue());
        this.tMessageDelete.setText(this.meta.getTFldMessageDelete());
        this.tMaxMessages.setText(this.meta.getTFldMaxMessages());
        this.tMessageID.setText(this.meta.getTFldMessageID());
        this.tMessageBody.setText(this.meta.getTFldMessageBody());
        this.tReceiptHandle.setText(this.meta.getTFldReceiptHandle());
        this.tBodyMD5.setText(this.meta.getTFldBodyMD5());
        this.tSNSMessage.setText(this.meta.getTFldSNSMessage());
    }

    private void cancel() {
        this.transformName = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        this.transformName = this.wTransformName.getText();
        this.meta.setAwsCredChain(this.tAWSCredChain.getText());
        this.meta.setAwsKey(this.tAWSKey.getText());
        this.meta.setAwsKeySecret(this.tAWSKeySecret.getText());
        this.meta.setAwsRegion(this.tAWSRegion.getText());
        this.meta.setSqsQueue(this.tSQSQueue.getText());
        this.meta.setTFldMessageDelete(this.tMessageDelete.getText());
        this.meta.setTFldMaxMessages(this.tMaxMessages.getText());
        this.meta.setTFldMessageID(this.tMessageID.getText());
        this.meta.setTFldMessageBody(this.tMessageBody.getText());
        this.meta.setTFldReceiptHandle(this.tReceiptHandle.getText());
        this.meta.setTFldBodyMD5(this.tBodyMD5.getText());
        this.meta.setTFldSNSMessage(this.tSNSMessage.getText());
        this.dispose();
    }
}

