/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hcatalog;

import java.util.ArrayList;
import java.util.Map;
import org.apache.beam.sdk.io.hcatalog.SchemaUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class HCatalogBeamSchema {
    private final @Nullable @UnknownKeyFor @Initialized IMetaStoreClient metastore;

    private HCatalogBeamSchema(@UnknownKeyFor @NonNull @Initialized IMetaStoreClient metastore) {
        this.metastore = metastore;
    }

    public static @UnknownKeyFor @NonNull @Initialized HCatalogBeamSchema create(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> config) {
        try {
            HiveConf hiveConf = new HiveConf();
            config.forEach((arg_0, arg_1) -> ((HiveConf)hiveConf).set(arg_0, arg_1));
            return new HCatalogBeamSchema((IMetaStoreClient)new HiveMetaStoreClient((Configuration)hiveConf));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasDatabase(@UnknownKeyFor @NonNull @Initialized String dbName) {
        try {
            this.metastore.getDatabase(dbName);
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Schema> getTableSchema(@UnknownKeyFor @NonNull @Initialized String db, @UnknownKeyFor @NonNull @Initialized String table) {
        try {
            Table metastoreTable = this.metastore.getTable(db, table);
            ArrayList fields = Lists.newArrayList((Iterable)metastoreTable.getSd().getCols());
            fields.addAll(metastoreTable.getPartitionKeys());
            Schema schema = SchemaUtils.toBeamSchema(fields);
            return Optional.of((Object)schema);
        }
        catch (NoSuchObjectException e) {
            return Optional.absent();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

