/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.graph.flownetwork;

import org.psjava.algo.graph.flownetwork.MaximumFlowAlgorithmResult;
import org.psjava.algo.math.FunctionFromMap;
import org.psjava.ds.graph.FlowNetworkEdge;
import org.psjava.ds.graph.Graph;
import org.psjava.ds.map.MutableMap;
import org.psjava.ds.math.Function;
import org.psjava.ds.numbersystrem.AddableNumberSystem;
import org.psjava.goods.GoodMutableMapFactory;

public class MaximumFlowAlgorithmResultFactory {
    public static <V, F, E> MaximumFlowAlgorithmResult<F, E> create(final Graph<V, FlowNetworkEdge<V, F, E>> flowNetwork, final V start, final AddableNumberSystem<F> ns) {
        return new MaximumFlowAlgorithmResult<F, E>(){

            @Override
            public F calcTotalFlow() {
                Object total = ns.getZero();
                for (FlowNetworkEdge e : flowNetwork.getEdges(start)) {
                    total = ns.add(total, e.getFlowStatus().flow);
                }
                return total;
            }

            @Override
            public Function<E, F> calcFlowFunction() {
                MutableMap flow = GoodMutableMapFactory.getInstance().create();
                for (Object v : flowNetwork.getVertices()) {
                    for (FlowNetworkEdge e : flowNetwork.getEdges(v)) {
                        if (e.isSkewSymmetryEdge()) continue;
                        flow.add(e.getOriginalCapacityEdge(), e.getFlowStatus().flow);
                    }
                }
                return FunctionFromMap.wrap(flow);
            }
        };
    }

    private MaximumFlowAlgorithmResultFactory() {
    }
}

